"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import pydantic
from speakeasy.new_openapi.types import BaseModel
from speakeasy.new_openapi.utils import FieldMetadata, SecurityMetadata
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class SecurityOption1TypedDict(TypedDict):
    username: str
    password: str


class SecurityOption1(BaseModel):
    username: Annotated[
        str,
        FieldMetadata(
            security=SecurityMetadata(
                scheme=True, scheme_type="http", sub_type="basic", field_name="username"
            )
        ),
    ]

    password: Annotated[
        str,
        FieldMetadata(
            security=SecurityMetadata(
                scheme=True, scheme_type="http", sub_type="basic", field_name="password"
            )
        ),
    ]


class SecurityOption2TypedDict(TypedDict):
    bearer_auth: str
    api_key: str


class SecurityOption2(BaseModel):
    bearer_auth: Annotated[
        str,
        FieldMetadata(
            security=SecurityMetadata(
                scheme=True,
                scheme_type="http",
                sub_type="bearer",
                field_name="Authorization",
            )
        ),
    ]

    api_key: Annotated[
        str,
        FieldMetadata(
            security=SecurityMetadata(
                scheme=True,
                scheme_type="apiKey",
                sub_type="header",
                field_name="api_key",
            )
        ),
    ]


class SecurityOption3TypedDict(TypedDict):
    oauth2: str


class SecurityOption3(BaseModel):
    oauth2: Annotated[
        str,
        FieldMetadata(
            security=SecurityMetadata(
                scheme=True, scheme_type="oauth2", field_name="Authorization"
            )
        ),
    ]


class SecurityOption4TypedDict(TypedDict):
    app_id: str
    secret: str


class SecurityOption4(BaseModel):
    app_id: Annotated[
        str,
        pydantic.Field(alias="appId"),
        FieldMetadata(
            security=SecurityMetadata(
                scheme=True, scheme_type="http", sub_type="custom", field_name="appId"
            )
        ),
    ]

    secret: Annotated[
        str,
        FieldMetadata(
            security=SecurityMetadata(
                scheme=True, scheme_type="http", sub_type="custom", field_name="secret"
            )
        ),
    ]


class SecurityOption5TypedDict(TypedDict):
    mobile_auth: str


class SecurityOption5(BaseModel):
    mobile_auth: Annotated[
        str,
        FieldMetadata(
            security=SecurityMetadata(
                scheme=True, scheme_type="oauth2", field_name="Authorization"
            )
        ),
    ]


class SecurityOption6TypedDict(TypedDict):
    client_id: str
    client_secret: str
    token_url: str


class SecurityOption6(BaseModel):
    client_id: Annotated[
        str,
        FieldMetadata(
            security=SecurityMetadata(
                scheme=True,
                scheme_type="oauth2",
                sub_type="client_credentials",
                field_name="clientID",
            )
        ),
    ]

    client_secret: Annotated[
        str,
        FieldMetadata(
            security=SecurityMetadata(
                scheme=True,
                scheme_type="oauth2",
                sub_type="client_credentials",
                field_name="clientSecret",
            )
        ),
    ]

    token_url: str = "/clientcredentials/token"


class SecurityOption7TypedDict(TypedDict):
    api_key: str


class SecurityOption7(BaseModel):
    api_key: Annotated[
        str,
        FieldMetadata(
            security=SecurityMetadata(
                scheme=True,
                scheme_type="apiKey",
                sub_type="header",
                field_name="api_key",
            )
        ),
    ]


class SecurityTypedDict(TypedDict):
    option1: NotRequired[SecurityOption1TypedDict]
    option2: NotRequired[SecurityOption2TypedDict]
    option3: NotRequired[SecurityOption3TypedDict]
    option4: NotRequired[SecurityOption4TypedDict]
    option5: NotRequired[SecurityOption5TypedDict]
    option6: NotRequired[SecurityOption6TypedDict]
    option7: NotRequired[SecurityOption7TypedDict]


class Security(BaseModel):
    option1: Annotated[
        Optional[SecurityOption1], FieldMetadata(security=SecurityMetadata(option=True))
    ] = None

    option2: Annotated[
        Optional[SecurityOption2], FieldMetadata(security=SecurityMetadata(option=True))
    ] = None

    option3: Annotated[
        Optional[SecurityOption3], FieldMetadata(security=SecurityMetadata(option=True))
    ] = None

    option4: Annotated[
        Optional[SecurityOption4], FieldMetadata(security=SecurityMetadata(option=True))
    ] = None

    option5: Annotated[
        Optional[SecurityOption5], FieldMetadata(security=SecurityMetadata(option=True))
    ] = None

    option6: Annotated[
        Optional[SecurityOption6], FieldMetadata(security=SecurityMetadata(option=True))
    ] = None

    option7: Annotated[
        Optional[SecurityOption7], FieldMetadata(security=SecurityMetadata(option=True))
    ] = None
