import typing

import typing_extensions
from _typeshed import Incomplete

__all__ = ["Lock", "RLock", "Semaphore", "BoundedSemaphore", "Condition", "Event"]

_T = typing_extensions.TypeVar("_T")

class SemLock:
    name: str | None
    def __init__(
        self, kind: Incomplete, value: int, maxvalue: Incomplete, name: str | None = ...
    ) -> None: ...
    def __enter__(self) -> Incomplete: ...
    def __exit__(self, *args: object) -> typing.Any: ...

class Semaphore(SemLock):
    def __init__(self, value: int = ...) -> None: ...
    def get_value(self) -> int: ...

class BoundedSemaphore(Semaphore):
    def __init__(self, value: int = ...) -> None: ...

class Lock(SemLock):
    def __init__(self) -> None: ...

class RLock(SemLock):
    def __init__(self) -> None: ...

class Condition:
    def __init__(self, lock: Lock | RLock | None = ...) -> None: ...
    def __enter__(self) -> typing_extensions.Self: ...
    def __exit__(self, *args: object) -> typing.Any: ...
    def wait(self, timeout: float | None = ...) -> Incomplete: ...
    def notify(self) -> None: ...
    def notify_all(self) -> None: ...
    def wait_for(
        self, predicate: typing.Callable[[], _T], timeout: float | None = ...
    ) -> _T: ...

class Event:
    def __init__(self) -> None: ...
    def is_set(self) -> bool: ...
    def set(self) -> None: ...
    def clear(self) -> None: ...
    def wait(self, timeout: float | None = ...) -> bool: ...
