"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.flinkApplicationConfiguration = void 0;
/**
 * Build the nested Cfn FlinkApplicationConfiguration object. This function
 * doesn't return empty config objects, returning the minimal config needed to
 * express the supplied properties.
 *
 * This function also handles the quirky configType: 'CUSTOM' setting required
 * whenever config in one of the nested groupings.
 */
function flinkApplicationConfiguration(config) {
    const checkpointConfiguration = configFor({
        checkpointingEnabled: config.checkpointingEnabled,
        checkpointInterval: config.checkpointInterval?.toMilliseconds(),
        minPauseBetweenCheckpoints: config.minPauseBetweenCheckpoints?.toMilliseconds(),
    });
    const monitoringConfiguration = configFor({
        logLevel: config.logLevel,
        metricsLevel: config.metricsLevel,
    });
    const parallelismConfiguration = configFor({
        autoScalingEnabled: config.autoScalingEnabled,
        parallelism: config.parallelism,
        parallelismPerKpu: config.parallelismPerKpu,
    });
    const applicationConfiguration = {
        checkpointConfiguration,
        monitoringConfiguration,
        parallelismConfiguration,
    };
    if (isEmptyObj(applicationConfiguration)) {
        return;
    }
    return applicationConfiguration;
}
exports.flinkApplicationConfiguration = flinkApplicationConfiguration;
function configFor(config) {
    if (isEmptyObj(config)) {
        return;
    }
    return {
        ...config,
        configurationType: 'CUSTOM',
    };
}
function isEmptyObj(obj) {
    return Object.values(obj).every(v => v === undefined);
}
//# sourceMappingURL=data:application/json;base64,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