/*
 * Decompiled with CFR 0.152.
 */
package CDKdesc;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.aromaticity.ElectronDonation;
import org.openscience.cdk.fingerprint.AtomPairs2DFingerprinter;
import org.openscience.cdk.fingerprint.BitSetFingerprint;
import org.openscience.cdk.fingerprint.CircularFingerprinter;
import org.openscience.cdk.fingerprint.EStateFingerprinter;
import org.openscience.cdk.fingerprint.ExtendedFingerprinter;
import org.openscience.cdk.fingerprint.Fingerprinter;
import org.openscience.cdk.fingerprint.GraphOnlyFingerprinter;
import org.openscience.cdk.fingerprint.HybridizationFingerprinter;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.fingerprint.KlekotaRothFingerprinter;
import org.openscience.cdk.fingerprint.LingoFingerprinter;
import org.openscience.cdk.fingerprint.MACCSFingerprinter;
import org.openscience.cdk.fingerprint.PubchemFingerprinter;
import org.openscience.cdk.fingerprint.ShortestPathFingerprinter;
import org.openscience.cdk.fingerprint.SignatureFingerprinter;
import org.openscience.cdk.fingerprint.SubstructureFingerprinter;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.io.iterator.IteratingSDFReader;
import org.openscience.cdk.qsar.DescriptorEngine;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IDescriptor;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.AminoAcidCountDescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.JPlogPDescriptor;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class Main {
    public static void main(String[] args) throws Exception {
        block67: {
            DefaultParser parser = new DefaultParser();
            Options options = new Options();
            options.addOption("f", "fingerprint", true, "Calculate a specific fingerprint. \tMust be one of {FP, ExtFP, EStateFP, GraphFP, MACCSFP, PubchemFP,\n\tSubFP, KRFP, AP2DFP, HybridFP, LingoFP, SPFP, SigFP, CircFP}");
            options.addOption("nBits", true, "Number of bits of FP and GraphFP fingerprints (default: 1024)");
            options.addOption("depth", true, "Search depth of FP and GraphFP fingerprints (default: 6)");
            options.addOption("i", "input", true, "Input v2000 SD file");
            options.addOption("h", "help", false, "Shows this Help");
            try {
                CommandLine commandLine = parser.parse(options, args);
                DescriptorEngine descriptorEngine = new DescriptorEngine(IMolecularDescriptor.class, SilentChemObjectBuilder.getInstance());
                List<IDescriptor> descriptors = descriptorEngine.getDescriptorInstances();
                descriptors.add(new JPlogPDescriptor());
                ArrayList<String> fp_names = new ArrayList<String>(Arrays.asList("FP", "ExtFP", "EStateFP", "GraphFP", "MACCSFP", "PubchemFP", "SubFP", "KRFP", "AP2DFP", "HybridFP", "LingoFP", "SPFP", "SigFP", "CircFP"));
                if (commandLine.hasOption("help")) {
                    new HelpFormatter().printHelp("java -jar CDKdesc.jar", options);
                    break block67;
                }
                if (!commandLine.hasOption("input")) {
                    throw new Exception("Input V2000 SD file must be provided.");
                }
                if (commandLine.hasOption("fingerprint")) {
                    String fp_value = commandLine.getOptionValue("fingerprint");
                    if (!fp_names.contains(fp_value)) {
                        throw new Exception("Fingerprint type " + fp_value + " is not available.");
                    }
                    int size = 1024;
                    if (commandLine.hasOption("nBits")) {
                        size = Integer.parseInt(commandLine.getOptionValue("nBits"));
                    }
                    int searchDepth = 6;
                    if (commandLine.hasOption("searchDepth")) {
                        searchDepth = Integer.parseInt(commandLine.getOptionValue("searchDepth"));
                    }
                    IFingerprinter fp = switch (fp_value) {
                        case "FP" -> new Fingerprinter(size, searchDepth);
                        case "ExtFP" -> new ExtendedFingerprinter(size, searchDepth);
                        case "EStateFP" -> new EStateFingerprinter();
                        case "GraphFP" -> new GraphOnlyFingerprinter(size, searchDepth);
                        case "MACCSFP" -> new MACCSFingerprinter();
                        case "PubchemFP" -> new PubchemFingerprinter(SilentChemObjectBuilder.getInstance());
                        case "SubFP" -> new SubstructureFingerprinter();
                        case "KRFP" -> new KlekotaRothFingerprinter();
                        case "AP2DFP" -> new AtomPairs2DFingerprinter();
                        case "HybridFP" -> new HybridizationFingerprinter(size, searchDepth);
                        case "LingoFP" -> new LingoFingerprinter(searchDepth);
                        case "SPFP" -> new ShortestPathFingerprinter(size);
                        case "SigFP" -> new SignatureFingerprinter(searchDepth);
                        case "CircFP" -> new CircularFingerprinter();
                        default -> throw new Exception("Fingerprint type " + fp_value + " is not implemented.");
                    };
                    List<Object> value_names = new ArrayList();
                    boolean obtained_names = false;
                    try (FileInputStream fis = new FileInputStream(commandLine.getOptionValue("input"));){
                        IteratingSDFReader supplier = new IteratingSDFReader(fis, DefaultChemObjectBuilder.getInstance());
                        int idx_mol = 0;
                        while (supplier.hasNext()) {
                            Object[] bits;
                            IAtomContainer molecule = supplier.next();
                            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(molecule);
                            Aromaticity aromaticity = new Aromaticity(ElectronDonation.daylight(), Cycles.vertexShort());
                            aromaticity.apply(molecule);
                            IBitFingerprint fp_values = fp.getBitFingerprint(molecule);
                            if (fp_values instanceof BitSetFingerprint) {
                                BitSet fp_bitset = fp_values.asBitSet();
                                int fp_size = fp.getSize();
                                if (fp_size < 0) {
                                    fp_size = (int)fp_values.size();
                                }
                                bits = new String[fp_size];
                                Arrays.fill(bits, "0");
                                int idx = fp_bitset.nextSetBit(0);
                                while (idx >= 0) {
                                    bits[idx] = "1";
                                    idx = fp_bitset.nextSetBit(idx + 1);
                                }
                                if (!obtained_names) {
                                    value_names = IntStream.rangeClosed(1, fp_size).mapToObj(x -> fp_value + "_" + x).toList();
                                    obtained_names = true;
                                    System.out.println(String.join((CharSequence)" ", value_names));
                                }
                                System.out.println(String.join((CharSequence)" ", (CharSequence[])bits));
                                continue;
                            }
                            Map<String, Integer> raw_fp = fp.getRawFingerprint(molecule);
                            bits = new String[raw_fp.size()];
                            int index = 0;
                            for (Map.Entry<String, Integer> entry : raw_fp.entrySet()) {
                                bits[index] = "\"" + entry.getKey() + "\": " + entry.getValue().toString();
                                ++index;
                            }
                            System.out.println(String.valueOf(idx_mol) + ": {" + String.join((CharSequence)", ", (CharSequence[])bits) + "},");
                            ++idx_mol;
                        }
                        break block67;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    break block67;
                }
                ArrayList<String> value_names = new ArrayList<String>();
                boolean obtained_names = false;
                try (FileInputStream fis = new FileInputStream(commandLine.getOptionValue("input"));){
                    IteratingSDFReader supplier = new IteratingSDFReader(fis, DefaultChemObjectBuilder.getInstance());
                    while (supplier.hasNext()) {
                        IAtomContainer molecule = supplier.next();
                        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(molecule);
                        Aromaticity aromaticity = new Aromaticity(ElectronDonation.daylight(), Cycles.vertexShort());
                        aromaticity.apply(molecule);
                        boolean skip = false;
                        ArrayList<String> desc_values = new ArrayList<String>();
                        for (IDescriptor desc : descriptors) {
                            if (desc instanceof AminoAcidCountDescriptor) {
                                System.err.println("Skipping AminoAcidCountDescriptor");
                                continue;
                            }
                            try {
                                DescriptorValue raw_desc_vals = ((IMolecularDescriptor)desc).calculate(molecule);
                                if (!obtained_names) {
                                    value_names.addAll(List.of(raw_desc_vals.getNames()));
                                }
                                desc_values.addAll(List.of(raw_desc_vals.getValue().toString().split(",")));
                            }
                            catch (Exception e3) {
                                int size = ((IMolecularDescriptor)desc).getDescriptorNames().length;
                                List<String> nans = Collections.nCopies(size, "NaN");
                                desc_values.addAll(nans);
                            }
                        }
                        if (!obtained_names) {
                            System.out.println(String.join((CharSequence)" ", value_names));
                            obtained_names = true;
                        }
                        System.out.println(String.join((CharSequence)" ", desc_values));
                    }
                }
                catch (IOException iOException) {}
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }
}

