/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.api;

import com.apicatalog.jsonld.JsonLdEmbed;
import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.JsonLdVersion;
import com.apicatalog.jsonld.api.CommonApi;
import com.apicatalog.jsonld.api.ContextApi;
import com.apicatalog.jsonld.api.LoaderApi;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.processor.FramingProcessor;
import com.apicatalog.jsonld.uri.UriUtils;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import java.net.URI;

public final class FramingApi
implements CommonApi<FramingApi>,
LoaderApi<FramingApi>,
ContextApi<FramingApi> {
    private final Document document;
    private final URI documentUri;
    private final Document frame;
    private final URI frameUri;
    private JsonLdOptions options;

    public FramingApi(URI documentUri, URI frameUri) {
        this.document = null;
        this.documentUri = documentUri;
        this.frame = null;
        this.frameUri = frameUri;
        this.options = new JsonLdOptions();
    }

    public FramingApi(Document document, Document frame) {
        this.document = document;
        this.documentUri = null;
        this.frame = frame;
        this.frameUri = null;
        this.options = new JsonLdOptions();
    }

    @Override
    public FramingApi options(JsonLdOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Parameter 'options' is null.");
        }
        this.options = options;
        return this;
    }

    @Override
    public FramingApi context(URI contextUri) {
        this.options.setExpandContext(contextUri);
        return this;
    }

    @Override
    public FramingApi context(String contextLocation) {
        if (contextLocation != null) {
            if (UriUtils.isNotURI(contextLocation)) {
                throw new IllegalArgumentException("Context location must be valid URI or null but is [" + contextLocation + ".");
            }
            return this.context(UriUtils.create(contextLocation));
        }
        return this.context((URI)null);
    }

    @Override
    public FramingApi context(JsonStructure context2) {
        this.options.setExpandContext(context2 != null ? JsonDocument.of(context2) : null);
        return this;
    }

    @Override
    public FramingApi context(Document context2) {
        this.options.setExpandContext(context2);
        return this;
    }

    @Override
    public FramingApi mode(JsonLdVersion processingMode) {
        this.options.setProcessingMode(processingMode);
        return this;
    }

    @Override
    public FramingApi base(URI baseUri) {
        this.options.setBase(baseUri);
        return this;
    }

    @Override
    public FramingApi base(String baseUri) {
        return this.base(URI.create(baseUri));
    }

    @Override
    public FramingApi loader(DocumentLoader loader) {
        this.options.setDocumentLoader(loader);
        return this;
    }

    @Override
    public FramingApi ordered(boolean enable) {
        this.options.setOrdered(enable);
        return this;
    }

    public FramingApi embed(JsonLdEmbed value) {
        this.options.setEmbed(value);
        return this;
    }

    public FramingApi explicit(boolean enable) {
        this.options.setExplicit(enable);
        return this;
    }

    public FramingApi explicit() {
        return this.explicit(true);
    }

    public FramingApi omitDefault(boolean enable) {
        this.options.setOmitDefault(enable);
        return this;
    }

    public FramingApi omitDefault() {
        return this.omitDefault(true);
    }

    public FramingApi omitGraph(boolean enable) {
        this.options.setOmitGraph(enable);
        return this;
    }

    public FramingApi omitGraph() {
        return this.omitGraph(true);
    }

    public FramingApi requiredAll(boolean enable) {
        this.options.setRequiredAll(enable);
        return this;
    }

    public FramingApi requiredAll() {
        return this.requiredAll(true);
    }

    public JsonObject get() throws JsonLdError {
        if (this.documentUri != null && this.frameUri != null) {
            return FramingProcessor.frame(this.documentUri, this.frameUri, this.options);
        }
        if (this.document != null && this.frame != null) {
            return FramingProcessor.frame(this.document, this.frame, this.options);
        }
        throw new IllegalStateException();
    }
}

