/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection.internal.base;

import com.github.andrewoma.dexx.collection.Function;
import com.github.andrewoma.dexx.collection.Iterable;
import com.github.andrewoma.dexx.collection.Map;
import com.github.andrewoma.dexx.collection.Pair;
import com.github.andrewoma.dexx.collection.internal.adapter.MapAdapter;
import com.github.andrewoma.dexx.collection.internal.base.AbstractIterable;
import com.github.andrewoma.dexx.collection.internal.base.MappedIterable;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMap<K, V>
extends AbstractIterable<Pair<K, V>>
implements Map<K, V> {
    @Override
    @NotNull
    public Iterable<K> keys() {
        return new MappedIterable(this, new Function<Pair<K, V>, K>(){

            @Override
            public K invoke(Pair<K, V> pair2) {
                return pair2.component1();
            }
        });
    }

    @Override
    @NotNull
    public Iterable<V> values() {
        return new MappedIterable(this, new Function<Pair<K, V>, V>(){

            @Override
            public V invoke(Pair<K, V> pair2) {
                return pair2.component2();
            }
        });
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        try {
            for (Pair pair2 : this) {
                Object key = pair2.component1();
                Object value = pair2.component2();
                if (!(value == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException e2) {
            return false;
        }
        catch (NullPointerException e3) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        for (Pair pair2 : this) {
            h += 31 * pair2.hashCode();
        }
        return h;
    }

    @Override
    @NotNull
    public java.util.Map<K, V> asMap() {
        return new MapAdapter(this);
    }
}

