/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.http.auth;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jena.atlas.lib.Trie;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.http.auth.AuthDomain;
import org.apache.jena.http.auth.PasswordRecord;

public class AuthCredentials {
    private Map<AuthDomain, PasswordRecord> authRegistry = new ConcurrentHashMap<AuthDomain, PasswordRecord>();
    private Trie<AuthDomain> prefixes = new Trie();

    public void put(AuthDomain location, PasswordRecord pwRecord) {
        URI uri = location.uri;
        if (uri.getRawQuery() != null || uri.getRawFragment() != null) {
            throw new HttpException("Endpoint URI must not have query string or fragment: " + uri);
        }
        this.authRegistry.put(location, pwRecord);
        this.prefixes.add(uri.toString(), location);
    }

    public boolean contains(AuthDomain location) {
        return this.prefixes.contains(location.uri.toString());
    }

    public List<AuthDomain> registered() {
        return new ArrayList<AuthDomain>(this.authRegistry.keySet());
    }

    public PasswordRecord get(AuthDomain location) {
        PasswordRecord pwRecord = this.authRegistry.get(location);
        if (pwRecord != null) {
            return pwRecord;
        }
        this.prefixes.partialSearch(location.uri.toString());
        AuthDomain match = this.prefixes.longestMatch(location.uri.toString());
        if (match == null) {
            return null;
        }
        if (match.getRealm() != null && location.getRealm() != null && !Objects.equals(location.getRealm(), match.getRealm())) {
            return null;
        }
        return this.authRegistry.get(match);
    }

    public void remove(AuthDomain location) {
        this.prefixes.remove(location.uri.toString());
        this.authRegistry.remove(location);
    }

    public void clearAll() {
        this.authRegistry.clear();
    }
}

