/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.util.Objects;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.irix.IRIs;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.sparql.util.Symbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysRIOT {
    public static final String riotLoggerName = "org.apache.jena.riot";
    private static Logger riotLogger = LoggerFactory.getLogger("org.apache.jena.riot");
    private static String riotBase = "http://jena.apache.org/riot/";
    private static boolean strictMode = false;
    public static final Symbol sysRdfWriterProperties = Symbol.create(riotBase + "rdfWriter_properties");
    public static final Symbol sysRdfReaderProperties = Symbol.create(riotBase + "rdfReader_properties");
    public static Symbol sysStreamManager = Symbol.create(riotBase + "streamManager");
    private static Boolean isJSONLD11 = null;
    private static ReaderRIOTFactory readerFactoryJsonldDft = null;
    private static ReaderRIOTFactory readerFactoryJsonld10;
    private static ReaderRIOTFactory readerFactoryJsonld11;

    public static void setStrictMode(boolean state) {
        strictMode = state;
    }

    public static boolean isStrictMode() {
        return strictMode;
    }

    public static String fmtMessage(String message, long line, long col) {
        if (col == -1L && line == -1L) {
            return message;
        }
        if (col == -1L && line != -1L) {
            return String.format("[line: %d] %s", line, message);
        }
        if (col != -1L && line == -1L) {
            return String.format("[col: %d] %s", col, message);
        }
        return String.format("[line: %d, col: %-2d] %s", line, col, message);
    }

    public static Logger getLogger() {
        return riotLogger;
    }

    @Deprecated
    public static String chooseBaseIRI() {
        return IRIs.getBaseStr();
    }

    @Deprecated
    public static String chooseBaseIRI(String baseURI) {
        return IRIs.toBase(baseURI);
    }

    public static String chooseBaseIRI(String baseIRI, String fileOrIri) {
        if (baseIRI != null) {
            return baseIRI;
        }
        if (fileOrIri == null || fileOrIri.equals("-")) {
            return "http://localhost/stdin/";
        }
        return IRIs.toBase(fileOrIri);
    }

    public static String filename2baseIRI(String filename) {
        if (filename == null || filename.equals("-")) {
            return "http://localhost/stdin/";
        }
        String x = IRILib.filenameToIRI(filename);
        return x;
    }

    public static void setDefaultJSONLD(String version2) {
        Objects.requireNonNull(version2, "Argument 'version' must be \"1.1\", \"1.0\" or \"\" (empty string)");
        if (readerFactoryJsonldDft == null) {
            readerFactoryJsonldDft = RDFParserRegistry.getFactory(Lang.JSONLD);
            readerFactoryJsonld10 = RDFParserRegistry.getFactory(Lang.JSONLD10);
            readerFactoryJsonld11 = RDFParserRegistry.getFactory(Lang.JSONLD11);
        }
        switch (version2) {
            case "": {
                RDFParserRegistry.registerLangTriples(Lang.JSONLD, readerFactoryJsonldDft);
                RDFParserRegistry.registerLangQuads(Lang.JSONLD, readerFactoryJsonldDft);
                return;
            }
            case "1.1": {
                RDFParserRegistry.registerLangTriples(Lang.JSONLD, readerFactoryJsonld11);
                RDFParserRegistry.registerLangQuads(Lang.JSONLD, readerFactoryJsonld11);
                return;
            }
            case "1.0": {
                RDFParserRegistry.registerLangTriples(Lang.JSONLD, readerFactoryJsonld10);
                RDFParserRegistry.registerLangQuads(Lang.JSONLD, readerFactoryJsonld10);
                return;
            }
        }
        Log.warn(SysRIOT.class, "Version string not recognized: '" + version2 + "'");
    }
}

