/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.other;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.other.RDFDataException;
import org.apache.jena.riot.other.Transitive;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.util.graph.GNode;
import org.apache.jena.sparql.util.graph.GraphList;
import org.apache.jena.util.iterator.ExtendedIterator;

public class G {
    private static Node rdfType = NodeConst.nodeRDFType;

    private G() {
    }

    public static Node subject(Triple triple) {
        return triple == null ? null : triple.getSubject();
    }

    public static Node predicate(Triple triple) {
        return triple == null ? null : triple.getPredicate();
    }

    public static Node object(Triple triple) {
        return triple == null ? null : triple.getObject();
    }

    public static boolean isURI(Node n) {
        return n != null && n.isURI();
    }

    public static boolean isBlank(Node n) {
        return n != null && n.isBlank();
    }

    public static boolean isLiteral(Node n) {
        return n != null && n.isLiteral();
    }

    public static boolean isResource(Node n) {
        return n != null && (n.isURI() || n.isBlank());
    }

    public static boolean isNodeTriple(Node n) {
        return n != null && n.isNodeTriple();
    }

    public static boolean isNodeGraph(Node n) {
        return n != null && n.isNodeGraph();
    }

    public static Node nullAsAny(Node x) {
        return G.nullAsDft(x, Node.ANY);
    }

    public static Node nullAsDft(Node x, Node dft) {
        return x == null ? dft : x;
    }

    public static boolean contains(Graph graph, Node subject, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return graph.contains(subject, predicate, object);
    }

    public static boolean containsNode(Graph graph, Node node) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(node, "node");
        return GraphUtil.containsNode(graph, node);
    }

    public static boolean isOfType(Graph graph, Node node, Node type) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(node, "node");
        Objects.requireNonNull(type, "type");
        List<Node> allClasses = G.listSubClasses(graph, type);
        for (Node c : allClasses) {
            if (!G.hasType(graph, node, c)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasType(Graph graph, Node node, Node type) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(node, "node");
        Objects.requireNonNull(type, "type");
        return G.contains(graph, node, NodeConst.nodeRDFType, type);
    }

    public static boolean hasProperty(Graph graph, Node subject, Node predicate) {
        Objects.requireNonNull(graph, "graph");
        return graph.contains(subject, predicate, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsOne(Graph graph, Node subject, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        try (ExtendedIterator<Triple> iter = graph.find(subject, predicate, object);){
            if (!iter.hasNext()) {
                boolean bl = false;
                return bl;
            }
            iter.next();
            boolean bl = !iter.hasNext();
            return bl;
        }
    }

    public static Node getSP(Graph graph, Node subject, Node predicate) {
        Objects.requireNonNull(graph, "graph");
        return G.object(G.first(G.find(graph, subject, predicate, Node.ANY)));
    }

    public static Node getOneSP(Graph graph, Node subject, Node predicate) {
        Objects.requireNonNull(graph, "graph");
        return G.object(G.findUniqueTriple(graph, subject, predicate, Node.ANY));
    }

    public static boolean hasOneSP(Graph graph, Node subject, Node predicate) {
        Objects.requireNonNull(graph, "graph");
        return G.findZeroOneTriple(graph, subject, predicate, Node.ANY) != null;
    }

    public static Node getZeroOrOneSP(Graph graph, Node subject, Node predicate) {
        Objects.requireNonNull(graph, "graph");
        return G.object(G.findZeroOneTriple(graph, subject, predicate, Node.ANY));
    }

    public static Node getPO(Graph graph, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return G.object(G.first(G.find(graph, Node.ANY, predicate, object)));
    }

    public static Node getOnePO(Graph graph, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return G.subject(G.findUniqueTriple(graph, Node.ANY, predicate, object));
    }

    public static boolean hasOnePO(Graph graph, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return G.findUniqueTriple(graph, Node.ANY, predicate, object) != null;
    }

    public static Node getZeroOrOnePO(Graph graph, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return G.subject(G.findZeroOneTriple(graph, Node.ANY, predicate, object));
    }

    public static Triple getOne(Graph graph, Node subject, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return G.findUniqueTriple(graph, subject, predicate, object);
    }

    public static Triple getZeroOrOne(Graph graph, Node subject, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return G.findZeroOneTriple(graph, subject, predicate, object);
    }

    public static Triple getOneOrNull(Graph graph, Node subject, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return G.findTripleOrNull(graph, subject, predicate, object);
    }

    public static Quad getOne(DatasetGraph dsg, Node graph, Node subject, Node predicate, Node object) {
        Objects.requireNonNull(dsg, "DatasetGraph");
        return G.findUniqueQuad(dsg, graph, subject, predicate, object);
    }

    public static Quad getZeroOrOne(DatasetGraph dsg, Node graph, Node subject, Node predicate, Node object) {
        Objects.requireNonNull(dsg, "DatasetGraph");
        return G.findZeroOneQuad(dsg, graph, subject, predicate, object);
    }

    public static Quad getOneOrNull(DatasetGraph dsg, Node graph, Node subject, Node predicate, Node object) {
        Objects.requireNonNull(dsg, "DatasetGraph");
        return G.findQuadOrNull(dsg, graph, subject, predicate, object);
    }

    public static ExtendedIterator<Node> iterSP(Graph graph, Node subject, Node predicate) {
        Objects.requireNonNull(graph, "graph");
        return G.find(graph, subject, predicate, null).mapWith(Triple::getObject);
    }

    public static List<Node> listSP(Graph graph, Node subject, Node predicate) {
        Objects.requireNonNull(graph, "graph");
        return G.iterSP(graph, subject, predicate).toList();
    }

    public static long countSP(Graph graph, Node subject, Node predicate) {
        Objects.requireNonNull(graph, "graph");
        return Iter.count(G.iterSP(graph, subject, predicate));
    }

    public static ExtendedIterator<Node> iterPO(Graph graph, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return G.find(graph, null, predicate, object).mapWith(Triple::getSubject);
    }

    public static List<Node> listPO(Graph graph, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return G.iterPO(graph, predicate, object).toList();
    }

    public static long countPO(Graph graph, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return Iter.count(G.iterPO(graph, predicate, object));
    }

    public static Iterator<Node> listSubjects(Graph graph) {
        Objects.requireNonNull(graph, "graph");
        ExtendedIterator<Triple> iter = graph.find(Node.ANY, Node.ANY, Node.ANY);
        return Iter.iter(iter).map(Triple::getSubject).distinct();
    }

    public static Iterator<Node> listPredicates(Graph graph) {
        Objects.requireNonNull(graph, "graph");
        ExtendedIterator<Triple> iter = graph.find(Node.ANY, Node.ANY, Node.ANY);
        return Iter.iter(iter).map(Triple::getPredicate).distinct();
    }

    public static Iterator<Node> listObjects(Graph graph) {
        Objects.requireNonNull(graph, "graph");
        ExtendedIterator<Triple> iter = graph.find(Node.ANY, Node.ANY, Node.ANY);
        return Iter.iter(iter).map(Triple::getObject).distinct();
    }

    public static List<Node> nodesOfTypeAsList(Graph graph, Node type) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(type, "type");
        return G.find(graph, null, rdfType, type).mapWith(Triple::getSubject).toList();
    }

    public static List<Node> typesOfNodeAsList(Graph graph, Node node) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(node, "node");
        return G.find(graph, node, rdfType, null).mapWith(Triple::getObject).toList();
    }

    public static Set<Node> nodesOfTypeAsSet(Graph graph, Node type) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(type, "type");
        return G.find(graph, null, rdfType, type).mapWith(Triple::getSubject).toSet();
    }

    public static Set<Node> typesOfNodeAsSet(Graph graph, Node node) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(node, "node");
        return G.find(graph, node, rdfType, null).mapWith(Triple::getObject).toSet();
    }

    public static List<Node> rdfList(Graph graph, Node node) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(node, "node");
        GNode gNode = GNode.create(graph, node);
        return GraphList.members(gNode);
    }

    public static List<Node> listSubClasses(Graph graph, Node type) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(type, "type");
        ArrayList<Node> acc = new ArrayList<Node>();
        Transitive.transitiveInc(graph, false, type, NodeConst.rdfsSubclassOf, acc);
        return acc;
    }

    public static List<Node> listSuperClasses(Graph graph, Node type) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(type, "type");
        ArrayList<Node> acc = new ArrayList<Node>();
        Transitive.transitiveInc(graph, true, type, NodeConst.rdfsSubclassOf, acc);
        return acc;
    }

    public static Set<Node> subClasses(Graph graph, Node type) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(type, "type");
        HashSet<Node> acc = new HashSet<Node>();
        Transitive.transitiveInc(graph, false, type, NodeConst.rdfsSubclassOf, acc);
        return acc;
    }

    public static Set<Node> superClasses(Graph graph, Node type) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(type, "type");
        HashSet<Node> acc = new HashSet<Node>();
        Transitive.transitiveInc(graph, true, type, NodeConst.rdfsSubclassOf, acc);
        return acc;
    }

    public static List<Node> listTypesOfNodeRDFS(Graph graph, Node node) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(node, "node");
        List<Node> types = G.typesOfNodeAsList(graph, node);
        ArrayList<Node> types2 = new ArrayList<Node>();
        types.forEach(t -> {
            List<Node> subClasses = G.listSuperClasses(graph, t);
            types2.addAll(subClasses);
        });
        return types2;
    }

    public static List<Node> listNodesOfTypeRDFS(Graph graph, Node type) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(type, "type");
        List<Node> types = G.listSubClasses(graph, type);
        ArrayList<Node> nodes = new ArrayList<Node>();
        G.accNodesOfTypes(nodes, graph, types);
        return nodes;
    }

    public static Set<Node> allTypesOfNodeRDFS(Graph graph, Node node) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(node, "node");
        Set<Node> types = G.typesOfNodeAsSet(graph, node);
        HashSet<Node> types2 = new HashSet<Node>();
        types.forEach(t -> {
            List<Node> subClasses = G.listSuperClasses(graph, t);
            types2.addAll(subClasses);
        });
        return types2;
    }

    public static Set<Node> allNodesOfTypeRDFS(Graph graph, Node type) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(type, "type");
        Set<Node> types = G.subClasses(graph, type);
        HashSet<Node> nodes = new HashSet<Node>();
        G.accNodesOfTypes(nodes, graph, types);
        return nodes;
    }

    private static void accNodesOfTypes(Collection<Node> acc, Graph graph, Collection<Node> types) {
        types.forEach(t -> G.find(graph, null, rdfType, t).mapWith(Triple::getSubject).forEach(acc::add));
    }

    public static Set<Node> allSP(Graph graph, Node subject, Node predicate) {
        Objects.requireNonNull(graph, "graph");
        return G.find(graph, subject, predicate, null).mapWith(Triple::getObject).toSet();
    }

    public static Set<Node> allPO(Graph graph, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return G.find(graph, null, predicate, object).mapWith(Triple::getSubject).toSet();
    }

    public static long objectConnectiveness(Graph graph, Node object) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(object, "object");
        return Iter.count(G.find(graph, null, null, object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean oneConnected(Graph graph, Node object) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(object, "object");
        try (ExtendedIterator<Triple> iter = G.find(graph, null, null, object);){
            if (!iter.hasNext()) {
                boolean bl = false;
                return bl;
            }
            iter.next();
            if (iter.hasNext()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public static long count(Graph graph, Node subject, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return Iter.count(graph.find(subject, predicate, object));
    }

    public static ExtendedIterator<Triple> find(Graph graph, Node subject, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return graph.find(subject, predicate, object);
    }

    public static ExtendedIterator<Triple> findAll(Graph graph) {
        Objects.requireNonNull(graph, "graph");
        return graph.find();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Triple findUniqueTriple(Graph graph, Node subject, Node predicate, Node object) {
        try (ExtendedIterator<Triple> iter = graph.find(subject, predicate, object);){
            if (!iter.hasNext()) {
                throw new RDFDataException("No match : " + G.matchStr(subject, predicate, object));
            }
            Triple x = (Triple)iter.next();
            if (iter.hasNext()) {
                throw new RDFDataException("More than one match : " + G.matchStr(subject, predicate, object));
            }
            Triple triple = x;
            return triple;
        }
    }

    private static Quad findUniqueQuad(DatasetGraph dsg, Node graph, Node subject, Node predicate, Node object) {
        Iterator<Quad> iter = dsg.find(graph, subject, predicate, object);
        if (!iter.hasNext()) {
            throw new RDFDataException("No match : " + G.matchStr(graph, subject, predicate, object));
        }
        Quad x = iter.next();
        if (iter.hasNext()) {
            throw new RDFDataException("More than one match : " + G.matchStr(graph, subject, predicate, object));
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Triple findTripleOrNull(Graph graph, Node subject, Node predicate, Node object) {
        try (ExtendedIterator<Triple> iter = graph.find(subject, predicate, object);){
            if (!iter.hasNext()) {
                Triple triple = null;
                return triple;
            }
            Triple x = (Triple)iter.next();
            if (iter.hasNext()) {
                Triple triple = null;
                return triple;
            }
            Triple triple = x;
            return triple;
        }
    }

    private static Quad findQuadOrNull(DatasetGraph dsg, Node graph, Node subject, Node predicate, Node object) {
        Iterator<Quad> iter = dsg.find(graph, subject, predicate, object);
        if (!iter.hasNext()) {
            return null;
        }
        Quad x = iter.next();
        if (iter.hasNext()) {
            return null;
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Triple findZeroOneTriple(Graph graph, Node subject, Node predicate, Node object) {
        try (ExtendedIterator<Triple> iter = graph.find(subject, predicate, object);){
            if (!iter.hasNext()) {
                Triple triple = null;
                return triple;
            }
            Triple x = (Triple)iter.next();
            if (iter.hasNext()) {
                throw new RDFDataException("More than one match : " + G.matchStr(subject, predicate, object));
            }
            Triple triple = x;
            return triple;
        }
    }

    private static Quad findZeroOneQuad(DatasetGraph dsg, Node graph, Node subject, Node predicate, Node object) {
        Iterator<Quad> iter = dsg.find(graph, subject, predicate, object);
        if (!iter.hasNext()) {
            return null;
        }
        Quad x = iter.next();
        if (iter.hasNext()) {
            throw new RDFDataException("More than one match : " + G.matchStr(subject, predicate, object));
        }
        return x;
    }

    private static String matchStr(Node subject, Node predicate, Node object) {
        return "(" + NodeFmtLib.strNodesTTL(subject, predicate, object) + ")";
    }

    private static String matchStr(Node graph, Node subject, Node predicate, Node object) {
        return "(" + NodeFmtLib.strNodesTTL(graph, subject, predicate, object) + ")";
    }

    private static Triple first(ExtendedIterator<Triple> iter) {
        try {
            if (!iter.hasNext()) {
                Triple triple = null;
                return triple;
            }
            Triple triple = (Triple)iter.next();
            return triple;
        }
        finally {
            iter.close();
        }
    }

    @SafeVarargs
    public static <X> boolean allNonNull(X ... objects) {
        return G.countNonNulls(objects) == objects.length;
    }

    @SafeVarargs
    public static <X> boolean exactlyOneSet(X ... objects) {
        return G.countNonNulls(objects) == 1;
    }

    @SafeVarargs
    public static <X> X atMostOne(X ... objects) {
        int c = 0;
        X x = null;
        for (X obj : objects) {
            if (obj == null) continue;
            if (++c > 1) {
                throw new RDFDataException("atMostOne:" + Arrays.asList(objects));
            }
            if (x != null) continue;
            x = obj;
        }
        return x;
    }

    @SafeVarargs
    public static <X> int countNonNulls(X ... objects) {
        int x = 0;
        for (X obj : objects) {
            if (obj == null) continue;
            ++x;
        }
        return x;
    }

    public static Iter<Triple> quads2triples(Iterator<Quad> iter) {
        return Iter.iter(iter).map(Quad::asTriple);
    }

    public static Iterator<Node> quad2graphName(Iterator<Quad> iter) {
        return Iter.map(iter, Quad::getGraph);
    }

    public static Iterator<Node> quad2subject(Iterator<Quad> iter) {
        return Iter.map(iter, Quad::getSubject);
    }

    public static Iterator<Node> quad2predicate(Iterator<Quad> iter) {
        return Iter.map(iter, Quad::getPredicate);
    }

    public static Iterator<Node> quad2object(Iterator<Quad> iter) {
        return Iter.map(iter, Quad::getObject);
    }

    public static Iterator<Node> triple2subject(Iterator<Triple> iter) {
        return Iter.map(iter, Triple::getSubject);
    }

    public static Iterator<Node> triple2predicate(Iterator<Triple> iter) {
        return Iter.map(iter, Triple::getPredicate);
    }

    public static Iterator<Node> triple2object(Iterator<Triple> iter) {
        return Iter.map(iter, Triple::getObject);
    }

    public static void copyGraphSrcToDst(Graph src, Graph dst) {
        G.apply(src, dst::add);
    }

    public static void clear(Graph graph) {
        graph.clear();
    }

    public static void apply(Graph src, Consumer<Triple> action) {
        ExtendedIterator<Triple> iter = src.find();
        G.apply(iter, action);
    }

    public static void apply(ExtendedIterator<Triple> iter, Consumer<Triple> action) {
        try {
            while (iter.hasNext()) {
                Triple t = (Triple)iter.next();
                action.accept(t);
            }
        }
        finally {
            iter.close();
        }
    }

    public static void deleteModify(Graph modify, Graph srcGraph) {
        GraphUtil.deleteFrom(modify, srcGraph);
    }

    public static Iter<Quad> triples2quads(Node graphNode, Iterator<Triple> iter) {
        return Iter.iter(iter).map(t -> new Quad(graphNode, (Triple)t));
    }

    public static Iter<Quad> triples2quadsDftGraph(Iterator<Triple> iter) {
        return G.triples2quads(Quad.defaultGraphIRI, iter);
    }

    public static void execTxn(Graph graph, Runnable action) {
        TransactionHandler th = graph.getTransactionHandler();
        if (th.transactionsSupported()) {
            th.execute(action);
        } else {
            action.run();
        }
    }

    public static <X> X calcTxn(Graph graph, Supplier<X> action) {
        TransactionHandler th = graph.getTransactionHandler();
        if (th.transactionsSupported()) {
            return th.calculate(action);
        }
        return action.get();
    }
}

