/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.protobuf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.riot.protobuf.Binding2Protobuf;
import org.apache.jena.riot.protobuf.PBufRDF;
import org.apache.jena.riot.protobuf.Protobuf2Binding;
import org.apache.jena.riot.protobuf.Protobuf2StreamRDF;
import org.apache.jena.riot.protobuf.StreamRDF2Protobuf;
import org.apache.jena.riot.protobuf.VisitorStreamRowProtoRDF;
import org.apache.jena.riot.protobuf.wire.PB_RDF;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.exec.RowSetStream;

public class ProtobufRDF {
    public static StreamRDF streamToFile(String filename) {
        return ProtobufRDF.streamToFile(filename, false);
    }

    public static StreamRDF streamToFile(String filename, boolean withValues) {
        OutputStream out = IO.openOutputFile(filename);
        out = IO.ensureBuffered(out);
        return ProtobufRDF.streamToOutputStream(out);
    }

    public static StreamRDF streamToOutputStream(OutputStream output) {
        return ProtobufRDF.streamToOutputStream(output, false);
    }

    public static StreamRDF streamToOutputStream(OutputStream output, boolean withValues) {
        output = IO.ensureBuffered(output);
        try {
            StreamRDF streamRDF = StreamRDF2Protobuf.createDelimited(output, withValues);
            return streamRDF;
        }
        finally {
            IO.flush(output);
        }
    }

    public static void fileToStream(String filename, StreamRDF dest) {
        InputStream in = IO.openFileBuffered(filename);
        ProtobufRDF.inputStreamToStreamRDF(in, dest);
    }

    public static void inputStreamToStreamRDF(InputStream input, StreamRDF stream) {
        Protobuf2StreamRDF visitor = new Protobuf2StreamRDF(PrefixMapFactory.create(), stream);
        stream.start();
        try {
            ProtobufRDF.apply(input, visitor);
        }
        finally {
            stream.finish();
        }
    }

    public static void apply(InputStream input, VisitorStreamRowProtoRDF action) {
        input = IO.ensureBuffered(input);
        try {
            PB_RDF.RDF_StreamRow x;
            boolean b;
            while (b = PBufRDF.visit(x = PB_RDF.RDF_StreamRow.parseDelimitedFrom(input), action)) {
            }
            return;
        }
        catch (IOException ex) {
            IO.exception(ex);
            return;
        }
    }

    public static RowSet readRowSet(InputStream input) {
        Protobuf2Binding p2b = new Protobuf2Binding(input);
        return RowSetStream.create(p2b.getVars(), p2b);
    }

    public static void writeRowSet(OutputStream out, RowSet rowSet) {
        ProtobufRDF.writeRowSet(out, rowSet, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRowSet(OutputStream out, RowSet rowSet, boolean withValues) {
        out = IO.ensureBuffered(out);
        try {
            List<Var> vars = rowSet.getResultVars();
            try (Binding2Protobuf b2p = new Binding2Protobuf(out, vars, false);){
                while (rowSet.hasNext()) {
                    Binding b = rowSet.next();
                    b2p.output(b);
                }
            }
        }
        finally {
            IO.flush(out);
        }
    }
}

