/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.http.HttpEnv;
import org.apache.jena.http.HttpLib;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.QueryType;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.Syntax;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.ResultSetMgr;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.resultset.ResultSetReaderRegistry;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.engine.http.QueryExceptionHTTP;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.exec.http.Params;
import org.apache.jena.sparql.exec.http.QueryExecHTTPBuilder;
import org.apache.jena.sparql.exec.http.QuerySendMode;
import org.apache.jena.sparql.util.Context;

public class QueryExecHTTP
implements QueryExec {
    public static final String QUERY_MIME_TYPE = "application/sparql-query;charset=utf-8";
    private final Query query;
    private final String queryString;
    private final String service;
    private final Context context;
    private Params params = null;
    private final QuerySendMode sendMode;
    private int urlLimit = HttpEnv.urlLimit;
    private List<String> defaultGraphURIs = new ArrayList<String>();
    private List<String> namedGraphURIs = new ArrayList<String>();
    private boolean closed = false;
    private long readTimeout = -1L;
    private TimeUnit readTimeoutUnit = TimeUnit.MILLISECONDS;
    private final String selectAcceptheader = WebContent.defaultSparqlResultsHeader;
    private final String askAcceptHeader = WebContent.defaultSparqlAskHeader;
    private final String describeAcceptHeader = "text/turtle,application/n-triples;q=0.9,application/ld+json;q=0.8,application/rdf+xml;q=0.7,*/*;q=0.3";
    private final String constructAcceptHeader = "text/turtle,application/n-triples;q=0.9,application/ld+json;q=0.8,application/rdf+xml;q=0.7,*/*;q=0.3";
    private final String datasetAcceptHeader = "application/trig,application/n-quads;q=0.9,application/ld+json;q=0.8,*/*;q=0.3";
    private String appProvidedAcceptHeader = null;
    private String httpResponseContentType = null;
    private InputStream retainedConnection = null;
    private HttpClient httpClient = HttpEnv.getDftHttpClient();
    private Map<String, String> httpHeaders;

    @Deprecated
    public static QueryExecHTTPBuilder create() {
        return QueryExecHTTP.newBuilder();
    }

    public static QueryExecHTTPBuilder newBuilder() {
        return QueryExecHTTPBuilder.create();
    }

    public static QueryExecHTTPBuilder service(String serviceURL) {
        return (QueryExecHTTPBuilder)QueryExecHTTP.newBuilder().endpoint(serviceURL);
    }

    public QueryExecHTTP(String serviceURL, Query query, String queryString, int urlLimit, HttpClient httpClient, Map<String, String> httpHeaders, Params params, Context context2, List<String> defaultGraphURIs, List<String> namedGraphURIs, QuerySendMode sendMode, String explicitAcceptHeader, long timeout, TimeUnit timeoutUnit) {
        this.context = context2 == null ? ARQ.getContext().copy() : context2.copy();
        this.service = serviceURL;
        this.query = query;
        this.queryString = queryString;
        this.urlLimit = urlLimit;
        this.httpHeaders = httpHeaders;
        this.defaultGraphURIs = defaultGraphURIs;
        this.namedGraphURIs = namedGraphURIs;
        this.sendMode = Objects.requireNonNull(sendMode);
        this.appProvidedAcceptHeader = explicitAcceptHeader;
        if (httpHeaders.containsKey("Accept")) {
            if (this.appProvidedAcceptHeader != null) {
                this.appProvidedAcceptHeader = httpHeaders.get("Accept");
            }
            this.httpHeaders.remove("Accept");
        }
        this.httpHeaders = httpHeaders;
        this.params = params;
        this.readTimeout = timeout;
        this.readTimeoutUnit = timeoutUnit;
        this.httpClient = HttpLib.dft(httpClient, HttpEnv.getDftHttpClient());
    }

    public String getHttpResponseContentType() {
        return this.httpResponseContentType;
    }

    @Override
    public RowSet select() {
        this.checkNotClosed();
        this.check(QueryType.SELECT);
        RowSet rs = this.execRowSet();
        return rs;
    }

    private RowSet execRowSet() {
        Lang lang;
        String actualContentType;
        String thisAcceptHeader = HttpLib.dft(this.appProvidedAcceptHeader, this.selectAcceptheader);
        HttpResponse<InputStream> response = this.performQuery(thisAcceptHeader);
        InputStream in = HttpLib.getInputStream(response);
        this.httpResponseContentType = actualContentType = HttpLib.responseHeader(response, "Content-Type");
        actualContentType = this.removeCharset(actualContentType);
        this.retainedConnection = in;
        if (actualContentType == null || actualContentType.equals("")) {
            actualContentType = "application/sparql-results+xml";
        }
        if ((lang = WebContent.contentTypeToLangResultSet(actualContentType)) == null) {
            throw new QueryException("Endpoint returned Content-Type: " + actualContentType + " which is not recognized for SELECT queries");
        }
        if (!ResultSetReaderRegistry.isRegistered(lang)) {
            throw new QueryException("Endpoint returned Content-Type: " + actualContentType + " which is not supported for SELECT queries");
        }
        ResultSet result = ResultSetMgr.read(in, lang);
        return RowSet.adapt(result);
    }

    @Override
    public boolean ask() {
        Lang lang;
        String actualContentType;
        this.checkNotClosed();
        this.check(QueryType.ASK);
        String thisAcceptHeader = HttpLib.dft(this.appProvidedAcceptHeader, this.askAcceptHeader);
        HttpResponse<InputStream> response = this.performQuery(thisAcceptHeader);
        InputStream in = HttpLib.getInputStream(response);
        this.httpResponseContentType = actualContentType = HttpLib.responseHeader(response, "Content-Type");
        actualContentType = this.removeCharset(actualContentType);
        if (actualContentType == null || actualContentType.equals("")) {
            actualContentType = this.askAcceptHeader;
        }
        if ((lang = RDFLanguages.contentTypeToLang(actualContentType)) == null) {
            if (actualContentType.equals("application/xml")) {
                lang = ResultSetLang.RS_XML;
            } else if (actualContentType.equals("application/json")) {
                lang = ResultSetLang.RS_JSON;
            }
        }
        if (lang == null) {
            throw new QueryException("Endpoint returned Content-Type: " + actualContentType + " which is not supported for ASK queries");
        }
        boolean result = ResultSetMgr.readBoolean(in, lang);
        HttpLib.finish(in);
        return result;
    }

    private String removeCharset(String contentType) {
        int idx = contentType.indexOf(59);
        if (idx < 0) {
            return contentType;
        }
        return contentType.substring(0, idx);
    }

    @Override
    public Graph construct(Graph graph) {
        this.checkNotClosed();
        this.check(QueryType.CONSTRUCT);
        return this.execGraph(graph, "text/turtle,application/n-triples;q=0.9,application/ld+json;q=0.8,application/rdf+xml;q=0.7,*/*;q=0.3");
    }

    @Override
    public Iterator<Triple> constructTriples() {
        this.checkNotClosed();
        this.check(QueryType.CONSTRUCT);
        return this.execTriples("text/turtle,application/n-triples;q=0.9,application/ld+json;q=0.8,application/rdf+xml;q=0.7,*/*;q=0.3");
    }

    @Override
    public Iterator<Quad> constructQuads() {
        this.checkNotClosed();
        return this.execQuads();
    }

    @Override
    public DatasetGraph constructDataset() {
        this.checkNotClosed();
        return this.constructDataset(DatasetGraphFactory.createTxnMem());
    }

    @Override
    public DatasetGraph constructDataset(DatasetGraph dataset) {
        this.checkNotClosed();
        this.check(QueryType.CONSTRUCT);
        return this.execDataset(dataset);
    }

    @Override
    public Graph describe(Graph graph) {
        this.checkNotClosed();
        this.check(QueryType.DESCRIBE);
        return this.execGraph(graph, "text/turtle,application/n-triples;q=0.9,application/ld+json;q=0.8,application/rdf+xml;q=0.7,*/*;q=0.3");
    }

    @Override
    public Iterator<Triple> describeTriples() {
        this.checkNotClosed();
        return this.execTriples("text/turtle,application/n-triples;q=0.9,application/ld+json;q=0.8,application/rdf+xml;q=0.7,*/*;q=0.3");
    }

    private Graph execGraph(Graph graph, String acceptHeader) {
        Pair<InputStream, Lang> p = this.execRdfWorker(acceptHeader, "application/rdf+xml");
        InputStream in = p.getLeft();
        Lang lang = p.getRight();
        try {
            RDFDataMgr.read(graph, in, lang);
        }
        catch (RiotException ex) {
            HttpLib.finish(in);
            throw ex;
        }
        return graph;
    }

    private DatasetGraph execDataset(DatasetGraph dataset) {
        Pair<InputStream, Lang> p = this.execRdfWorker("application/trig,application/n-quads;q=0.9,application/ld+json;q=0.8,*/*;q=0.3", "application/n-quads");
        InputStream in = p.getLeft();
        Lang lang = p.getRight();
        try {
            RDFDataMgr.read(dataset, in, lang);
        }
        catch (RiotException ex) {
            HttpLib.finish(in);
            throw ex;
        }
        return dataset;
    }

    private Iterator<Triple> execTriples(String acceptHeader) {
        Pair<InputStream, Lang> p = this.execRdfWorker(acceptHeader, "application/rdf+xml");
        InputStream input = p.getLeft();
        Lang lang = p.getRight();
        Iterator<Triple> iter = RDFDataMgr.createIteratorTriples(input, lang, null);
        return Iter.onCloseIO(iter, input);
    }

    private Iterator<Quad> execQuads() {
        this.checkNotClosed();
        Pair<InputStream, Lang> p = this.execRdfWorker("application/trig,application/n-quads;q=0.9,application/ld+json;q=0.8,*/*;q=0.3", "application/n-quads");
        InputStream input = p.getLeft();
        Lang lang = p.getRight();
        Iterator<Quad> iter = RDFDataMgr.createIteratorQuads(input, lang, null);
        return Iter.onCloseIO(iter, input);
    }

    private Pair<InputStream, Lang> execRdfWorker(String contentType, String ifNoContentType) {
        Lang lang;
        String actualContentType;
        this.checkNotClosed();
        String thisAcceptHeader = HttpLib.dft(this.appProvidedAcceptHeader, contentType);
        HttpResponse<InputStream> response = this.performQuery(thisAcceptHeader);
        InputStream in = HttpLib.getInputStream(response);
        this.httpResponseContentType = actualContentType = HttpLib.responseHeader(response, "Content-Type");
        actualContentType = this.removeCharset(actualContentType);
        if (actualContentType == null || actualContentType.equals("")) {
            actualContentType = ifNoContentType;
        }
        if (!RDFLanguages.isQuads(lang = RDFLanguages.contentTypeToLang(actualContentType)) && !RDFLanguages.isTriples(lang)) {
            throw new QueryException("Endpoint returned Content Type: " + actualContentType + " which is not a valid RDF syntax");
        }
        return Pair.create(in, lang);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonArray execJson() {
        this.checkNotClosed();
        this.check(QueryType.CONSTRUCT_JSON);
        String thisAcceptHeader = HttpLib.dft(this.appProvidedAcceptHeader, "application/json");
        HttpResponse<InputStream> response = this.performQuery(thisAcceptHeader);
        InputStream in = HttpLib.getInputStream(response);
        try {
            JsonArray jsonArray = JSON.parseAny(in).getAsArray();
            return jsonArray;
        }
        finally {
            HttpLib.finish(in);
        }
    }

    @Override
    public Iterator<JsonObject> execJsonItems() {
        JsonArray array = this.execJson().getAsArray();
        ArrayList x = new ArrayList(array.size());
        array.forEach(elt -> {
            if (!elt.isObject()) {
                throw new QueryExecException("Item in an array from a JSON query isn't an object");
            }
            x.add(elt.getAsObject());
        });
        return x.iterator();
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new QueryExecException("HTTP QueryExecHTTP has been closed");
        }
    }

    private void check(QueryType queryType) {
        if (this.query == null) {
            return;
        }
        if (this.query.queryType() != queryType) {
            throw new QueryExecException("Not the right form of query. Expected " + queryType + " but got " + this.query.queryType());
        }
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public DatasetGraph getDataset() {
        return null;
    }

    @Override
    public Query getQuery() {
        if (this.query != null) {
            return this.query;
        }
        if (this.queryString != null) {
            try {
                return QueryFactory.create(this.queryString, Syntax.syntaxARQ);
            }
            catch (QueryParseException queryParseException) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    private static long asMillis(long duration, TimeUnit timeUnit) {
        return duration < 0L ? duration : timeUnit.toMillis(duration);
    }

    private HttpResponse<InputStream> performQuery(String reqAcceptHeader) {
        if (this.closed) {
            throw new ARQException("HTTP execution already closed");
        }
        Params thisParams = Params.create(this.params);
        if (this.defaultGraphURIs != null) {
            for (String dft : this.defaultGraphURIs) {
                thisParams.add("default-graph-uri", dft);
            }
        }
        if (this.namedGraphURIs != null) {
            for (String name : this.namedGraphURIs) {
                thisParams.add("named-graph-uri", name);
            }
        }
        HttpLib.modifyByService(this.service, this.context, thisParams, this.httpHeaders);
        HttpRequest request = this.makeRequest(thisParams, reqAcceptHeader);
        return this.executeQuery(request);
    }

    private HttpRequest makeRequest(Params thisParams, String reqAcceptHeader) {
        HttpRequest.Builder requestBuilder;
        QuerySendMode actualSendMode = this.actualSendMode();
        switch (actualSendMode) {
            case asGetAlways: {
                requestBuilder = this.executeQueryGet(thisParams, reqAcceptHeader);
                break;
            }
            case asPostForm: {
                requestBuilder = this.executeQueryPostForm(thisParams, reqAcceptHeader);
                break;
            }
            case asPost: {
                requestBuilder = this.executeQueryPostBody(thisParams, reqAcceptHeader);
                break;
            }
            default: {
                throw new InternalErrorException("Invalid value for 'actualSendMode' " + actualSendMode);
            }
        }
        return requestBuilder.build();
    }

    private HttpResponse<InputStream> executeQuery(HttpRequest request) {
        QueryExecHTTP.logQuery(this.queryString, request);
        try {
            HttpResponse<InputStream> response = HttpLib.execute(this.httpClient, request);
            HttpLib.handleHttpStatusCode(response);
            return response;
        }
        catch (HttpException httpEx) {
            throw QueryExceptionHTTP.rewrap(httpEx);
        }
    }

    private QuerySendMode actualSendMode() {
        int thisLengthLimit = this.urlLimit;
        switch (this.sendMode) {
            case asGetAlways: 
            case asPostForm: 
            case asPost: {
                return this.sendMode;
            }
        }
        String requestURL = this.service;
        int paramsLength = this.params.httpString().length();
        int qEncodedLength = QueryExecHTTP.calcEncodeStringLength(this.queryString);
        int length = this.service.length() + 1 + "query".length() + qEncodedLength + 1 + paramsLength;
        if (length <= thisLengthLimit) {
            return QuerySendMode.asGetAlways;
        }
        return this.sendMode == QuerySendMode.asGetWithLimitBody ? QuerySendMode.asPost : QuerySendMode.asPostForm;
    }

    private static int calcEncodeStringLength(String str2) {
        String qs = HttpLib.urlEncodeQueryString(str2);
        int encodedLength = qs.length();
        return encodedLength;
    }

    private HttpRequest.Builder executeQueryGet(Params thisParams, String acceptHeader) {
        thisParams.add("query", this.queryString);
        String requestURL = HttpLib.requestURL(this.service, thisParams.httpString());
        HttpRequest.Builder builder = HttpLib.requestBuilder(requestURL, this.httpHeaders, this.readTimeout, this.readTimeoutUnit);
        HttpLib.acceptHeader(builder, acceptHeader);
        return builder.GET();
    }

    private HttpRequest.Builder executeQueryPostForm(Params thisParams, String acceptHeader) {
        thisParams.add("query", this.queryString);
        String requestURL = this.service;
        String formBody = thisParams.httpString();
        HttpRequest.Builder builder = HttpLib.requestBuilder(requestURL, this.httpHeaders, this.readTimeout, this.readTimeoutUnit);
        HttpLib.acceptHeader(builder, acceptHeader);
        HttpLib.contentTypeHeader(builder, "application/x-www-form-urlencoded");
        return builder.POST(HttpRequest.BodyPublishers.ofString(formBody, StandardCharsets.US_ASCII));
    }

    private HttpRequest.Builder executeQueryPostBody(Params thisParams, String acceptHeader) {
        String requestURL = HttpLib.requestURL(this.service, thisParams.httpString());
        HttpRequest.Builder builder = HttpLib.requestBuilder(requestURL, this.httpHeaders, this.readTimeout, this.readTimeoutUnit);
        HttpLib.contentTypeHeader(builder, QUERY_MIME_TYPE);
        HttpLib.acceptHeader(builder, acceptHeader);
        return builder.POST(HttpRequest.BodyPublishers.ofString(this.queryString));
    }

    private static void logQuery(String queryString, HttpRequest request) {
    }

    public void cancel() {
        this.closed = true;
    }

    @Override
    public void abort() {
        try {
            this.close();
        }
        catch (Exception ex) {
            Log.warn(this, "Error during abort", ex);
        }
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.retainedConnection != null) {
            try {
                if (this.retainedConnection.read() != -1) {
                    Log.warn(this, "HTTP response not fully consumed, if HTTP Client is reusing connections (its default behaviour) then it will consume the remaining response data which may take a long time and cause this application to become unresponsive");
                }
                this.retainedConnection.close();
            }
            catch (IOException | RuntimeIOException exception) {
            }
            finally {
                this.retainedConnection = null;
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

