/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.exportchooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.freehep.graphics2d.TagString;
import org.freehep.graphicsio.MultiPageDocument;

public class HeadFootDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final String[] HF_LABELS = new String[]{"Headline", "Footline"};
    private JTextField[][] textField;
    private JCheckBox[] useCheckBox;
    private TagString[][] text;

    public HeadFootDialog() {
        this.setTitle("Head- and footlines");
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.textField = new JTextField[HF_LABELS.length][];
        this.useCheckBox = new JCheckBox[HF_LABELS.length];
        JPanel textPanel = new JPanel(new GridLayout(HF_LABELS.length * 2, 1));
        for (int i = 0; i < HF_LABELS.length; ++i) {
            JPanel title = new JPanel(new FlowLayout(0));
            this.useCheckBox[i] = new JCheckBox();
            this.useCheckBox[i].setSelected(false);
            this.useCheckBox[i].addItemListener(this);
            title.add(this.useCheckBox[i]);
            title.add(new JLabel(HF_LABELS[i]));
            textPanel.add(title);
            JPanel textFieldPanel = new JPanel(new FlowLayout());
            this.textField[i] = new JTextField[3];
            for (int j = 0; j < this.textField[i].length; ++j) {
                this.textField[i][j] = new JTextField(10);
                this.textField[i][j].setEnabled(false);
                textFieldPanel.add(this.textField[i][j]);
            }
            textPanel.add(textFieldPanel);
        }
        this.getContentPane().add((Component)textPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand("cancel");
        cancel.addActionListener(this);
        buttonPanel.add(cancel);
        JButton ok = new JButton("Ok");
        ok.setActionCommand("ok");
        ok.addActionListener(this);
        buttonPanel.add(ok);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.pack();
        this.text = new TagString[this.useCheckBox.length][];
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (e2.getActionCommand().equals("ok")) {
            for (int i = 0; i < this.useCheckBox.length; ++i) {
                if (this.useCheckBox[i].isSelected()) {
                    this.text[i] = new TagString[3];
                    for (int j = 0; j < this.textField[i].length; ++j) {
                        this.text[i][j] = new TagString(this.textField[i][j].getText());
                    }
                    continue;
                }
                this.text[i] = null;
            }
            this.setVisible(false);
        } else if (e2.getActionCommand().equals("cancel")) {
            for (int i = 0; i < this.useCheckBox.length; ++i) {
                this.useCheckBox[i].setSelected(this.text[i] != null);
                for (int j = 0; j < this.textField[i].length; ++j) {
                    if (this.text[i] != null) {
                        this.textField[i][j].setText(this.text[i][j].toString());
                        this.textField[i][j].setEnabled(true);
                        continue;
                    }
                    this.textField[i][j].setText("");
                    this.textField[i][j].setEnabled(false);
                }
            }
            this.setVisible(false);
        }
    }

    public void configure(MultiPageDocument md) {
        if (this.text[0] != null) {
            md.setHeader(new Font("times", 0, 10), this.text[0][0], this.text[0][1], this.text[0][2], 1);
        }
        if (this.text[1] != null) {
            md.setFooter(new Font("times", 0, 10), this.text[1][0], this.text[1][1], this.text[1][2], 1);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e2) {
        for (int i = 0; i < this.useCheckBox.length; ++i) {
            if (e2.getSource() != this.useCheckBox[i]) continue;
            for (int j = 0; j < this.textField[i].length; ++j) {
                this.textField[i][j].setEnabled(e2.getStateChange() == 1);
            }
        }
    }

    public static void main(String[] argv) {
        HeadFootDialog d = new HeadFootDialog();
        d.setVisible(true);
    }
}

