/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.exportchooser;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import org.freehep.graphicsio.exportchooser.Options;

public class OptionComboBox
extends JComboBox
implements Options {
    protected String initialSelectedItem;
    protected String key;

    public OptionComboBox(Properties options, String key, String[] values) {
        super(values);
        this.setSelectedItem(options.getProperty(key, values[0]));
        this.setEnabled(values.length > 1);
        this.key = key;
        this.initialSelectedItem = (String)this.getSelectedItem();
    }

    @Override
    public boolean applyChangedOptions(Properties options) {
        if (!this.getSelectedItem().equals(this.initialSelectedItem)) {
            options.setProperty(this.key, (String)this.getSelectedItem());
            return true;
        }
        return false;
    }

    public void enables(final String item, final Component c) {
        if (c.isEnabled()) {
            c.setEnabled(this.getSelectedItem().equals(item));
            this.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e2) {
                    c.setEnabled(OptionComboBox.this.getSelectedItem().equals(item));
                }
            });
        }
    }

    public void shows(final String item, final Component c) {
        c.setVisible(this.getSelectedItem().equals(item));
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                c.setVisible(OptionComboBox.this.getSelectedItem().equals(item));
            }
        });
    }

    public void selects(final String item, final AbstractButton c) {
        c.setSelected(this.getSelectedItem().equals(item));
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                c.setSelected(OptionComboBox.this.getSelectedItem().equals(item));
            }
        });
    }
}

