/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.exportchooser;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import javax.swing.JRadioButton;
import org.freehep.graphicsio.exportchooser.Options;

public class OptionRadioButton
extends JRadioButton
implements Options {
    protected boolean initialState;
    protected String key;

    public OptionRadioButton(Properties options, String key, String text) {
        super(text, (boolean)new Boolean(options.getProperty(key, "false")));
        this.key = key;
        this.initialState = this.isSelected();
    }

    @Override
    public boolean applyChangedOptions(Properties options) {
        if (this.isSelected() != this.initialState) {
            options.setProperty(this.key, Boolean.toString(this.isSelected()));
            return true;
        }
        return false;
    }

    public void enables(final Component c) {
        if (c.isEnabled()) {
            c.setEnabled(this.isSelected());
            this.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e2) {
                    c.setEnabled(OptionRadioButton.this.isSelected());
                }
            });
        }
    }

    public void shows(final Component c) {
        c.setVisible(this.isSelected());
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                c.setVisible(OptionRadioButton.this.isSelected());
            }
        });
    }
}

