/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font.truetype;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.freehep.graphicsio.font.truetype.TTFInput;
import org.freehep.graphicsio.font.truetype.TTFTable;

public abstract class TTFFont {
    private Map<String, Object> entry = new HashMap<String, Object>();

    public abstract int getFontVersion();

    void newTable(String tag, TTFInput input) throws IOException {
        this.entry.put(tag, this.initTable(tag, input));
    }

    private Object initTable(String name, TTFInput input) throws IOException {
        TTFTable table = null;
        for (int i = 0; i < TTFTable.TT_TAGS.length; ++i) {
            if (!name.equals(TTFTable.TT_TAGS[i])) continue;
            try {
                table = (TTFTable)TTFTable.TABLE_CLASSES[i].newInstance();
            }
            catch (InstantiationException e2) {
                throw new IOException(e2);
            }
            catch (IllegalAccessException e3) {
                throw new IOException(e3);
            }
            table.init(this, input);
            return table;
        }
        return null;
    }

    public void show() {
        System.out.println("Tables:");
        Iterator<Object> i = this.entry.values().iterator();
        while (i.hasNext()) {
            System.out.println(i.next());
        }
    }

    public TTFTable getTable(String tag) throws IOException {
        TTFTable table = (TTFTable)this.entry.get(tag);
        if (!table.isRead()) {
            table.read();
        }
        return table;
    }

    public void readAll() throws IOException {
        for (TTFTable tTFTable : this.entry.values()) {
            if (tTFTable == null || tTFTable.isRead()) continue;
            tTFTable.read();
        }
    }

    public void close() throws IOException {
    }
}

