/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.text.DecimalFormat;
import java.util.Calendar;
import org.freehep.graphicsbase.util.ScientificFormat;
import org.freehep.graphicsio.pdf.PDFConstants;

public class PDFUtil
implements PDFConstants {
    private static final ScientificFormat scientific = new ScientificFormat(5, 100, false);

    private PDFUtil() {
    }

    public static String escape(String string) {
        StringBuffer escape = new StringBuffer();
        block3: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '(': 
                case ')': 
                case '\\': {
                    escape.append('\\');
                    escape.append(c);
                    continue block3;
                }
                default: {
                    escape.append(c);
                }
            }
        }
        return escape.toString();
    }

    public static String date(Calendar date2) {
        String tz;
        int offset = date2.get(15) + date2.get(16);
        if (offset == 0) {
            tz = "Z";
        } else {
            DecimalFormat fmt = new DecimalFormat("00");
            int tzh = Math.abs(offset / 3600000);
            int tzm = Math.abs(offset % 3600000);
            tz = offset > 0 ? "+" + fmt.format(tzh) + "'" + fmt.format(tzm) + "'" : "-" + fmt.format(tzh) + "'" + fmt.format(tzm) + "'";
        }
        return "(D:" + dateFormat.format(date2.getTime()) + tz + ")";
    }

    public static String fixedPrecision(double v) {
        return scientific.format(v);
    }
}

