/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.ps;

import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.PrintStream;
import org.freehep.graphics2d.font.CharTable;
import org.freehep.graphicsio.font.FontEmbedder;
import org.freehep.graphicsio.ps.PSPathConstructor;

public class PSFontEmbedder
extends FontEmbedder {
    protected int dictSize = 9;
    protected PrintStream os;
    private PSPathConstructor pc;

    public PSFontEmbedder(FontRenderContext context2, PrintStream os) {
        super(context2);
        this.os = os;
        this.pc = new PSPathConstructor(os, false, true);
    }

    @Override
    protected void writeGlyph(String unicodeName, Shape glyph, GlyphMetrics glyphMetrics) throws IOException {
        double[] points = new double[6];
        double[] lastMove = new double[2];
        double[] lastPoint = new double[2];
        double[] controlPoint = new double[4];
        PathIterator pIter = glyph.getPathIterator(null);
        this.os.println("\t/" + unicodeName);
        this.os.println("\t\t{");
        while (!pIter.isDone()) {
            switch (pIter.currentSegment(points)) {
                case 0: {
                    this.pc.move(points[0], points[1]);
                    lastMove[0] = lastPoint[0] = points[0];
                    lastMove[1] = lastPoint[1] = points[1];
                    break;
                }
                case 1: {
                    this.pc.line(points[0], points[1]);
                    lastPoint[0] = points[0];
                    lastPoint[1] = points[1];
                    break;
                }
                case 2: {
                    controlPoint[0] = points[0] + (lastPoint[0] - points[0]) / 3.0;
                    controlPoint[1] = points[1] + (lastPoint[1] - points[1]) / 3.0;
                    controlPoint[2] = points[0] + (points[2] - points[0]) / 3.0;
                    controlPoint[3] = points[1] + (points[3] - points[1]) / 3.0;
                    this.pc.cubic(controlPoint[0], controlPoint[1], controlPoint[2], controlPoint[3], points[2], points[3]);
                    lastPoint[0] = points[2];
                    lastPoint[1] = points[3];
                    break;
                }
                case 3: {
                    this.pc.cubic(points[0], points[1], points[2], points[3], points[4], points[5]);
                    lastPoint[0] = points[4];
                    lastPoint[1] = points[5];
                    break;
                }
                case 4: {
                    this.pc.closePath(lastMove[0], lastMove[1]);
                    lastPoint[0] = 0.0;
                    lastPoint[1] = 0.0;
                }
            }
            pIter.next();
        }
        this.os.println("fill");
        this.os.println("\t\t} def");
        this.os.println();
    }

    @Override
    protected void writeWidths(double[] widths) throws IOException {
        this.os.println("\t/Metrics " + (this.getNODefinedChars() + 1) + " dict def");
        this.os.println("\t\tMetrics begin");
        this.os.println("\t\t/.notdef " + (int)this.getUndefinedWidth() + " def");
        for (int i = 1; i < 256; ++i) {
            if (this.getCharName(i) == null) continue;
            this.os.println("\t\t/" + this.getCharName(i) + " " + widths[i] + " def");
        }
        this.os.println("\tend");
    }

    @Override
    protected void writeEncoding(CharTable charTable) throws IOException {
        this.os.println("\t/Encoding 256 array def");
        this.os.println("\t\t\t0 1 255 {Encoding exch /.notdef put}for");
        for (int i = 1; i < 256; ++i) {
            String name = charTable.toName(i);
            if (name == null) continue;
            this.os.println("\t\tEncoding " + i + " /" + name + " put");
        }
    }

    @Override
    protected void openIncludeFont() throws IOException {
        Rectangle2D boundingBox = this.getFontBBox();
        double llx = boundingBox.getX();
        double lly = -boundingBox.getY() - boundingBox.getHeight();
        double urx = boundingBox.getX() + boundingBox.getWidth();
        double ury = -boundingBox.getY();
        this.os.println("9 dict begin");
        this.os.println("/FontType 3 def");
        this.os.println("/FontMatrix [0.0010 0 0 0.0010 0 0]def");
        this.os.println("/FontBBox [" + (int)llx + " " + (int)lly + " " + (int)urx + " " + (int)ury + " ] def");
    }

    @Override
    protected void closeIncludeFont() throws IOException {
        this.writeBuildProcs();
    }

    protected void writeBuildProcs() throws IOException {
        Rectangle2D boundingBox = this.getFontBBox();
        double llx = boundingBox.getX();
        double lly = -boundingBox.getY() - boundingBox.getHeight();
        double urx = boundingBox.getX() + boundingBox.getWidth();
        double ury = -boundingBox.getY();
        this.os.println("\t/BuildGlyph");
        this.os.println("\t\t{ 2 copy exch /Metrics get exch ");
        this.os.println("\t\t\t2 copy known {get}{pop pop " + this.getUndefinedWidth() + "} ifelse");
        this.os.println("\t\t\t0");
        this.os.println("\t\t\t" + (int)llx + " " + (int)lly + " " + (int)urx + " " + (int)ury);
        this.os.println("\t\t\tsetcachedevice");
        this.os.println("\t\t\texch /CharProcs get exch");
        this.os.println("\t\t\t2 copy known not");
        this.os.println("\t\t\t\t\t{pop /.notdef}");
        this.os.println("\t\t\t\tif");
        this.os.println("\t\t\tget exec");
        this.os.println("\t\t} bind def");
        this.os.println();
        this.os.println("\t/BuildChar");
        this.os.println("\t\t{ 1 index /Encoding get exch get");
        this.os.println("\t\t  1 index /BuildGlyph get exec");
        this.os.println("\t  } bind def");
    }

    @Override
    protected void openGlyphs() throws IOException {
        this.os.println("\t/CharProcs " + (this.getNODefinedChars() + 1) + " dict def");
        this.os.println("\tCharProcs begin");
        this.os.println("\t\t\t%define Glyph dictionary and start filling");
    }

    @Override
    protected void closeGlyphs() throws IOException {
        this.os.print("\tend");
        this.os.println("\t\t\t\t% close glyph dict. ");
    }

    @Override
    protected void closeEmbedFont() throws IOException {
        this.os.print("\tcurrentdict");
        this.os.println("\t\t\t% actually put dict on the stack");
        this.os.print("\tend");
        this.os.println("\t\t\t% close the dictionary now");
        this.os.println("\t/" + this.getFontName() + " exch definefont pop");
        this.os.flush();
    }
}

