/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.atomtype;

import java.util.List;
import org.openscience.cdk.atomtype.IAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.tools.LoggingToolFactory;

public class EStateAtomTypeMatcher
implements IAtomTypeMatcher {
    IRingSet ringSet = null;

    public void setRingSet(IRingSet rs) {
        this.ringSet = rs;
    }

    @Override
    public IAtomType[] findMatchingAtomTypes(IAtomContainer atomContainer) throws CDKException {
        IAtomType[] types = new IAtomType[atomContainer.getAtomCount()];
        int typeCounter = 0;
        for (IAtom atom : atomContainer.atoms()) {
            types[typeCounter] = this.findMatchingAtomType(atomContainer, atom);
            ++typeCounter;
        }
        return types;
    }

    @Override
    public IAtomType findMatchingAtomType(IAtomContainer atomContainer, IAtom atom) {
        IAtomType atomType = null;
        try {
            int j;
            int NumHAtoms;
            int NumSingleBonds2 = NumHAtoms = atom.getImplicitHydrogenCount() != null ? atom.getImplicitHydrogenCount() : 0;
            int NumDoubleBonds2 = 0;
            int NumTripleBonds2 = 0;
            int NumAromaticBonds2 = 0;
            int NumAromaticBondsTotal2 = 0;
            String element = atom.getSymbol();
            List<IAtom> attachedAtoms = atomContainer.getConnectedAtomsList(atom);
            for (j = 0; j <= attachedAtoms.size() - 1; ++j) {
                IAtom attached = attachedAtoms.get(j);
                IBond b = atomContainer.getBond(atom, attached);
                if (attached.getAtomicNumber() == 1) {
                    ++NumHAtoms;
                }
                if (atom.getFlag(32) && attached.getFlag(32)) {
                    boolean SameRing = EStateAtomTypeMatcher.inSameAromaticRing(atomContainer, atom, attached, this.ringSet);
                    if (SameRing) {
                        ++NumAromaticBonds2;
                        if (!element.equals("N")) continue;
                        if (b.getOrder() == IBond.Order.SINGLE) {
                            ++NumAromaticBondsTotal2;
                        }
                        if (b.getOrder() != IBond.Order.DOUBLE) continue;
                        NumAromaticBondsTotal2 += 2;
                        continue;
                    }
                    if (b.getOrder() == IBond.Order.SINGLE) {
                        ++NumSingleBonds2;
                    }
                    if (b.getOrder() == IBond.Order.DOUBLE) {
                        ++NumDoubleBonds2;
                    }
                    if (b.getOrder() != IBond.Order.TRIPLE) continue;
                    ++NumTripleBonds2;
                    continue;
                }
                if (b.getOrder() == IBond.Order.SINGLE) {
                    ++NumSingleBonds2;
                }
                if (b.getOrder() == IBond.Order.DOUBLE) {
                    ++NumDoubleBonds2;
                }
                if (b.getOrder() != IBond.Order.TRIPLE) continue;
                ++NumTripleBonds2;
            }
            NumSingleBonds2 -= NumHAtoms;
            String fragment = "S";
            for (j = 0; j <= NumTripleBonds2 - 1; ++j) {
                fragment = fragment + "t";
            }
            for (j = 0; j <= NumDoubleBonds2 - 1; ++j) {
                fragment = fragment + "d";
            }
            for (j = 0; j <= NumSingleBonds2 - 1; ++j) {
                fragment = fragment + "s";
            }
            for (j = 0; j <= NumAromaticBonds2 - 1; ++j) {
                fragment = fragment + "a";
            }
            fragment = fragment + element;
            if (atom.getFormalCharge() == 1) {
                fragment = fragment + "p";
            } else if (atom.getFormalCharge() == -1) {
                fragment = fragment + "m";
            }
            if (NumHAtoms == 1) {
                fragment = fragment + "H";
            } else if (NumHAtoms > 1) {
                fragment = fragment + "H" + NumHAtoms;
            }
            atomType = atom.getBuilder().newInstance(IAtomType.class, fragment, atom.getSymbol());
            atomType.setFormalCharge(atom.getFormalCharge());
            if (atom.getFlag(32)) {
                atomType.setFlag(32, true);
            }
        }
        catch (Exception e2) {
            LoggingToolFactory.createLoggingTool(EStateAtomTypeMatcher.class).warn("Unexpected Exception:", e2);
        }
        return atomType;
    }

    public static boolean inSameAromaticRing(IAtomContainer m, IAtom atom1, IAtom atom2, IRingSet rs) {
        if (rs == null) {
            return false;
        }
        for (int i = 0; i <= rs.getAtomContainerCount() - 1; ++i) {
            IRing r = (IRing)rs.getAtomContainer(i);
            if (!r.contains(atom1) || !r.contains(atom2) || !EStateAtomTypeMatcher.isAromaticRing(r)) continue;
            return true;
        }
        return false;
    }

    static boolean isAromaticRing(IRing ring) {
        for (int i = 0; i < ring.getAtomCount(); ++i) {
            if (ring.getAtom(i).getFlag(32)) continue;
            return false;
        }
        return true;
    }
}

