/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.charges;

import org.openscience.cdk.charges.GasteigerMarsiliPartialCharges;
import org.openscience.cdk.charges.GasteigerPEPEPartialCharges;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class PiElectronegativity {
    private GasteigerMarsiliPartialCharges peoe;
    private GasteigerPEPEPartialCharges pepe;
    private int maxI;
    private int maxRS;
    private IAtomContainer molPi;
    private IAtomContainer acOldP;
    private double[][] gasteigerFactors;
    private final ILoggingTool logger = LoggingToolFactory.createLoggingTool(PiElectronegativity.class);

    public PiElectronegativity() {
        this(6, 50);
    }

    public PiElectronegativity(int maxIterations, int maxResonStruc) {
        this.peoe = new GasteigerMarsiliPartialCharges();
        this.pepe = new GasteigerPEPEPartialCharges();
        this.maxI = maxIterations;
        this.maxRS = maxResonStruc;
    }

    public double calculatePiElectronegativity(IAtomContainer ac, IAtom atom) {
        return this.calculatePiElectronegativity(ac, atom, this.maxI, this.maxRS);
    }

    public double calculatePiElectronegativity(IAtomContainer ac, IAtom atom, int maxIterations, int maxResonStruc) {
        this.maxI = maxIterations;
        this.maxRS = maxResonStruc;
        double electronegativity = 0.0;
        try {
            if (!ac.equals(this.acOldP)) {
                this.molPi = ac.getBuilder().newInstance(IAtomContainer.class, ac);
                this.peoe = new GasteigerMarsiliPartialCharges();
                this.peoe.assignGasteigerMarsiliSigmaPartialCharges(this.molPi, true);
                IAtomContainerSet iSet = ac.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
                iSet.addAtomContainer(this.molPi);
                iSet.addAtomContainer(this.molPi);
                this.gasteigerFactors = this.pepe.assignrPiMarsilliFactors(iSet);
                this.acOldP = ac;
            }
            IAtom atomi = this.molPi.getAtom(ac.indexOf(atom));
            int atomPosition = this.molPi.indexOf(atomi);
            int stepSize = this.pepe.getStepSize();
            int start = stepSize * atomPosition + atomPosition;
            double q = atomi.getCharge();
            if (this.molPi.getConnectedLonePairsCount(this.molPi.getAtom(atomPosition)) > 0 || this.molPi.getMaximumBondOrder(atomi) != IBond.Order.SINGLE || atomi.getFormalCharge() != 0) {
                return this.gasteigerFactors[1][start] + q * this.gasteigerFactors[1][start + 1] + this.gasteigerFactors[1][start + 2] * (q * q);
            }
        }
        catch (Exception e2) {
            this.logger.error(e2);
        }
        return electronegativity;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxI = maxIterations;
    }

    public void setMaxResonStruc(int maxResonStruc) {
        this.maxRS = maxResonStruc;
    }

    public int getMaxIterations() {
        return this.maxI;
    }

    public int getMaxResonStruc() {
        return this.maxRS;
    }
}

