/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.BitSet;
import java.util.Map;
import org.openscience.cdk.config.fragments.EStateFragments;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.AbstractFingerprinter;
import org.openscience.cdk.fingerprint.BitSetFingerprint;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.fingerprint.ICountFingerprint;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smarts.SmartsPattern;

public class EStateFingerprinter
extends AbstractFingerprinter
implements IFingerprinter {
    private static final SmartsPattern[] PATTERNS = EStateFragments.getPatterns();

    @Override
    public IBitFingerprint getBitFingerprint(IAtomContainer atomContainer) throws CDKException {
        int bitsetLength = PATTERNS.length;
        BitSet fingerPrint = new BitSet(bitsetLength);
        SmartsPattern.prepare(atomContainer);
        for (int i = 0; i < PATTERNS.length; ++i) {
            if (!PATTERNS[i].matches(atomContainer)) continue;
            fingerPrint.set(i, true);
        }
        return new BitSetFingerprint(fingerPrint);
    }

    @Override
    public Map<String, Integer> getRawFingerprint(IAtomContainer iAtomContainer) throws CDKException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSize() {
        return PATTERNS.length;
    }

    @Override
    public ICountFingerprint getCountFingerprint(IAtomContainer container2) throws CDKException {
        throw new UnsupportedOperationException();
    }
}

