/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Map;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.AbstractFingerprinter;
import org.openscience.cdk.fingerprint.BitSetFingerprint;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.fingerprint.ICountFingerprint;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.fingerprint.ShortestPathWalker;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

public class ShortestPathFingerprinter
extends AbstractFingerprinter
implements IFingerprinter,
Serializable {
    public static final int DEFAULT_SIZE = 1024;
    private static final long serialVersionUID = 7867864332244557861L;
    private final int fingerprintLength;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(ShortestPathFingerprinter.class);

    public ShortestPathFingerprinter() {
        this(1024);
    }

    public ShortestPathFingerprinter(int fingerprintLength) {
        this.fingerprintLength = fingerprintLength;
    }

    @Override
    public IBitFingerprint getBitFingerprint(IAtomContainer ac) throws CDKException {
        IAtomContainer atomContainer = null;
        try {
            atomContainer = ac.clone();
        }
        catch (CloneNotSupportedException ex) {
            logger.error("Failed to clone the molecule:", ex);
        }
        Aromaticity.cdkLegacy().apply(atomContainer);
        BitSet bitSet = new BitSet(this.fingerprintLength);
        if (!ConnectivityChecker.isConnected(atomContainer)) {
            IAtomContainerSet partitionedMolecules = ConnectivityChecker.partitionIntoMolecules(atomContainer);
            for (IAtomContainer container2 : partitionedMolecules.atomContainers()) {
                this.addUniquePath(container2, bitSet);
            }
        } else {
            this.addUniquePath(atomContainer, bitSet);
        }
        return new BitSetFingerprint(bitSet);
    }

    @Override
    public Map<String, Integer> getRawFingerprint(IAtomContainer ac) throws CDKException {
        throw new UnsupportedOperationException();
    }

    private void addUniquePath(IAtomContainer container2, BitSet bitSet) {
        Integer[] hashes;
        for (Integer hash : hashes = this.findPaths(container2)) {
            int position = this.getRandomNumber(hash.intValue());
            bitSet.set(position);
        }
    }

    private void addUniquePath(IAtomContainer atomContainer, Map<String, Integer> uniquePaths) {
        Integer[] hashes;
        for (Integer hash : hashes = this.findPaths(atomContainer)) {
            int position = this.getRandomNumber(hash.intValue());
            uniquePaths.put(String.valueOf(position), hash);
        }
    }

    private Integer[] findPaths(IAtomContainer container2) {
        ShortestPathWalker walker = new ShortestPathWalker(container2);
        ArrayList<Integer> paths = new ArrayList<Integer>();
        int patternIndex = 0;
        for (String string : walker.paths()) {
            int toHashCode = string.hashCode();
            paths.add(patternIndex, toHashCode);
            ++patternIndex;
        }
        IRingSet sssr = Cycles.essential(container2).toRingSet();
        RingSetManipulator.sort(sssr);
        for (IAtomContainer ring : sssr.atomContainers()) {
            int toHashCode = String.valueOf(ring.getAtomCount()).hashCode();
            paths.add(patternIndex, toHashCode);
            ++patternIndex;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (IAtom atom : container2.atoms()) {
            int charge = atom.getFormalCharge() == null ? 0 : atom.getFormalCharge();
            if (charge == 0) continue;
            arrayList.add(atom.getSymbol().concat(String.valueOf(charge)));
        }
        Collections.sort(arrayList);
        int toHashCode = arrayList.hashCode();
        paths.add(patternIndex, toHashCode);
        ++patternIndex;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (IAtom atom : container2.atoms()) {
            int st = atom.getStereoParity() == null ? 0 : atom.getStereoParity();
            if (st == 0) continue;
            arrayList2.add(atom.getSymbol().concat(String.valueOf(st)));
        }
        Collections.sort(arrayList2);
        toHashCode = arrayList2.hashCode();
        paths.add(patternIndex, toHashCode);
        ++patternIndex;
        if (container2.getSingleElectronCount() > 0) {
            StringBuilder radicalInformation = new StringBuilder();
            radicalInformation.append("RAD: ").append(container2.getSingleElectronCount());
            paths.add(patternIndex, radicalInformation.toString().hashCode());
            ++patternIndex;
        }
        if (container2.getLonePairCount() > 0) {
            StringBuilder lpInformation = new StringBuilder();
            lpInformation.append("LP: ").append(container2.getLonePairCount());
            paths.add(patternIndex, lpInformation.toString().hashCode());
            ++patternIndex;
        }
        return paths.toArray(new Integer[paths.size()]);
    }

    @Override
    public int getSize() {
        return this.fingerprintLength;
    }

    @Override
    public ICountFingerprint getCountFingerprint(IAtomContainer iac) throws CDKException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private int getRandomNumber(long seed) {
        seed ^= seed << 21;
        seed ^= seed >>> 35;
        seed ^= seed << 4;
        return (int)(Math.abs(seed) % (long)this.fingerprintLength);
    }
}

