/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.interfaces.IAdductFormula;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IMolecularFormulaSet;

public class AdductFormula
implements Iterable<IMolecularFormula>,
IAdductFormula,
Cloneable {
    private static final long serialVersionUID = -811384981700039389L;
    private final List<IMolecularFormula> components = new ArrayList<IMolecularFormula>();

    public AdductFormula() {
    }

    public AdductFormula(IMolecularFormula formula) {
        this.components.add(0, formula);
    }

    @Override
    public void addMolecularFormula(IMolecularFormula formula) {
        this.components.add(formula);
    }

    @Override
    public void add(IMolecularFormulaSet formulaSet) {
        for (IMolecularFormula mf : formulaSet.molecularFormulas()) {
            this.addMolecularFormula(mf);
        }
    }

    @Override
    public boolean contains(IIsotope isotope) {
        for (IIsotope thisIsotope : this.isotopes()) {
            if (!this.isTheSame(thisIsotope, isotope)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Integer getCharge() {
        Integer charge = 0;
        for (IMolecularFormula component : this.components) {
            charge = charge + component.getCharge();
        }
        return charge;
    }

    @Override
    public int getIsotopeCount(IIsotope isotope) {
        int count = 0;
        for (IMolecularFormula component : this.components) {
            count += component.getIsotopeCount(isotope);
        }
        return count;
    }

    @Override
    public int getIsotopeCount() {
        return this.isotopesList().size();
    }

    @Override
    public Iterable<IIsotope> isotopes() {
        return new Iterable<IIsotope>(){

            @Override
            public Iterator<IIsotope> iterator() {
                return AdductFormula.this.isotopesList().iterator();
            }
        };
    }

    private List<IIsotope> isotopesList() {
        ArrayList<IIsotope> isotopes = new ArrayList<IIsotope>();
        for (IMolecularFormula component : this.components) {
            for (IIsotope isotope : component.isotopes()) {
                if (isotopes.contains(isotope)) continue;
                isotopes.add(isotope);
            }
        }
        return isotopes;
    }

    @Override
    public void setCharge(Integer charge) {
        throw new IllegalAccessError();
    }

    @Override
    public Iterable<IMolecularFormula> molecularFormulas() {
        return this.components;
    }

    @Override
    public Iterator<IMolecularFormula> iterator() {
        return this.components.iterator();
    }

    @Override
    public int size() {
        return this.components.size();
    }

    @Override
    public boolean contains(IMolecularFormula formula) {
        return this.components.contains(formula);
    }

    @Override
    public IMolecularFormula getMolecularFormula(int position) {
        return this.components.get(position);
    }

    @Override
    public void removeAllMolecularFormulas() {
        this.components.clear();
    }

    @Override
    public void removeMolecularFormula(IMolecularFormula formula) {
        this.components.remove(formula);
    }

    @Override
    public void removeMolecularFormula(int position) {
        this.components.remove(position);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AdductFormula clone = new AdductFormula();
        for (IMolecularFormula form : this.molecularFormulas()) {
            clone.addMolecularFormula((IMolecularFormula)form.clone());
        }
        return clone;
    }

    private boolean isTheSame(IIsotope isotopeOne, IIsotope isotopeTwo) {
        if (!Objects.equals(isotopeOne.getSymbol(), isotopeTwo.getSymbol())) {
            return false;
        }
        if (!Objects.equals(isotopeOne.getNaturalAbundance(), isotopeTwo.getNaturalAbundance())) {
            return false;
        }
        return Objects.equals(isotopeOne.getExactMass(), isotopeTwo.getExactMass());
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return DefaultChemObjectBuilder.getInstance();
    }
}

