/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;

public class MolecularFormula
implements IMolecularFormula {
    private static final long serialVersionUID = -2011407700837295287L;
    private final Map<IIsotope, Integer> isotopes = new HashMap<IIsotope, Integer>();
    private Integer charge = null;
    private Map<Object, Object> properties;

    @Override
    public IMolecularFormula add(IMolecularFormula formula) {
        for (IIsotope newIsotope : formula.isotopes()) {
            this.addIsotope(newIsotope, formula.getIsotopeCount(newIsotope));
        }
        if (formula.getCharge() != null) {
            this.charge = this.charge != null ? Integer.valueOf(this.charge + formula.getCharge()) : formula.getCharge();
        }
        return this;
    }

    @Override
    public IMolecularFormula addIsotope(IIsotope isotope) {
        return this.addIsotope(isotope, 1);
    }

    @Override
    public IMolecularFormula addIsotope(IIsotope isotope, int count) {
        if (count == 0) {
            return this;
        }
        boolean flag = false;
        for (IIsotope thisIsotope : this.isotopes()) {
            if (!this.isTheSame(thisIsotope, isotope)) continue;
            this.isotopes.put(thisIsotope, this.isotopes.get(thisIsotope) + count);
            flag = true;
            break;
        }
        if (!flag) {
            this.isotopes.put(isotope, count);
        }
        return this;
    }

    @Override
    public boolean contains(IIsotope isotope) {
        for (IIsotope thisIsotope : this.isotopes()) {
            if (!this.isTheSame(thisIsotope, isotope)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Integer getCharge() {
        return this.charge;
    }

    @Override
    public int getIsotopeCount(IIsotope isotope) {
        return !this.contains(isotope) ? 0 : this.isotopes.get(this.getIsotope(isotope));
    }

    @Override
    public int getIsotopeCount() {
        return this.isotopes.size();
    }

    private IIsotope getIsotope(IIsotope isotope) {
        for (IIsotope thisIsotope : this.isotopes()) {
            if (!this.isTheSame(isotope, thisIsotope)) continue;
            return thisIsotope;
        }
        return null;
    }

    @Override
    public Iterable<IIsotope> isotopes() {
        return this.isotopes.keySet();
    }

    @Override
    public void setCharge(Integer charge) {
        this.charge = charge;
    }

    @Override
    public void removeAllIsotopes() {
        this.isotopes.clear();
    }

    @Override
    public void removeIsotope(IIsotope isotope) {
        this.isotopes.remove(this.getIsotope(isotope));
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MolecularFormula clone = new MolecularFormula();
        for (IIsotope isotope : this.isotopes()) {
            clone.addIsotope((IIsotope)isotope.clone(), this.getIsotopeCount(isotope));
        }
        clone.setCharge(this.getCharge());
        return clone;
    }

    private Map<Object, Object> lazyProperties() {
        if (this.properties == null) {
            this.properties = new Hashtable<Object, Object>();
        }
        return this.properties;
    }

    @Override
    public void setProperty(Object description, Object property) {
        this.lazyProperties().put(description, property);
    }

    @Override
    public void removeProperty(Object description) {
        if (this.properties == null) {
            return;
        }
        this.lazyProperties().remove(description);
    }

    @Override
    public <T> T getProperty(Object description) {
        if (this.properties == null) {
            return null;
        }
        Object value = this.lazyProperties().get(description);
        return (T)value;
    }

    @Override
    public <T> T getProperty(Object description, Class<T> c) {
        Object value = this.lazyProperties().get(description);
        if (c.isInstance(value)) {
            Object typed = value;
            return (T)typed;
        }
        if (value != null) {
            throw new IllegalArgumentException("attempted to access a property of incorrect type, expected " + c.getSimpleName() + " got " + value.getClass().getSimpleName());
        }
        return null;
    }

    @Override
    public Map<Object, Object> getProperties() {
        return this.lazyProperties();
    }

    @Override
    public void setProperties(Map<Object, Object> properties) {
        for (Object key : properties.keySet()) {
            this.lazyProperties().put(key, properties.get(key));
        }
    }

    protected boolean isTheSame(IIsotope isotopeOne, IIsotope isotopeTwo) {
        if (!Objects.equals(isotopeOne.getMassNumber(), isotopeTwo.getMassNumber())) {
            return false;
        }
        Double natAbund1 = isotopeOne.getNaturalAbundance();
        Double natAbund2 = isotopeTwo.getNaturalAbundance();
        Double exactMass1 = isotopeOne.getExactMass();
        Double exactMass2 = isotopeTwo.getExactMass();
        if (natAbund1 == null) {
            natAbund1 = -1.0;
        }
        if (natAbund2 == null) {
            natAbund2 = -1.0;
        }
        if (exactMass1 == null) {
            exactMass1 = -1.0;
        }
        if (exactMass2 == null) {
            exactMass2 = -1.0;
        }
        if (!isotopeOne.getAtomicNumber().equals(isotopeTwo.getAtomicNumber())) {
            return false;
        }
        if (natAbund1.doubleValue() != natAbund2.doubleValue()) {
            return false;
        }
        return exactMass1.doubleValue() == exactMass2.doubleValue();
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return DefaultChemObjectBuilder.getInstance();
    }
}

