/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula.rules;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.formula.rules.IRule;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.MolecularFormulaManipulator;

public class NitrogenRule
implements IRule {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(NitrogenRule.class);

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params != null) {
            throw new CDKException("NitrogenRule doesn't expect parameters");
        }
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public double validate(IMolecularFormula formula) throws CDKException {
        logger.info("Start validation of ", formula);
        double mass = MolecularFormulaManipulator.getTotalMassNumber(formula);
        if (mass == 0.0) {
            return 0.0;
        }
        int numberN = MolecularFormulaManipulator.getElementCount(formula, formula.getBuilder().newInstance(IElement.class, "N"));
        numberN += this.getOthers(formula);
        if (formula.getCharge() == null || formula.getCharge() == 0 || !this.isOdd(Math.abs(formula.getCharge()))) {
            if (this.isOdd(mass) && this.isOdd(numberN)) {
                return 1.0;
            }
            if (!(this.isOdd(mass) || numberN != 0 && this.isOdd(numberN))) {
                return 1.0;
            }
            return 0.0;
        }
        if (!this.isOdd(mass) && this.isOdd(numberN)) {
            return 1.0;
        }
        if (this.isOdd(mass) && (numberN == 0 || !this.isOdd(numberN))) {
            return 1.0;
        }
        return 0.0;
    }

    private int getOthers(IMolecularFormula formula) {
        String[] elements;
        int number = 0;
        for (String element : elements = new String[]{"Co", "Hg", "Pt", "As"}) {
            number += MolecularFormulaManipulator.getElementCount(formula, formula.getBuilder().newInstance(IElement.class, element));
        }
        return number;
    }

    private boolean isOdd(double value) {
        return value % 2.0 != 0.0;
    }
}

