/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.graph.ConnectedComponents;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.tools.manipulator.SgroupManipulator;

public class ConnectivityChecker {
    public static boolean isConnected(IAtomContainer atomContainer) {
        if (atomContainer.getAtomCount() < 2) {
            return true;
        }
        ConnectedComponents cc = new ConnectedComponents(GraphUtil.toAdjList(atomContainer));
        return cc.nComponents() == 1;
    }

    public static IAtomContainerSet partitionIntoMolecules(IAtomContainer container2) {
        ConnectedComponents cc = new ConnectedComponents(GraphUtil.toAdjList(container2));
        if (cc.nComponents() == 1) {
            return ConnectivityChecker.singleton(container2);
        }
        return ConnectivityChecker.partitionIntoMolecules(container2, cc.components());
    }

    private static IAtomContainerSet singleton(IAtomContainer container2) {
        IChemObjectBuilder bldr = container2.getBuilder();
        IAtomContainerSet acSet = bldr.newInstance(IAtomContainerSet.class, new Object[0]);
        acSet.addAtomContainer(container2);
        return acSet;
    }

    private static IAtomContainerSet empty(IAtomContainer container2) {
        IChemObjectBuilder bldr = container2.getBuilder();
        return bldr.newInstance(IAtomContainerSet.class, new Object[0]);
    }

    private static IAtomContainer getComponent(Map<IAtom, IAtomContainer> cmap, IChemObject cobj) {
        if (cobj instanceof IAtom) {
            return cmap.get(cobj);
        }
        if (cobj instanceof IBond) {
            IAtomContainer endMol;
            IAtomContainer begMol = cmap.get(((IBond)cobj).getBegin());
            return begMol == (endMol = cmap.get(((IBond)cobj).getEnd())) ? begMol : null;
        }
        return null;
    }

    private static IAtomContainer getComponent(Map<IAtom, IAtomContainer> cmap, IStereoElement<?, ?> se) {
        IAtomContainer mol = ConnectivityChecker.getComponent(cmap, se.getFocus());
        for (IChemObject cobj : se.getCarriers()) {
            IAtomContainer tmp = ConnectivityChecker.getComponent(cmap, cobj);
            if (tmp == mol) continue;
            return null;
        }
        return mol;
    }

    private static IAtomContainer getComponent(Map<IAtom, IAtomContainer> cmap, Sgroup sgroup) {
        IAtomContainer mol = null;
        for (IAtom atom : sgroup.getAtoms()) {
            IAtomContainer tmp = cmap.get(atom);
            if (mol == null) {
                mol = tmp;
                continue;
            }
            if (mol == tmp) continue;
            return null;
        }
        return mol;
    }

    private static void addSgroup(IAtomContainer component, Sgroup sgroup) {
        ArrayList<Sgroup> sgroups = (ArrayList<Sgroup>)component.getProperty("cdk:CtabSgroups");
        if (sgroups == null) {
            sgroups = new ArrayList<Sgroup>();
            component.setProperty("cdk:CtabSgroups", sgroups);
        }
        sgroups.add(sgroup);
    }

    public static IAtomContainerSet partitionIntoMolecules(IAtomContainer container2, int[] components) {
        int minComponentIndex = Integer.MAX_VALUE;
        int maxComponentIndex = 0;
        for (int component : components) {
            minComponentIndex = Math.min(component, minComponentIndex);
            maxComponentIndex = Math.max(component, maxComponentIndex);
        }
        if (minComponentIndex == maxComponentIndex) {
            if (maxComponentIndex == 0) {
                return ConnectivityChecker.empty(container2);
            }
            return ConnectivityChecker.singleton(container2);
        }
        IAtomContainer[] containers = new IAtomContainer[maxComponentIndex + 1];
        HashMap<IAtom, IAtomContainer> componentsMap = new HashMap<IAtom, IAtomContainer>(2 * container2.getAtomCount());
        for (int i = 1; i < containers.length; ++i) {
            containers[i] = container2.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        }
        IAtomContainerSet containerSet = container2.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        for (int i = 0; i < container2.getAtomCount(); ++i) {
            IAtom origAtom = container2.getAtom(i);
            IAtomContainer newContainer = containers[components[i]];
            componentsMap.put(origAtom, newContainer);
            newContainer.addAtom(origAtom);
        }
        for (IBond bond : container2.bonds()) {
            IAtomContainer endComp;
            IAtomContainer begComp = (IAtomContainer)componentsMap.get(bond.getBegin());
            if (begComp != (endComp = (IAtomContainer)componentsMap.get(bond.getEnd()))) continue;
            begComp.addBond(bond);
        }
        for (ISingleElectron electron : container2.singleElectrons()) {
            ((IAtomContainer)componentsMap.get(electron.getAtom())).addSingleElectron(electron);
        }
        for (ILonePair lonePair : container2.lonePairs()) {
            ((IAtomContainer)componentsMap.get(lonePair.getAtom())).addLonePair(lonePair);
        }
        for (IStereoElement stereo : container2.stereoElements()) {
            IAtomContainer component = ConnectivityChecker.getComponent(componentsMap, stereo);
            if (component == null) continue;
            component.addStereoElement(stereo);
        }
        List<Sgroup> sgroups = SgroupManipulator.copy((Collection)container2.getProperty("cdk:CtabSgroups"), new HashMap());
        if (sgroups != null) {
            HashMap sgroupMap = new HashMap();
            for (Sgroup sgroup : sgroups) {
                IAtomContainer component = ConnectivityChecker.getComponent(componentsMap, sgroup);
                if (component == null) continue;
                ConnectivityChecker.addSgroup(component, sgroup);
            }
            for (Sgroup sgroup : sgroups) {
                HashSet<Sgroup> toremove = new HashSet<Sgroup>();
                for (Sgroup parent : sgroup.getParents()) {
                    if (sgroupMap.get(parent) != null) continue;
                    toremove.add(parent);
                }
                sgroup.removeParents(toremove);
            }
        }
        for (int i = 1; i < containers.length; ++i) {
            containerSet.addAtomContainer(containers[i]);
        }
        return containerSet;
    }
}

