/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph.matrix;

import org.openscience.cdk.graph.matrix.IGraphMatrix;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.tools.manipulator.BondManipulator;

public class ConnectionMatrix
implements IGraphMatrix {
    public static double[][] getMatrix(IAtomContainer container2) {
        double[][] conMat = new double[container2.getAtomCount()][container2.getAtomCount()];
        for (int f = 0; f < container2.getBondCount(); ++f) {
            IBond bond = container2.getBond(f);
            int indexAtom1 = container2.indexOf(bond.getBegin());
            int indexAtom2 = container2.indexOf(bond.getEnd());
            conMat[indexAtom1][indexAtom2] = BondManipulator.destroyBondOrder(bond.getOrder());
            conMat[indexAtom2][indexAtom1] = BondManipulator.destroyBondOrder(bond.getOrder());
        }
        return conMat;
    }
}

