/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph.rebond;

import java.util.Iterator;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.rebond.Bspt;
import org.openscience.cdk.graph.rebond.Point;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

public class RebondTool {
    private double maxCovalentRadius;
    private final double minBondDistance;
    private final double bondTolerance;
    private Bspt bspt;

    public RebondTool(double maxCovalentRadius, double minBondDistance, double bondTolerance) {
        this.maxCovalentRadius = maxCovalentRadius;
        this.bondTolerance = bondTolerance;
        this.minBondDistance = minBondDistance;
        this.bspt = null;
    }

    public void rebond(IAtomContainer container2) throws CDKException {
        container2.removeAllBonds();
        this.maxCovalentRadius = 0.0;
        this.bspt = new Bspt(3);
        for (IAtom atom : container2.atoms()) {
            double myCovalentRadius = atom.getCovalentRadius();
            if (myCovalentRadius == 0.0) {
                throw new CDKException("Atom(s) does not have covalentRadius defined.");
            }
            if (myCovalentRadius > this.maxCovalentRadius) {
                this.maxCovalentRadius = myCovalentRadius;
            }
            TupleAtom tupleAtom = new TupleAtom(atom);
            this.bspt.addTuple(tupleAtom);
        }
        Iterator<IAtom> atoms = container2.atoms().iterator();
        while (atoms.hasNext()) {
            this.bondAtom(container2, atoms.next());
        }
    }

    private void bondAtom(IAtomContainer container2, IAtom atom) {
        double myCovalentRadius = atom.getCovalentRadius();
        double searchRadius = myCovalentRadius + this.maxCovalentRadius + this.bondTolerance;
        Point tupleAtom = new Point(atom.getPoint3d().x, atom.getPoint3d().y, atom.getPoint3d().z);
        Bspt.EnumerateSphere e2 = this.bspt.enumHemiSphere(tupleAtom, searchRadius);
        while (e2.hasMoreElements()) {
            boolean bonded;
            IAtom atomNear = ((TupleAtom)e2.nextElement()).getAtom();
            if (atomNear.equals(atom) || container2.getBond(atom, atomNear) != null || !(bonded = this.isBonded(myCovalentRadius, atomNear.getCovalentRadius(), e2.foundDistance2()))) continue;
            IBond bond = atom.getBuilder().newInstance(IBond.class, new Object[]{atom, atomNear, IBond.Order.SINGLE});
            container2.addBond(bond);
        }
    }

    private boolean isBonded(double covalentRadiusA, double covalentRadiusB, double distance2) {
        double maxAcceptable = covalentRadiusA + covalentRadiusB + this.bondTolerance;
        double maxAcceptable2 = maxAcceptable * maxAcceptable;
        double minBondDistance2 = this.minBondDistance * this.minBondDistance;
        if (distance2 < minBondDistance2) {
            return false;
        }
        return distance2 <= maxAcceptable2;
    }

    class TupleAtom
    implements Bspt.Tuple {
        final IAtom atom;

        TupleAtom(IAtom atom) {
            this.atom = atom;
        }

        @Override
        public double getDimValue(int dim) {
            if (dim == 0) {
                return this.atom.getPoint3d().x;
            }
            if (dim == 1) {
                return this.atom.getPoint3d().y;
            }
            return this.atom.getPoint3d().z;
        }

        public IAtom getAtom() {
            return this.atom;
        }

        public String toString() {
            return "<" + this.atom.getPoint3d().x + "," + this.atom.getPoint3d().y + "," + this.atom.getPoint3d().z + ">";
        }
    }
}

