/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash;

import org.openscience.cdk.hash.AbstractAtomHashGenerator;
import org.openscience.cdk.hash.AtomHashGenerator;
import org.openscience.cdk.hash.Pseudorandom;
import org.openscience.cdk.hash.Suppressed;
import org.openscience.cdk.hash.stereo.StereoEncoder;
import org.openscience.cdk.hash.stereo.StereoEncoderFactory;
import org.openscience.cdk.interfaces.IAtomContainer;

final class BasicAtomHashGenerator
extends AbstractAtomHashGenerator
implements AtomHashGenerator {
    private final AtomHashGenerator seedGenerator;
    private final StereoEncoderFactory factory;
    private final int depth;

    public BasicAtomHashGenerator(AtomHashGenerator seedGenerator, Pseudorandom pseudorandom, StereoEncoderFactory factory, int depth) {
        super(pseudorandom);
        if (seedGenerator == null) {
            throw new NullPointerException("seed generator cannot be null");
        }
        if (depth < 0) {
            throw new IllegalArgumentException("depth cannot be less then 0");
        }
        this.seedGenerator = seedGenerator;
        this.factory = factory;
        this.depth = depth;
    }

    public BasicAtomHashGenerator(AtomHashGenerator seedGenerator, Pseudorandom pseudorandom, int depth) {
        this(seedGenerator, pseudorandom, StereoEncoderFactory.EMPTY, depth);
    }

    @Override
    public long[] generate(IAtomContainer container2) {
        int[][] graph = BasicAtomHashGenerator.toAdjList(container2);
        return this.generate(this.seedGenerator.generate(container2), this.factory.create(container2, graph), graph, Suppressed.none());
    }

    @Override
    long[] generate(long[] current, StereoEncoder encoder, int[][] graph, Suppressed suppressed) {
        int n = graph.length;
        long[] next = BasicAtomHashGenerator.copy(current);
        long[] unique = new long[n];
        long[] included = new long[n];
        while (encoder.encode(current, next)) {
            BasicAtomHashGenerator.copy(next, current);
        }
        for (int d = 0; d < this.depth; ++d) {
            for (int v = 0; v < n; ++v) {
                next[v] = this.next(graph, v, current, unique, included);
            }
            BasicAtomHashGenerator.copy(next, current);
            while (encoder.encode(current, next)) {
                BasicAtomHashGenerator.copy(next, current);
            }
        }
        return current;
    }

    long next(int[][] graph, int v, long[] current, long[] unique, long[] included) {
        long invariant = this.distribute(current[v]);
        int nUnique = 0;
        for (int w : graph[v]) {
            int i;
            long adjInv = current[w];
            for (i = 0; i < nUnique && unique[i] != adjInv; ++i) {
            }
            included[i] = i == nUnique ? (unique[nUnique++] = adjInv) : this.rotate(included[i]);
            invariant ^= included[i];
        }
        return invariant;
    }
}

