/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash.stereo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.hash.stereo.BasicPermutationParity;
import org.openscience.cdk.hash.stereo.CombinedPermutationParity;
import org.openscience.cdk.hash.stereo.GeometricDoubleBondEncoderFactory;
import org.openscience.cdk.hash.stereo.GeometricParity;
import org.openscience.cdk.hash.stereo.GeometryEncoder;
import org.openscience.cdk.hash.stereo.MultiStereoEncoder;
import org.openscience.cdk.hash.stereo.PermutationParity;
import org.openscience.cdk.hash.stereo.StereoEncoder;
import org.openscience.cdk.hash.stereo.StereoEncoderFactory;
import org.openscience.cdk.hash.stereo.Tetrahedral2DParity;
import org.openscience.cdk.hash.stereo.Tetrahedral3DParity;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

public class GeometricCumulativeDoubleBondFactory
implements StereoEncoderFactory {
    @Override
    public StereoEncoder create(IAtomContainer container2, int[][] graph) {
        int n = container2.getAtomCount();
        BondMap map = new BondMap(n);
        ArrayList<StereoEncoder> encoders = new ArrayList<StereoEncoder>(1);
        for (IBond bond : container2.bonds()) {
            if (!GeometricCumulativeDoubleBondFactory.isDoubleBond(bond)) continue;
            map.add(bond);
        }
        HashSet<IAtom> visited = new HashSet<IAtom>(n);
        for (IAtom a : map.atoms()) {
            StereoEncoder encoder;
            IAtom q;
            IAtom p;
            List<IBond> bonds = map.bonds(a);
            if (bonds.size() != 2) continue;
            IAtom s = bonds.get(0).getOther(a);
            IAtom e2 = bonds.get(1).getOther(a);
            IAtom sParent = a;
            IAtom eParent = a;
            visited.add(a);
            visited.add(s);
            visited.add(e2);
            int size = 2;
            while (s != null && map.cumulated(s)) {
                p = map.bonds(s).get(0).getOther(s);
                q = map.bonds(s).get(1).getOther(s);
                sParent = s;
                s = visited.add(p) ? p : (visited.add(q) ? q : null);
                ++size;
            }
            while (e2 != null && map.cumulated(e2)) {
                p = map.bonds(e2).get(0).getOther(e2);
                q = map.bonds(e2).get(1).getOther(e2);
                eParent = e2;
                e2 = visited.add(p) ? p : (visited.add(q) ? q : null);
                ++size;
            }
            if (s == null || e2 == null) continue;
            if (GeometricCumulativeDoubleBondFactory.isOdd(size)) {
                encoder = GeometricDoubleBondEncoderFactory.newEncoder(container2, s, sParent, e2, eParent, graph);
                if (encoder == null) continue;
                encoders.add(encoder);
                continue;
            }
            encoder = GeometricCumulativeDoubleBondFactory.axialEncoder(container2, s, e2);
            if (encoder == null) continue;
            encoders.add(encoder);
        }
        return encoders.isEmpty() ? StereoEncoder.EMPTY : new MultiStereoEncoder(encoders);
    }

    static StereoEncoder axialEncoder(IAtomContainer container2, IAtom start, IAtom end) {
        List<IBond> startBonds = container2.getConnectedBondsList(start);
        List<IBond> endBonds = container2.getConnectedBondsList(end);
        if (startBonds.size() < 2 || endBonds.size() < 2) {
            return null;
        }
        if (GeometricCumulativeDoubleBondFactory.has2DCoordinates(startBonds) && GeometricCumulativeDoubleBondFactory.has2DCoordinates(endBonds)) {
            return GeometricCumulativeDoubleBondFactory.axial2DEncoder(container2, start, startBonds, end, endBonds);
        }
        if (GeometricCumulativeDoubleBondFactory.has3DCoordinates(startBonds) && GeometricCumulativeDoubleBondFactory.has3DCoordinates(endBonds)) {
            return GeometricCumulativeDoubleBondFactory.axial3DEncoder(container2, start, startBonds, end, endBonds);
        }
        return null;
    }

    private static StereoEncoder axial2DEncoder(IAtomContainer container2, IAtom start, List<IBond> startBonds, IAtom end, List<IBond> endBonds) {
        Point2d[] ps = new Point2d[4];
        int[] es = new int[4];
        CombinedPermutationParity perm = new CombinedPermutationParity(GeometricCumulativeDoubleBondFactory.fill2DCoordinates(container2, start, startBonds, ps, es, 0), GeometricCumulativeDoubleBondFactory.fill2DCoordinates(container2, end, endBonds, ps, es, 2));
        Tetrahedral2DParity geom = new Tetrahedral2DParity(ps, es);
        int u = container2.indexOf(start);
        int v = container2.indexOf(end);
        return new GeometryEncoder(new int[]{u, v}, (PermutationParity)perm, (GeometricParity)geom);
    }

    private static StereoEncoder axial3DEncoder(IAtomContainer container2, IAtom start, List<IBond> startBonds, IAtom end, List<IBond> endBonds) {
        Point3d[] coordinates = new Point3d[4];
        CombinedPermutationParity perm = new CombinedPermutationParity(GeometricCumulativeDoubleBondFactory.fill3DCoordinates(container2, start, startBonds, coordinates, 0), GeometricCumulativeDoubleBondFactory.fill3DCoordinates(container2, end, endBonds, coordinates, 2));
        Tetrahedral3DParity geom = new Tetrahedral3DParity(coordinates);
        int u = container2.indexOf(start);
        int v = container2.indexOf(end);
        return new GeometryEncoder(new int[]{u, v}, (PermutationParity)perm, (GeometricParity)geom);
    }

    private static PermutationParity fill2DCoordinates(IAtomContainer container2, IAtom a, List<IBond> connected, Point2d[] coordinates, int[] elevations, int offset) {
        int i = 0;
        coordinates[offset + 1] = a.getPoint2d();
        elevations[offset + 1] = 0;
        int[] indices = new int[2];
        for (IBond bond : connected) {
            if (GeometricCumulativeDoubleBondFactory.isDoubleBond(bond)) continue;
            IAtom other = bond.getOther(a);
            coordinates[i + offset] = other.getPoint2d();
            elevations[i + offset] = GeometricCumulativeDoubleBondFactory.elevation(bond, a);
            indices[i] = container2.indexOf(other);
            ++i;
        }
        if (i == 1) {
            return PermutationParity.IDENTITY;
        }
        return new BasicPermutationParity(indices);
    }

    private static PermutationParity fill3DCoordinates(IAtomContainer container2, IAtom a, List<IBond> connected, Point3d[] coordinates, int offset) {
        int i = 0;
        int[] indices = new int[2];
        for (IBond bond : connected) {
            if (GeometricCumulativeDoubleBondFactory.isDoubleBond(bond)) continue;
            IAtom other = bond.getOther(a);
            coordinates[i + offset] = other.getPoint3d();
            indices[i] = container2.indexOf(other);
            ++i;
        }
        if (i == 1) {
            coordinates[offset + 1] = a.getPoint3d();
            return PermutationParity.IDENTITY;
        }
        return new BasicPermutationParity(indices);
    }

    private static boolean has2DCoordinates(List<IBond> bonds) {
        for (IBond bond : bonds) {
            if (bond.getBegin().getPoint2d() != null && bond.getEnd().getPoint2d() != null) continue;
            return false;
        }
        return true;
    }

    private static boolean has3DCoordinates(List<IBond> bonds) {
        for (IBond bond : bonds) {
            if (bond.getBegin().getPoint3d() != null && bond.getEnd().getPoint3d() != null) continue;
            return false;
        }
        return true;
    }

    static int elevation(IBond bond, IAtom a) {
        return bond.getBegin().equals(a) ? GeometricCumulativeDoubleBondFactory.elevation(bond) : GeometricCumulativeDoubleBondFactory.elevation(bond) * -1;
    }

    static int elevation(IBond bond) {
        IBond.Stereo stereo = bond.getStereo();
        if (stereo == null) {
            return 0;
        }
        switch (stereo) {
            case UP: 
            case DOWN_INVERTED: {
                return 1;
            }
            case DOWN: 
            case UP_INVERTED: {
                return -1;
            }
        }
        return 0;
    }

    private static boolean isOdd(int x) {
        return (x & 1) != 0;
    }

    private static boolean isDoubleBond(IBond bond) {
        return IBond.Order.DOUBLE.equals((Object)bond.getOrder());
    }

    private static class BondMap {
        private final Map<IAtom, List<IBond>> bonds;

        BondMap(int n) {
            this.bonds = new HashMap<IAtom, List<IBond>>(n > 3 ? n + n / 3 : n);
        }

        public List<IBond> bonds(IAtom a) {
            List<IBond> bs = this.bonds.get(a);
            return bs != null ? bs : Collections.emptyList();
        }

        public boolean cumulated(IAtom a) {
            return this.bonds(a).size() == 2;
        }

        public void add(IBond bond) {
            this.add(bond.getBegin(), bond);
            this.add(bond.getEnd(), bond);
        }

        private void add(IAtom a, IBond b) {
            if (this.bonds(a).isEmpty()) {
                this.bonds.put(a, new ArrayList(2));
            }
            this.bonds.get(a).add(b);
        }

        public Iterable<IAtom> atoms() {
            return this.bonds.keySet();
        }
    }
}

