/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.formats.CDKSourceCodeFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.io.setting.StringIOSetting;
import org.openscience.cdk.tools.IDCreator;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class CDKSourceCodeWriter
extends DefaultChemObjectWriter {
    private BufferedWriter writer;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(CDKSourceCodeWriter.class);
    private BooleanIOSetting write2DCoordinates;
    private BooleanIOSetting write3DCoordinates;
    private StringIOSetting builder;

    public CDKSourceCodeWriter(Writer out) {
        this.initIOSettings();
        try {
            this.setWriter(out);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CDKSourceCodeWriter(OutputStream out) {
        this(new OutputStreamWriter(out));
    }

    public CDKSourceCodeWriter() {
        this(new StringWriter());
    }

    @Override
    public IResourceFormat getFormat() {
        return CDKSourceCodeFormat.getInstance();
    }

    @Override
    public void setWriter(Writer out) throws CDKException {
        this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
    }

    @Override
    public void setWriter(OutputStream output) throws CDKException {
        this.setWriter(new OutputStreamWriter(output));
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    @Override
    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (!IAtomContainer.class.equals(anInterface)) continue;
            return true;
        }
        if (IAtomContainer.class.equals(classObject)) {
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public void write(IChemObject object) throws CDKException {
        this.customizeJob();
        if (object instanceof IAtomContainer) {
            try {
                this.writeAtomContainer((IAtomContainer)object);
                this.writer.flush();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
                logger.debug(ex);
                throw new CDKException("Exception while writing to CDK source code: " + ex.getMessage(), ex);
            }
        } else {
            throw new CDKException("Only supported is writing of IAtomContainer objects.");
        }
    }

    private void writeAtoms(IAtomContainer molecule) throws Exception {
        for (IAtom atom : molecule.atoms()) {
            this.writeAtom(atom);
            this.writer.write("  mol.addAtom(" + atom.getID() + ");");
            this.writer.write(10);
        }
    }

    private void writeBonds(IAtomContainer molecule) throws Exception {
        for (IBond bond : molecule.bonds()) {
            this.writeBond(bond);
            this.writer.write("  mol.addBond(" + bond.getID() + ");");
            this.writer.write(10);
        }
    }

    private void writeAtomContainer(IAtomContainer molecule) throws Exception {
        this.writer.write("{");
        this.writer.write(10);
        this.writer.write("  IChemObjectBuilder builder = ");
        this.writer.write(this.builder.getSetting());
        this.writer.write(".getInstance();");
        this.writer.write(10);
        this.writer.write("  IAtomContainer mol = builder.newInstance(IAtomContainer.class);");
        this.writer.write(10);
        IDCreator.createIDs(molecule);
        this.writeAtoms(molecule);
        this.writeBonds(molecule);
        this.writer.write("}");
        this.writer.write(10);
    }

    private void writeAtom(IAtom atom) throws Exception {
        if (atom instanceof IPseudoAtom) {
            this.writer.write("  IPseudoAtom " + atom.getID() + " = builder.newInstance(IPseudoAtom.class);");
            this.writer.write(10);
            this.writer.write("  atom.setLabel(\"" + ((IPseudoAtom)atom).getLabel() + "\");");
            this.writer.write(10);
        } else {
            this.writer.write("  IAtom " + atom.getID() + " = builder.newInstance(IAtom.class,\"" + atom.getSymbol() + "\");");
            this.writer.write(10);
        }
        if (atom.getFormalCharge() != null) {
            this.writer.write("  " + atom.getID() + ".setFormalCharge(" + atom.getFormalCharge() + ");");
            this.writer.write(10);
        }
        if (this.write2DCoordinates.isSet() && atom.getPoint2d() != null) {
            Point2d p2d = atom.getPoint2d();
            this.writer.write("  " + atom.getID() + ".setPoint2d(new Point2d(" + p2d.x + ", " + p2d.y + "));");
            this.writer.write(10);
        }
        if (this.write3DCoordinates.isSet() && atom.getPoint3d() != null) {
            Point3d p3d = atom.getPoint3d();
            this.writer.write("  " + atom.getID() + ".setPoint3d(new Point3d(" + p3d.x + ", " + p3d.y + ", " + p3d.z + "));");
            this.writer.write(10);
        }
    }

    private void writeBond(IBond bond) throws Exception {
        this.writer.write("  IBond " + bond.getID() + " = builder.newInstance(IBond.class," + bond.getBegin().getID() + ", " + bond.getEnd().getID() + ", IBond.Order." + (Object)((Object)bond.getOrder()) + ");");
        this.writer.write(10);
    }

    public int getSupportedDataFeatures() {
        return 523;
    }

    public int getRequiredDataFeatures() {
        return 520;
    }

    private void initIOSettings() {
        this.write2DCoordinates = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("write2DCoordinates", IOSetting.Importance.LOW, "Should 2D coordinates be added?", "true"));
        this.write3DCoordinates = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("write3DCoordinates", IOSetting.Importance.LOW, "Should 3D coordinates be added?", "true"));
        this.builder = (StringIOSetting)this.addSetting(new StringIOSetting("builder", IOSetting.Importance.LOW, "Which IChemObjectBuilder should be used?", "DefaultChemObjectBuilder"));
    }

    private void customizeJob() {
        this.fireIOSettingQuestion(this.write2DCoordinates);
        this.fireIOSettingQuestion(this.write3DCoordinates);
        this.fireIOSettingQuestion(this.builder);
    }
}

