/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Serializer;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.interfaces.IPDBPolymer;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionScheme;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.cml.CustomSerializer;
import org.openscience.cdk.io.formats.CMLFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.io.setting.StringIOSetting;
import org.openscience.cdk.libio.cml.Convertor;
import org.openscience.cdk.libio.cml.ICMLCustomizer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.xmlcml.cml.base.CMLElement;

public class CMLWriter
extends DefaultChemObjectWriter {
    private OutputStream output;
    private BooleanIOSetting cmlIds;
    private BooleanIOSetting namespacedOutput;
    private StringIOSetting namespacePrefix;
    private BooleanIOSetting schemaInstanceOutput;
    private StringIOSetting instanceLocation;
    private BooleanIOSetting indent;
    private BooleanIOSetting xmlDeclaration;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(CMLWriter.class);
    private List<ICMLCustomizer> customizers = null;

    public CMLWriter(final Writer writer) {
        logger.warn("possible loss of encoding when using a Writer with CMLWriter");
        this.output = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                writer.write(b);
            }

            @Override
            public void close() throws IOException {
                writer.close();
            }
        };
        this.initIOSettings();
    }

    public CMLWriter(OutputStream output) {
        this.output = output;
        this.initIOSettings();
    }

    public CMLWriter() {
        this(new ByteArrayOutputStream());
    }

    public void registerCustomizer(ICMLCustomizer customizer) {
        if (this.customizers == null) {
            this.customizers = new ArrayList<ICMLCustomizer>();
        }
        this.customizers.add(customizer);
        logger.info("Loaded Customizer: ", customizer.getClass().getName());
    }

    @Override
    public IResourceFormat getFormat() {
        return CMLFormat.getInstance();
    }

    @Override
    public void setWriter(final Writer writer) throws CDKException {
        logger.warn("possible loss of encoding when using a Writer with CMLWriter");
        this.output = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                writer.write(b);
            }
        };
    }

    @Override
    public void setWriter(OutputStream output) throws CDKException {
        this.output = output;
    }

    @Override
    public void close() throws IOException {
        if (this.output != null) {
            this.output.close();
        }
    }

    @Override
    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (IAtom.class.equals(anInterface)) {
                return true;
            }
            if (IBond.class.equals(anInterface)) {
                return true;
            }
            if (ICrystal.class.equals(anInterface)) {
                return true;
            }
            if (IChemModel.class.equals(anInterface)) {
                return true;
            }
            if (IChemFile.class.equals(anInterface)) {
                return true;
            }
            if (IChemSequence.class.equals(anInterface)) {
                return true;
            }
            if (IAtomContainerSet.class.equals(anInterface)) {
                return true;
            }
            if (IReactionSet.class.equals(anInterface)) {
                return true;
            }
            if (!IReaction.class.equals(anInterface)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void write(IChemObject object) throws CDKException {
        if (!(object instanceof IAtomContainer || object instanceof IAtomContainerSet || object instanceof IReaction || object instanceof IReactionSet || object instanceof IChemSequence || object instanceof IChemModel || object instanceof IChemFile || object instanceof ICrystal || object instanceof IAtom || object instanceof IBond)) {
            throw new CDKException("Cannot write this unsupported IChemObject: " + object.getClass().getName());
        }
        logger.debug("Writing object in CML of type: ", object.getClass().getName());
        this.customizeJob();
        Convertor convertor = new Convertor(this.cmlIds.isSet(), this.namespacePrefix.getSetting().length() > 0 ? this.namespacePrefix.getSetting() : null);
        if (this.customizers != null) {
            for (ICMLCustomizer customizer : this.customizers) {
                convertor.registerCustomizer(customizer);
            }
        }
        CMLElement root2 = object instanceof IPDBPolymer ? convertor.cdkPDBPolymerToCMLMolecule((IPDBPolymer)object) : (object instanceof ICrystal ? convertor.cdkCrystalToCMLMolecule((ICrystal)object) : (object instanceof IAtom ? convertor.cdkAtomToCMLAtom(null, (IAtom)object) : (object instanceof IBond ? convertor.cdkBondToCMLBond((IBond)object) : (object instanceof IReaction ? convertor.cdkReactionToCMLReaction((IReaction)object) : (object instanceof IReactionScheme ? convertor.cdkReactionSchemeToCMLReactionSchemeAndMoleculeList((IReactionScheme)object) : (object instanceof IReactionSet ? convertor.cdkReactionSetToCMLReactionList((IReactionSet)object) : (object instanceof IAtomContainerSet ? convertor.cdkAtomContainerSetToCMLList((IAtomContainerSet)object) : (object instanceof IChemSequence ? convertor.cdkChemSequenceToCMLList((IChemSequence)object) : (object instanceof IChemModel ? convertor.cdkChemModelToCMLList((IChemModel)object) : (object instanceof IAtomContainer ? convertor.cdkAtomContainerToCMLMolecule((IAtomContainer)object) : convertor.cdkChemFileToCMLList((IChemFile)object)))))))))));
        Document doc = new Document(root2);
        try {
            Serializer serializer = this.xmlDeclaration.isSet() ? new Serializer(this.output, "ISO-8859-1") : new CustomSerializer(this.output, "ISO-8859-1");
            if (this.indent.isSet()) {
                logger.info("Indenting XML output");
                serializer.setIndent(2);
            }
            if (this.schemaInstanceOutput.isSet()) {
                ((Element)root2).addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                root2.addAttribute(new Attribute("xsi:schemaLocation=", "http://www.w3.org/2001/XMLSchema-instance", "http://www.xml-cml.org/schema/cml2/core " + this.instanceLocation.getSetting()));
            }
            serializer.write(doc);
        }
        catch (Exception exception) {
            throw new CDKException("Could not write XML output: " + exception.getMessage(), exception);
        }
    }

    private void initIOSettings() {
        this.cmlIds = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("CMLIDs", IOSetting.Importance.LOW, "Should the output use CML identifiers?", "true"));
        this.namespacedOutput = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("NamespacedOutput", IOSetting.Importance.LOW, "Should the output use namespaced output?", "true"));
        this.namespacePrefix = (StringIOSetting)this.addSetting(new StringIOSetting("NamespacePrefix", IOSetting.Importance.LOW, "What should the namespace prefix be? [empty is no prefix]", ""));
        this.schemaInstanceOutput = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("SchemaInstance", IOSetting.Importance.LOW, "Should the output use the Schema-Instance attribute?", "false"));
        this.instanceLocation = (StringIOSetting)this.addSetting(new StringIOSetting("InstanceLocation", IOSetting.Importance.LOW, "Where is the schema found?", ""));
        this.indent = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("Indenting", IOSetting.Importance.LOW, "Should the output be indented?", "true"));
        this.xmlDeclaration = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("XMLDeclaration", IOSetting.Importance.LOW, "Should the output contain an XML declaration?", "true"));
    }

    private void customizeJob() {
        this.fireIOSettingQuestion(this.cmlIds);
        this.fireIOSettingQuestion(this.namespacedOutput);
        if (this.namespacedOutput.isSet()) {
            this.fireIOSettingQuestion(this.namespacePrefix);
        }
        this.fireIOSettingQuestion(this.schemaInstanceOutput);
        if (this.schemaInstanceOutput.isSet()) {
            this.fireIOSettingQuestion(this.instanceLocation);
        }
        this.fireIOSettingQuestion(this.indent);
        this.fireIOSettingQuestion(this.xmlDeclaration);
    }
}

