/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openscience.cdk.io.formats.IChemFormat;
import org.openscience.cdk.io.formats.IChemFormatMatcher;
import org.openscience.cdk.io.formats.XYZFormat;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class FormatFactory {
    private final int headerLength;
    private final List<IChemFormatMatcher> formats = new ArrayList<IChemFormatMatcher>(100);
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(FormatFactory.class);

    public FormatFactory() {
        this(65536);
    }

    public FormatFactory(int headerLength) {
        this.headerLength = headerLength;
        this.loadFormats();
    }

    private void loadFormats() {
        for (IChemFormatMatcher format : ServiceLoader.load(IChemFormatMatcher.class)) {
            this.formats.add(format);
        }
    }

    public void registerFormat(IChemFormatMatcher format) {
        this.formats.add(format);
    }

    public List<IChemFormatMatcher> getFormats() {
        return this.formats;
    }

    public IChemFormat guessFormat(Reader input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null");
        }
        char[] header = new char[this.headerLength];
        if (!input.markSupported()) {
            throw new IllegalArgumentException("input must support mark");
        }
        input.mark(this.headerLength);
        input.read(header, 0, this.headerLength);
        input.reset();
        BufferedReader buffer = new BufferedReader(new CharArrayReader(header));
        IChemFormat chemFormat = this.getMatchResult(buffer);
        if (chemFormat == null) {
            buffer = new BufferedReader(new CharArrayReader(header));
            chemFormat = this.getXYZFormat(buffer);
        }
        return chemFormat;
    }

    public IChemFormat guessFormat(InputStream input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null");
        }
        if (!input.markSupported()) {
            throw new IllegalArgumentException("input must support mark");
        }
        byte[] header = new byte[this.headerLength];
        input.mark(this.headerLength);
        input.read(header, 0, this.headerLength);
        input.reset();
        BufferedReader buffer = new BufferedReader(new StringReader(new String(header)));
        IChemFormat chemFormat = this.getMatchResult(buffer);
        if (chemFormat == null) {
            buffer = new BufferedReader(new StringReader(new String(header)));
            chemFormat = this.getXYZFormat(buffer);
        }
        return chemFormat;
    }

    private IChemFormat getMatchResult(BufferedReader buffer) throws IOException {
        IChemFormatMatcher.MatchResult best;
        List<String> lines = buffer.lines().collect(Collectors.toList());
        TreeSet<IChemFormatMatcher.MatchResult> results = new TreeSet<IChemFormatMatcher.MatchResult>();
        for (IChemFormatMatcher format : this.formats) {
            results.add(format.matches(lines));
        }
        if (results.size() > 1 && (best = (IChemFormatMatcher.MatchResult)results.iterator().next()).matched()) {
            return best.format();
        }
        return null;
    }

    private IChemFormat getXYZFormat(BufferedReader buffer) throws IOException {
        String line = buffer.readLine();
        StringTokenizer tokenizer = new StringTokenizer(line.trim());
        try {
            int tokenCount = tokenizer.countTokens();
            if (tokenCount == 1) {
                Integer.parseInt(tokenizer.nextToken());
                return (IChemFormat)XYZFormat.getInstance();
            }
            if (tokenCount == 2) {
                Integer.parseInt(tokenizer.nextToken());
                if ("Bohr".equalsIgnoreCase(tokenizer.nextToken())) {
                    return (IChemFormat)XYZFormat.getInstance();
                }
            }
        }
        catch (NumberFormatException exception) {
            LOGGER.error("cannot parse chemical file format" + exception.getMessage());
        }
        return null;
    }
}

