/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

final class INChIContentProcessorTool {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(INChIContentProcessorTool.class);

    public IAtomContainer processFormula(IAtomContainer parsedContent, String atomsEncoding) {
        logger.debug("Parsing atom data: ", atomsEncoding);
        Pattern pattern = Pattern.compile("([A-Z][a-z]?)(\\d+)?(.*)");
        String remainder = atomsEncoding;
        while (remainder.length() > 0) {
            logger.debug("Remaining: ", remainder);
            Matcher matcher = pattern.matcher(remainder);
            if (matcher.matches()) {
                String symbol = matcher.group(1);
                logger.debug("Atom symbol: ", symbol);
                if (!symbol.equals("H")) {
                    String occurenceStr = matcher.group(2);
                    int occurence = 1;
                    if (occurenceStr != null) {
                        occurence = Integer.parseInt(occurenceStr);
                    }
                    logger.debug("  occurence: ", occurence);
                    for (int i = 1; i <= occurence; ++i) {
                        parsedContent.addAtom(parsedContent.getBuilder().newInstance(IAtom.class, symbol));
                    }
                }
                remainder = matcher.group(3);
                if (remainder == null) {
                    remainder = "";
                }
                logger.debug("  Remaining: ", remainder);
            } else {
                logger.error("No match found!");
                remainder = "";
            }
            logger.debug("NO atoms: ", parsedContent.getAtomCount());
        }
        return parsedContent;
    }

    public void processConnections(String bondsEncoding, IAtomContainer container2, int source) {
        logger.debug("Parsing bond data: ", bondsEncoding);
        String remainder = bondsEncoding;
        while (remainder.length() > 0) {
            logger.debug("Bond part: ", remainder);
            if (remainder.charAt(0) == '(') {
                String branch = this.chopBranch(remainder);
                this.processConnections(branch, container2, source);
                if (branch.length() + 2 <= remainder.length()) {
                    remainder = remainder.substring(branch.length() + 2);
                    continue;
                }
                remainder = "";
                continue;
            }
            Pattern pattern = Pattern.compile("^(\\d+)-?(.*)");
            Matcher matcher = pattern.matcher(remainder);
            if (matcher.matches()) {
                String targetStr = matcher.group(1);
                int target = Integer.parseInt(targetStr);
                logger.debug("Source atom: ", source);
                logger.debug("Target atom: ", targetStr);
                IAtom targetAtom = container2.getAtom(target - 1);
                if (source != -1) {
                    IAtom sourceAtom = container2.getAtom(source - 1);
                    IBond bondToAdd = container2.getBuilder().newInstance(IBond.class, new Object[]{sourceAtom, targetAtom, IBond.Order.SINGLE});
                    container2.addBond(bondToAdd);
                }
                remainder = matcher.group(2);
                source = target;
                logger.debug("  remainder: ", remainder);
                continue;
            }
            logger.error("Could not get next bond info part");
            return;
        }
    }

    private String chopBranch(String remainder) {
        boolean doChop = false;
        int branchLevel = 0;
        StringBuilder choppedString = new StringBuilder();
        for (int i = 0; i < remainder.length(); ++i) {
            char currentChar = remainder.charAt(i);
            if (currentChar == '(') {
                if (doChop) {
                    choppedString.append(currentChar);
                }
                doChop = true;
                ++branchLevel;
                continue;
            }
            if (currentChar == ')') {
                if (--branchLevel == 0) {
                    doChop = false;
                    break;
                }
                if (!doChop) continue;
                choppedString.append(currentChar);
                continue;
            }
            if (!doChop) continue;
            choppedString.append(currentChar);
        }
        return choppedString.toString();
    }
}

