/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.SMILESFormat;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.io.setting.IntegerIOSetting;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class SMILESWriter
extends DefaultChemObjectWriter {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(SMILESWriter.class);
    private BufferedWriter writer;
    private BooleanIOSetting aromSetting;
    private BooleanIOSetting titleSetting;
    private IntegerIOSetting flavorSetting;
    private final int flav = 12551944;
    private SmilesGenerator smigen = new SmilesGenerator(12551944);
    private final StringBuilder buffer = new StringBuilder();

    public SMILESWriter(Writer out) {
        try {
            this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initIOSettings();
    }

    public SMILESWriter(OutputStream output) {
        this(new OutputStreamWriter(output));
    }

    public SMILESWriter() {
        this(new StringWriter());
    }

    public void setFlavor(int flav) {
        try {
            this.flavorSetting.setSetting(Integer.toString(flav));
        }
        catch (CDKException cDKException) {
            // empty catch block
        }
        this.customizeJob();
    }

    public void setWriteTitle(boolean val) {
        try {
            this.titleSetting.setSetting(Boolean.toString(val));
        }
        catch (CDKException cDKException) {
            // empty catch block
        }
        this.customizeJob();
    }

    @Override
    public IResourceFormat getFormat() {
        return SMILESFormat.getInstance();
    }

    @Override
    public void setWriter(Writer out) throws CDKException {
        this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
    }

    @Override
    public void setWriter(OutputStream output) throws CDKException {
        this.setWriter(new OutputStreamWriter(output));
    }

    public SMILESWriter(FileOutputStream out) {
        this(new OutputStreamWriter(out));
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    @Override
    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        if (IAtomContainer.class.equals(classObject)) {
            return true;
        }
        if (IAtomContainerSet.class.equals(classObject)) {
            return true;
        }
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (IAtomContainerSet.class.equals(anInterface)) {
                return true;
            }
            if (!IAtomContainer.class.equals(anInterface)) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public void write(IChemObject object) throws CDKException {
        if (object instanceof IAtomContainerSet) {
            this.writeAtomContainerSet((IAtomContainerSet)object);
        } else if (object instanceof IAtomContainer) {
            this.writeAtomContainer((IAtomContainer)object);
        } else {
            throw new CDKException("Only supported is writing of ChemFile and Molecule objects.");
        }
    }

    public void writeAtomContainerSet(IAtomContainerSet som) {
        this.writeAtomContainer(som.getAtomContainer(0));
        for (int i = 1; i <= som.getAtomContainerCount() - 1; ++i) {
            try {
                this.writeAtomContainer(som.getAtomContainer(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void writeAtomContainer(IAtomContainer molecule) {
        try {
            this.buffer.setLength(0);
            this.buffer.append(this.smigen.create(molecule));
            if (this.titleSetting.isSet() && molecule.getTitle() != null) {
                this.buffer.append('\t').append(molecule.getTitle());
            }
            this.buffer.append('\n');
            this.writer.write(this.buffer.toString());
            this.writer.flush();
        }
        catch (IOException | CDKException exc) {
            logger.error("Error while writing Molecule: ", exc.getMessage());
            logger.debug(exc);
        }
    }

    private void initIOSettings() {
        this.flavorSetting = (IntegerIOSetting)this.addSetting(new IntegerIOSetting("SmilesFlavor", IOSetting.Importance.HIGH, "Output SMILES flavor, binary option", Integer.toString(12551944)));
        this.titleSetting = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("WriteTitle", IOSetting.Importance.HIGH, "Write the molecule title after the SMILES", "true"));
        this.aromSetting = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("UseAromaticity", IOSetting.Importance.LOW, "Should aromaticity information be stored in the SMILES?", "false"));
    }

    public void customizeJob() {
        this.fireIOSettingQuestion(this.flavorSetting);
        this.fireIOSettingQuestion(this.titleSetting);
        this.fireIOSettingQuestion(this.aromSetting);
        int flav = this.flavorSetting.getSettingValue();
        if (this.aromSetting.isSet()) {
            flav |= 0x10;
        }
        this.smigen = new SmilesGenerator(flav);
    }
}

