/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.cml;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.interfaces.IPDBAtom;
import org.openscience.cdk.interfaces.IPDBMonomer;
import org.openscience.cdk.interfaces.IPDBPolymer;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStrand;
import org.openscience.cdk.io.cml.CMLCoreModule;
import org.openscience.cdk.io.cml.CMLStack;
import org.openscience.cdk.io.cml.ICMLModule;
import org.xml.sax.Attributes;

public class PDBConvention
extends CMLCoreModule {
    private boolean connectionTable;
    private boolean isELSYM;
    private boolean isBond;
    private String connect_root;
    private boolean hasScalar;
    private String idValue = "";
    private List<String> altLocV;
    private List<String> chainIDV;
    private List<String> hetAtomV;
    private List<String> iCodeV;
    private List<String> nameV;
    private List<String> oxtV;
    private List<String> recordV;
    private List<String> resNameV;
    private List<String> resSeqV;
    private List<String> segIDV;
    private List<String> serialV;
    private List<String> tempFactorV;

    public PDBConvention(IChemFile chemFile) {
        super(chemFile);
    }

    public PDBConvention(ICMLModule conv) {
        super(conv);
    }

    @Override
    public void endDocument() {
        this.storeData();
        super.endDocument();
    }

    @Override
    public void startElement(CMLStack xpath, String uri, String local, String raw, Attributes atts) {
        String name = raw;
        this.isELSYM = false;
        if ("molecule".equals(name)) {
            for (int j = 0; j < atts.getLength(); ++j) {
                int i;
                this.logger.debug("StartElement");
                this.currentChars = "";
                this.BUILTIN = "";
                this.DICTREF = "";
                for (i = 0; i < atts.getLength(); ++i) {
                    String qname = atts.getQName(i);
                    if (qname.equals("builtin")) {
                        this.BUILTIN = atts.getValue(i);
                        this.logger.debug(name, "->BUILTIN found: ", atts.getValue(i));
                        continue;
                    }
                    if (qname.equals("dictRef")) {
                        this.DICTREF = atts.getValue(i);
                        this.logger.debug(name, "->DICTREF found: ", atts.getValue(i));
                        continue;
                    }
                    if (qname.equals("title")) {
                        this.elementTitle = atts.getValue(i);
                        this.logger.debug(name, "->TITLE found: ", atts.getValue(i));
                        continue;
                    }
                    this.logger.debug("Qname: ", qname);
                }
                if (atts.getQName(j).equals("convention") && atts.getValue(j).equals("PDB")) {
                    this.currentStrand = this.currentChemFile.getBuilder().newInstance(IStrand.class, new Object[0]);
                    this.currentStrand.setStrandName("A");
                    this.currentMolecule = this.currentChemFile.getBuilder().newInstance(IPDBPolymer.class, new Object[0]);
                    continue;
                }
                if (atts.getQName(j).equals("dictRef") && atts.getValue(j).equals("pdb:sequence")) {
                    this.newSequence();
                    this.BUILTIN = "";
                    for (i = 0; i < atts.getLength(); ++i) {
                        if (atts.getQName(i).equals("id")) {
                            this.currentMolecule.setID(atts.getValue(i));
                            continue;
                        }
                        if (!atts.getQName(i).equals("dictRef")) continue;
                    }
                    continue;
                }
                if (atts.getQName(j).equals("title") && atts.getValue(j).equals("connections")) {
                    this.logger.debug("Assuming that Atom's have been read: storing them");
                    super.storeAtomData();
                    this.connectionTable = true;
                    this.logger.debug("Start Connection Table");
                    continue;
                }
                if (atts.getQName(j).equals("title") && atts.getValue(j).equals("connect")) {
                    this.logger.debug("New connection");
                    this.isBond = true;
                    continue;
                }
                if (!atts.getQName(j).equals("id") || !this.isBond) continue;
                this.connect_root = atts.getValue(j);
            }
        } else if ("scalar".equals(name)) {
            this.hasScalar = true;
            for (int i = 0; i < atts.getLength(); ++i) {
                if (!atts.getQName(i).equals("dictRef")) continue;
                this.idValue = atts.getValue(i);
            }
        } else if ("label".equals(name)) {
            this.hasScalar = true;
            for (int i = 0; i < atts.getLength(); ++i) {
                if (!atts.getQName(i).equals("dictRef")) continue;
                this.idValue = atts.getValue(i);
            }
        } else if ("atom".equals(name)) {
            super.startElement(xpath, uri, local, raw, atts);
        }
    }

    public void newSequence() {
        this.altLocV = new ArrayList<String>();
        this.chainIDV = new ArrayList<String>();
        this.hetAtomV = new ArrayList<String>();
        this.iCodeV = new ArrayList<String>();
        this.nameV = new ArrayList<String>();
        this.oxtV = new ArrayList<String>();
        this.recordV = new ArrayList<String>();
        this.resNameV = new ArrayList<String>();
        this.resSeqV = new ArrayList<String>();
        this.segIDV = new ArrayList<String>();
        this.serialV = new ArrayList<String>();
        this.tempFactorV = new ArrayList<String>();
    }

    @Override
    public void endElement(CMLStack xpath, String uri, String local, String raw) {
        String name = raw;
        if (name.equals("list") && this.connectionTable && !this.isBond) {
            this.logger.debug("End Connection Table");
            this.connectionTable = false;
        } else if (name.equals("molecule")) {
            this.storeData();
            if (xpath.size() == 1) {
                if (this.currentMolecule instanceof ICrystal) {
                    this.logger.debug("Adding crystal to chemModel");
                    this.currentChemModel.setCrystal((ICrystal)this.currentMolecule);
                    this.currentChemSequence.addChemModel(this.currentChemModel);
                } else {
                    this.logger.debug("Adding molecule to set");
                    this.currentMoleculeSet.addAtomContainer(this.currentMolecule);
                    this.logger.debug("#mols in set: " + this.currentMoleculeSet.getAtomContainerCount());
                }
            }
        }
        this.isELSYM = false;
        this.isBond = false;
    }

    @Override
    public void characterData(CMLStack xpath, char[] ch, int start, int length) {
        String s = new String(ch, start, length).trim();
        StringTokenizer st1 = new StringTokenizer(s);
        String dictpdb = "";
        while (st1.hasMoreElements()) {
            dictpdb = dictpdb + (String)st1.nextElement();
            if (st1.hasMoreElements()) {
                dictpdb = dictpdb + " ";
                continue;
            }
            if (!this.idValue.equals("pdb:record")) continue;
            dictpdb = dictpdb + " ";
        }
        if (this.idValue.equals("pdb:altLoc")) {
            this.altLocV.add(dictpdb);
        } else if (this.idValue.equals("pdb:chainID")) {
            this.chainIDV.add(dictpdb);
        } else if (this.idValue.equals("pdb:hetAtom")) {
            this.hetAtomV.add(dictpdb);
        } else if (this.idValue.equals("pdb:iCode")) {
            this.iCodeV.add(dictpdb);
        } else if (this.idValue.equals("pdb:name")) {
            this.nameV.add(dictpdb);
        } else if (this.idValue.equals("pdb:oxt")) {
            this.oxtV.add(dictpdb);
        } else if (this.idValue.equals("pdb:record")) {
            this.recordV.add(dictpdb);
        } else if (this.idValue.equals("pdb:resName")) {
            this.resNameV.add(dictpdb);
        } else if (this.idValue.equals("pdb:resSeq")) {
            this.resSeqV.add(dictpdb);
        } else if (this.idValue.equals("pdb:segID")) {
            this.segIDV.add(dictpdb);
        } else if (this.idValue.equals("pdb:serial")) {
            this.serialV.add(dictpdb);
        } else if (this.idValue.equals("pdb:tempFactor")) {
            this.tempFactorV.add(dictpdb);
        }
        this.idValue = "";
        if (this.isELSYM) {
            this.elsym.add(s);
        } else if (this.isBond) {
            this.logger.debug("CD (bond): " + s);
            if (this.connect_root.length() > 0) {
                StringTokenizer st = new StringTokenizer(s);
                while (st.hasMoreElements()) {
                    String atom = (String)st.nextElement();
                    if (atom.equals("0")) continue;
                    this.logger.debug("new bond: " + this.connect_root + "-" + atom);
                    this.currentBond = this.currentMolecule.getBuilder().newInstance(IBond.class, new Object[]{this.currentMolecule.getAtom(Integer.parseInt(this.connect_root) - 1), this.currentMolecule.getAtom(Integer.parseInt(atom) - 1), IBond.Order.SINGLE});
                    this.currentMolecule.addBond(this.currentBond);
                }
            }
        }
    }

    @Override
    protected void storeData() {
        if (this.inchi != null) {
            this.currentMolecule.setProperty("cdk:InChI", this.inchi);
        }
        this.storeAtomData();
        this.storeBondData();
    }

    @Override
    protected void storeAtomData() {
        this.logger.debug("No atoms: ", this.atomCounter);
        if (this.atomCounter == 0) {
            return;
        }
        boolean hasID = false;
        boolean has3D = false;
        boolean has3Dfract = false;
        boolean has2D = false;
        boolean hasFormalCharge = false;
        boolean hasPartialCharge = false;
        boolean hasHCounts = false;
        boolean hasSymbols = false;
        boolean hasTitles = false;
        boolean hasIsotopes = false;
        boolean hasDictRefs = false;
        boolean hasSpinMultiplicities = false;
        boolean hasOccupancies = false;
        if (this.elid.size() == this.atomCounter) {
            hasID = true;
        } else {
            this.logger.debug("No atom ids: " + this.elid.size(), " != " + this.atomCounter);
        }
        if (this.elsym.size() == this.atomCounter) {
            hasSymbols = true;
        } else {
            this.logger.debug("No atom symbols: " + this.elsym.size(), " != " + this.atomCounter);
        }
        if (this.eltitles.size() == this.atomCounter) {
            hasTitles = true;
        } else {
            this.logger.debug("No atom titles: " + this.eltitles.size(), " != " + this.atomCounter);
        }
        if (this.x3.size() == this.atomCounter && this.y3.size() == this.atomCounter && this.z3.size() == this.atomCounter) {
            has3D = true;
        } else {
            this.logger.debug("No 3D info: " + this.x3.size(), " " + this.y3.size(), " " + this.z3.size(), " != " + this.atomCounter);
        }
        if (this.xfract.size() == this.atomCounter && this.yfract.size() == this.atomCounter && this.zfract.size() == this.atomCounter) {
            has3Dfract = true;
        } else {
            this.logger.debug("No 3D fractional info: " + this.xfract.size(), " " + this.yfract.size(), " " + this.zfract.size(), " != " + this.atomCounter);
        }
        if (this.x2.size() == this.atomCounter && this.y2.size() == this.atomCounter) {
            has2D = true;
        } else {
            this.logger.debug("No 2D info: " + this.x2.size(), " " + this.y2.size(), " != " + this.atomCounter);
        }
        if (this.formalCharges.size() == this.atomCounter) {
            hasFormalCharge = true;
        } else {
            this.logger.debug("No formal Charge info: " + this.formalCharges.size(), " != " + this.atomCounter);
        }
        if (this.partialCharges.size() == this.atomCounter) {
            hasPartialCharge = true;
        } else {
            this.logger.debug("No partial Charge info: " + this.partialCharges.size(), " != " + this.atomCounter);
        }
        if (this.hCounts.size() == this.atomCounter) {
            hasHCounts = true;
        } else {
            this.logger.debug("No hydrogen Count info: " + this.hCounts.size(), " != " + this.atomCounter);
        }
        if (this.spinMultiplicities.size() == this.atomCounter) {
            hasSpinMultiplicities = true;
        } else {
            this.logger.debug("No spinMultiplicity info: " + this.spinMultiplicities.size(), " != " + this.atomCounter);
        }
        if (this.occupancies.size() == this.atomCounter) {
            hasOccupancies = true;
        } else {
            this.logger.debug("No occupancy info: " + this.occupancies.size(), " != " + this.atomCounter);
        }
        if (this.atomDictRefs.size() == this.atomCounter) {
            hasDictRefs = true;
        } else {
            this.logger.debug("No dictRef info: " + this.atomDictRefs.size(), " != " + this.atomCounter);
        }
        if (this.isotope.size() == this.atomCounter) {
            hasIsotopes = true;
        } else {
            this.logger.debug("No isotope info: " + this.isotope.size(), " != " + this.atomCounter);
        }
        if (this.atomCounter > 0) {
            this.currentMonomer = this.currentChemFile.getBuilder().newInstance(IPDBMonomer.class, new Object[0]);
        }
        for (int i = 0; i < this.atomCounter; ++i) {
            double occ;
            String symbol;
            this.logger.info("Storing atom: ", i);
            this.currentAtom = this.currentChemFile.getBuilder().newInstance(IPDBAtom.class, "H");
            if (hasID) {
                this.currentAtom.setID((String)this.elid.get(i));
            }
            if (hasTitles) {
                if (hasSymbols) {
                    symbol = (String)this.elsym.get(i);
                    if (symbol.equals("Du") || symbol.equals("Dummy")) {
                        if (!(this.currentAtom instanceof IPseudoAtom)) {
                            this.currentAtom = this.currentChemFile.getBuilder().newInstance(IPseudoAtom.class, this.currentAtom);
                        }
                        ((IPseudoAtom)this.currentAtom).setLabel((String)this.eltitles.get(i));
                    } else {
                        this.currentAtom.setProperty("cdk:Title", this.eltitles.get(i));
                    }
                } else {
                    this.currentAtom.setProperty("cdk:Title", this.eltitles.get(i));
                }
            }
            if (hasSymbols) {
                symbol = (String)this.elsym.get(i);
                if (symbol.equals("Du") || symbol.equals("Dummy")) {
                    symbol = "R";
                }
                if (symbol.equals("R") && !(this.currentAtom instanceof IPseudoAtom)) {
                    this.currentAtom = this.currentChemFile.getBuilder().newInstance(IPseudoAtom.class, this.currentAtom);
                }
                this.currentAtom.setSymbol(symbol);
                try {
                    Isotopes.getInstance().configure(this.currentAtom);
                }
                catch (Exception e2) {
                    this.logger.error("Could not configure atom: " + this.currentAtom);
                    this.logger.debug(e2);
                }
            }
            if (has3D) {
                this.currentAtom.setPoint3d(new Point3d(Double.parseDouble((String)this.x3.get(i)), Double.parseDouble((String)this.y3.get(i)), Double.parseDouble((String)this.z3.get(i))));
            }
            if (has3Dfract) {
                this.currentAtom.setFractionalPoint3d(new Point3d(Double.parseDouble((String)this.xfract.get(i)), Double.parseDouble((String)this.yfract.get(i)), Double.parseDouble((String)this.zfract.get(i))));
            }
            if (hasFormalCharge) {
                this.currentAtom.setFormalCharge(Integer.parseInt((String)this.formalCharges.get(i)));
            }
            if (hasPartialCharge) {
                this.logger.debug("Storing partial atomic charge...");
                this.currentAtom.setCharge(Double.parseDouble((String)this.partialCharges.get(i)));
            }
            if (hasHCounts) {
                this.currentAtom.setImplicitHydrogenCount(Integer.parseInt((String)this.hCounts.get(i)));
            }
            if (has2D && this.x2.get(i) != null && this.y2.get(i) != null) {
                this.currentAtom.setPoint2d(new Point2d(Double.parseDouble((String)this.x2.get(i)), Double.parseDouble((String)this.y2.get(i))));
            }
            if (hasDictRefs) {
                this.currentAtom.setProperty("org.openscience.cdk.dict", this.atomDictRefs.get(i));
            }
            if (hasSpinMultiplicities && this.spinMultiplicities.get(i) != null) {
                int unpairedElectrons = Integer.parseInt((String)this.spinMultiplicities.get(i)) - 1;
                for (int sm = 0; sm < unpairedElectrons; ++sm) {
                    this.currentMolecule.addSingleElectron(this.currentChemFile.getBuilder().newInstance(ISingleElectron.class, this.currentAtom));
                }
            }
            if (hasOccupancies && this.occupancies.get(i) != null && (occ = Double.parseDouble((String)this.occupancies.get(i))) >= 0.0) {
                ((IPDBAtom)this.currentAtom).setOccupancy(occ);
            }
            if (hasIsotopes) {
                this.currentAtom.setMassNumber(Integer.parseInt((String)this.isotope.get(i)));
            }
            if (this.hasScalar) {
                IPDBAtom pdbAtom = (IPDBAtom)this.currentAtom;
                if (this.altLocV.size() > 0) {
                    pdbAtom.setAltLoc(this.altLocV.get(i).toString());
                }
                if (this.chainIDV.size() > 0) {
                    pdbAtom.setChainID(this.chainIDV.get(i).toString());
                }
                if (this.hetAtomV.size() > 0) {
                    pdbAtom.setHetAtom(this.hetAtomV.get(i).toString().equals("true"));
                }
                if (this.iCodeV.size() > 0) {
                    pdbAtom.setICode(this.iCodeV.get(i).toString());
                }
                if (this.nameV.size() > 0) {
                    pdbAtom.setName(this.nameV.get(i).toString());
                }
                if (this.oxtV.size() > 0) {
                    pdbAtom.setOxt(this.oxtV.get(i).toString().equals("true"));
                }
                if (this.resSeqV.size() > 0) {
                    pdbAtom.setResSeq(this.resSeqV.get(i).toString());
                }
                if (this.recordV.size() > 0) {
                    pdbAtom.setRecord(this.recordV.get(i).toString());
                }
                if (this.resNameV.size() > 0) {
                    pdbAtom.setResName(this.resNameV.get(i).toString());
                }
                if (this.segIDV.size() > 0) {
                    pdbAtom.setSegID(this.segIDV.get(i).toString());
                }
                if (this.serialV.size() > 0) {
                    pdbAtom.setSerial(Integer.parseInt(this.serialV.get(i).toString()));
                }
                if (this.tempFactorV.size() > 0) {
                    pdbAtom.setTempFactor(Double.parseDouble(this.tempFactorV.get(i).toString()));
                }
            }
            String cResidue = ((IPDBAtom)this.currentAtom).getResName() + "A" + ((IPDBAtom)this.currentAtom).getResSeq();
            this.currentMonomer.setMonomerName(cResidue);
            this.currentMonomer.setMonomerType(((IPDBAtom)this.currentAtom).getResName());
            ((IPDBMonomer)this.currentMonomer).setChainID(((IPDBAtom)this.currentAtom).getChainID());
            ((IPDBMonomer)this.currentMonomer).setICode(((IPDBAtom)this.currentAtom).getICode());
            ((IPDBPolymer)this.currentMolecule).addAtom((IPDBAtom)this.currentAtom, this.currentMonomer, this.currentStrand);
        }
        if (this.elid.size() > 0) {
            this.bondElid = this.elid;
        }
        this.newAtomData();
    }
}

