/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.random;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.io.ISimpleChemObjectReader;
import org.openscience.cdk.io.MDLV2000Reader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLFormat;
import org.openscience.cdk.io.listener.IReaderListener;
import org.openscience.cdk.io.random.RandomAccessReader;

public class RandomAccessSDFReader
extends RandomAccessReader {
    public RandomAccessSDFReader(File file, IChemObjectBuilder builder) throws IOException {
        this(file, builder, null);
    }

    public RandomAccessSDFReader(File file, IChemObjectBuilder builder, IReaderListener listener) throws IOException {
        super(file, builder, listener);
    }

    @Override
    public ISimpleChemObjectReader createChemObjectReader() {
        return new MDLV2000Reader();
    }

    @Override
    protected boolean isRecordEnd(String line) {
        return line.equals("$$$$");
    }

    public IResourceFormat getFormat() {
        return MDLFormat.getInstance();
    }

    @Override
    protected IChemObject processContent() throws CDKException {
        return this.chemObjectReader.read(this.builder.newAtomContainer());
    }

    public void setReader(Reader reader) throws CDKException {
        throw new UnsupportedOperationException();
    }

    public void setReader(InputStream reader) throws CDKException {
        throw new UnsupportedOperationException();
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        return this.chemObjectReader.accepts(classObject);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove entries with the RandomAccessSDFReader");
    }
}

