/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.rdf;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.CDKOWLFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.libio.jena.Convertor;

public class CDKOWLReader
extends DefaultChemObjectReader {
    private Reader input;

    public CDKOWLReader(Reader input) {
        this.input = input;
    }

    public CDKOWLReader() {
        this.input = null;
    }

    @Override
    public IResourceFormat getFormat() {
        return CDKOWLFormat.getInstance();
    }

    @Override
    public void setReader(Reader reader) throws CDKException {
        this.input = reader;
    }

    @Override
    public void setReader(InputStream input) throws CDKException {
        this.input = new InputStreamReader(input);
    }

    @Override
    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        if (IAtomContainer.class.equals(classObject)) {
            return true;
        }
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (!IAtomContainer.class.equals(anInterface)) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public <T extends IChemObject> T read(T object) throws CDKException {
        if (!(object instanceof IAtomContainer)) {
            throw new CDKException("Only supported is reading of IAtomCOntainer objects.");
        }
        IAtomContainer result = (IAtomContainer)object;
        Model model = ModelFactory.createDefaultModel();
        model.read(this.input, "", "N3");
        IAtomContainer mol = Convertor.model2Molecule(model, object.getBuilder());
        result.add(mol);
        return (T)result;
    }

    @Override
    public void close() throws IOException {
        if (this.input != null) {
            this.input.close();
        }
    }
}

