/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;

public abstract class BondMatcher {
    public abstract boolean matches(IBond var1, IBond var2);

    public static BondMatcher forAny() {
        return new AnyMatcher();
    }

    public static BondMatcher forStrictOrder() {
        return new StrictOrderMatcher();
    }

    public static BondMatcher forOrder() {
        return new OrderMatcher();
    }

    public static BondMatcher forQuery() {
        return new QueryMatcher();
    }

    private static final class AnyMatcher
    extends BondMatcher {
        private AnyMatcher() {
        }

        @Override
        public boolean matches(IBond bond1, IBond bond2) {
            return true;
        }
    }

    private static final class StrictOrderMatcher
    extends BondMatcher {
        private StrictOrderMatcher() {
        }

        @Override
        public boolean matches(IBond bond1, IBond bond2) {
            return bond1.getFlag(32) == bond2.getFlag(32) && (bond1.getOrder() == bond2.getOrder() || bond1.getFlag(32) && bond2.getFlag(32));
        }
    }

    private static final class OrderMatcher
    extends BondMatcher {
        private OrderMatcher() {
        }

        @Override
        public boolean matches(IBond bond1, IBond bond2) {
            return bond1.getFlag(32) && bond2.getFlag(32) || bond1.getOrder() == bond2.getOrder();
        }
    }

    private static final class QueryMatcher
    extends BondMatcher {
        private QueryMatcher() {
        }

        @Override
        public boolean matches(IBond bond1, IBond bond2) {
            return ((IQueryBond)bond1).matches(bond2);
        }
    }
}

