/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.isomorphism.ExclusiveAtomMatches;
import org.openscience.cdk.isomorphism.StereoMatch;
import org.openscience.cdk.isomorphism.UniqueAtomMatches;
import org.openscience.cdk.isomorphism.UniqueBondMatches;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;

public final class Mappings
implements Iterable<int[]> {
    private final Iterable<int[]> iterable;
    private final IAtomContainer query;
    private final IAtomContainer target;

    Mappings(IAtomContainer query, IAtomContainer target, Iterable<int[]> iterable) {
        this.query = query;
        this.target = target;
        this.iterable = iterable;
    }

    public Mappings filter(Predicate<int[]> predicate) {
        return new Mappings(this.query, this.target, () -> this.stream().filter(predicate).iterator());
    }

    public <T> Iterable<T> map(Function<int[], T> f) {
        return () -> this.stream().map(f).iterator();
    }

    public Mappings limit(int limit) {
        return new Mappings(this.query, this.target, () -> this.stream().limit(limit).iterator());
    }

    @Deprecated
    public Mappings stereochemistry() {
        if (this.query instanceof IQueryAtomContainer) {
            return this;
        }
        return this.filter(new StereoMatch(this.query, this.target));
    }

    public Mappings uniqueAtoms() {
        return new Mappings(this.query, this.target, () -> this.stream().filter(new UniqueAtomMatches()).iterator());
    }

    public Mappings exclusiveAtoms() {
        return new Mappings(this.query, this.target, () -> this.stream().filter(new ExclusiveAtomMatches()).iterator());
    }

    public Mappings uniqueBonds() {
        int[][] g = GraphUtil.toAdjList(this.query);
        return new Mappings(this.query, this.target, () -> this.stream().filter(new UniqueBondMatches(g)).iterator());
    }

    public int[][] toArray() {
        Object res = new int[14][];
        int size = 0;
        for (int[] map : this) {
            if (size == ((int[][])res).length) {
                res = (int[][])Arrays.copyOf(res, size + (size >> 1));
            }
            res[size++] = (int[])map.clone();
        }
        return (int[][])Arrays.copyOf(res, size);
    }

    public Iterable<Map<IAtom, IAtom>> toAtomMap() {
        return this.map(new ToAtomMap(this.query, this.target));
    }

    public Iterable<Map<IBond, IBond>> toBondMap() {
        return this.map(new ToBondMap(this.query, this.target));
    }

    public Iterable<Map<IChemObject, IChemObject>> toAtomBondMap() {
        return this.map(new ToAtomBondMap(this.query, this.target));
    }

    public Stream<int[]> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Iterable<IChemObject> toChemObjects() {
        return this.stream().map(new ToAtomBondMap(this.query, this.target)).flatMap(map -> map.values().stream()).collect(Collectors.toList());
    }

    public Stream<IAtomContainer> toSubstructuresStream() {
        return this.stream().map(new ToAtomBondMap(this.query, this.target)).map((? super T map) -> {
            IAtomContainer submol = this.target.getBuilder().newInstance(IAtomContainer.class, this.query.getAtomCount(), this.target.getBondCount(), 0, 0);
            for (IAtom atom : this.query.atoms()) {
                submol.addAtom((IAtom)map.get(atom));
            }
            for (IBond bond : this.query.bonds()) {
                submol.addBond((IBond)map.get(bond));
            }
            return submol;
        });
    }

    public Iterable<IAtomContainer> toSubstructures() {
        return this.toSubstructuresStream().collect(Collectors.toList());
    }

    public boolean atLeast(int n) {
        return this.limit(n).count() == n;
    }

    public int[] first() {
        return this.stream().findFirst().orElseGet(() -> new int[0]);
    }

    public int count() {
        return (int)this.stream().count();
    }

    public int countUnique() {
        return this.uniqueAtoms().count();
    }

    @Override
    public Iterator<int[]> iterator() {
        return this.iterable.iterator();
    }

    private final class ToAtomMap
    implements Function<int[], Map<IAtom, IAtom>> {
        private final IAtomContainer query;
        private final IAtomContainer target;

        private ToAtomMap(IAtomContainer query, IAtomContainer target) {
            this.query = query;
            this.target = target;
        }

        @Override
        public Map<IAtom, IAtom> apply(int[] mapping) {
            HashMap<IAtom, IAtom> map = new HashMap<IAtom, IAtom>();
            for (int i = 0; i < mapping.length; ++i) {
                map.put(this.query.getAtom(i), this.target.getAtom(mapping[i]));
            }
            return Collections.unmodifiableMap(map);
        }
    }

    private final class ToBondMap
    implements Function<int[], Map<IBond, IBond>> {
        private final int[][] g1;
        private final GraphUtil.EdgeToBondMap bonds1;
        private final GraphUtil.EdgeToBondMap bonds2;

        private ToBondMap(IAtomContainer query, IAtomContainer target) {
            this.bonds1 = GraphUtil.EdgeToBondMap.withSpaceFor(query);
            this.bonds2 = GraphUtil.EdgeToBondMap.withSpaceFor(target);
            this.g1 = GraphUtil.toAdjList(query, this.bonds1);
            GraphUtil.toAdjList(target, this.bonds2);
        }

        @Override
        public Map<IBond, IBond> apply(int[] mapping) {
            LinkedHashMap<IBond, IBond> map = new LinkedHashMap<IBond, IBond>();
            for (int u = 0; u < this.g1.length; ++u) {
                for (int v : this.g1[u]) {
                    if (v <= u) continue;
                    map.put(this.bonds1.get(u, v), this.bonds2.get(mapping[u], mapping[v]));
                }
            }
            return Collections.unmodifiableMap(map);
        }
    }

    private final class ToAtomBondMap
    implements Function<int[], Map<IChemObject, IChemObject>> {
        private final int[][] g1;
        private final GraphUtil.EdgeToBondMap bonds1;
        private final GraphUtil.EdgeToBondMap bonds2;

        private ToAtomBondMap(IAtomContainer query, IAtomContainer target) {
            this.bonds1 = GraphUtil.EdgeToBondMap.withSpaceFor(query);
            this.bonds2 = GraphUtil.EdgeToBondMap.withSpaceFor(target);
            this.g1 = GraphUtil.toAdjList(query, this.bonds1);
            GraphUtil.toAdjList(target, this.bonds2);
        }

        @Override
        public Map<IChemObject, IChemObject> apply(int[] mapping) {
            LinkedHashMap<IChemObject, IChemObject> map = new LinkedHashMap<IChemObject, IChemObject>();
            for (int u = 0; u < this.g1.length; ++u) {
                map.put(Mappings.this.query.getAtom(u), Mappings.this.target.getAtom(mapping[u]));
                for (int v : this.g1[u]) {
                    if (v <= u) continue;
                    map.put(this.bonds1.get(u, v), this.bonds2.get(mapping[u], mapping[v]));
                }
            }
            return Collections.unmodifiableMap(map);
        }
    }
}

