/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.matchers;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.isomorphism.matchers.IRGroup;
import org.openscience.cdk.isomorphism.matchers.IRGroupList;

public class RGroupList
implements IRGroupList {
    public static final String DEFAULT_OCCURRENCE = ">0";
    private int rGroupNumber;
    private boolean restH;
    private String occurrence;
    private List<IRGroup> rGroups;
    private int requiredRGroupNumber;

    public RGroupList(int rGroupNumber) {
        this.setRGroupNumber(rGroupNumber);
        this.restH = false;
        this.occurrence = DEFAULT_OCCURRENCE;
        this.requiredRGroupNumber = 0;
    }

    public RGroupList(int rGroupNumber, boolean restH, String occurrence, int requiredRGroupNumber) throws CDKException {
        this.setRGroupNumber(rGroupNumber);
        this.setRestH(restH);
        this.setOccurrence(occurrence);
        this.setRequiredRGroupNumber(requiredRGroupNumber);
    }

    public void setRGroupNumber(int rGroupNumber) {
        if (rGroupNumber < 1 || rGroupNumber > 32) {
            throw new RuntimeException("Rgroup number must be between 1 and 32.");
        }
        this.rGroupNumber = rGroupNumber;
    }

    @Override
    public int getRGroupNumber() {
        return this.rGroupNumber;
    }

    public void setRestH(boolean restH) {
        this.restH = restH;
    }

    @Override
    public boolean isRestH() {
        return this.restH;
    }

    public void setRequiredRGroupNumber(int rGroupNumberImplicated) {
        this.requiredRGroupNumber = rGroupNumberImplicated;
    }

    @Override
    public int getRequiredRGroupNumber() {
        return this.requiredRGroupNumber;
    }

    public void setRGroups(List<IRGroup> rGroups) {
        this.rGroups = rGroups;
    }

    @Override
    public List<IRGroup> getRGroups() {
        return this.rGroups;
    }

    @Override
    public String getOccurrence() {
        return this.occurrence;
    }

    public void setOccurrence(String occurrence) throws CDKException {
        if (occurrence == null || occurrence.equals("")) {
            occurrence = DEFAULT_OCCURRENCE;
        } else if (RGroupList.isValidOccurrenceSyntax(occurrence = occurrence.trim().replaceAll(" ", ""))) {
            this.occurrence = occurrence;
        } else {
            throw new CDKException("Invalid occurence line: " + occurrence);
        }
    }

    public static boolean isValidOccurrenceSyntax(String occ) {
        StringTokenizer st = new StringTokenizer(occ, ",");
        while (st.hasMoreTokens()) {
            String cond = st.nextToken().trim().replaceAll(" ", "");
            if (RGroupList.match("^\\d+$", cond)) {
                if (Integer.parseInt(cond) >= 0) continue;
                return false;
            }
            if (RGroupList.match("^\\d+-\\d+$", cond)) {
                int from = Integer.parseInt(cond.substring(0, cond.indexOf(45)));
                int to = Integer.parseInt(cond.substring(cond.indexOf(45) + 1));
                if (from >= 0 && to >= 0 && to >= from) continue;
                return false;
            }
            if (RGroupList.match("^<\\d+$", cond)) {
                int n = Integer.parseInt(cond.substring(cond.indexOf(60) + 1));
                if (n != 0) continue;
                return false;
            }
            if (RGroupList.match("^>\\d+$", cond)) continue;
            return false;
        }
        return true;
    }

    private static boolean match(String regExp, String userInput) {
        Pattern pattern = Pattern.compile(regExp);
        Matcher matcher = pattern.matcher(userInput);
        return matcher.find();
    }

    @Override
    public List<Integer> matchOccurence(int maxAttachments) {
        ArrayList<Integer> validValues = new ArrayList<Integer>();
        for (int val = 0; val <= maxAttachments; ++val) {
            boolean addVal = false;
            StringTokenizer st = new StringTokenizer(this.occurrence, ",");
            while (st.hasMoreTokens() && !addVal) {
                int n;
                String cond = st.nextToken().trim().replaceAll(" ", "");
                if (RGroupList.match("^\\d+$", cond) && Integer.parseInt(cond) == val) {
                    addVal = true;
                }
                if (RGroupList.match("^\\d+-\\d+$", cond)) {
                    int from = Integer.parseInt(cond.substring(0, cond.indexOf(45)));
                    int to = Integer.parseInt(cond.substring(cond.indexOf(45) + 1, cond.length()));
                    if (val >= from && val <= to) {
                        addVal = true;
                    }
                }
                if (RGroupList.match("^>\\d+$", cond) && val > (n = Integer.parseInt(cond.substring(cond.indexOf(62) + 1, cond.length())))) {
                    addVal = true;
                }
                if (RGroupList.match("^<\\d+$", cond) && val < (n = Integer.parseInt(cond.substring(cond.indexOf(60) + 1, cond.length())))) {
                    addVal = true;
                }
                if (!addVal) continue;
                validValues.add(val);
            }
        }
        return validValues;
    }

    public boolean equals(Object obj) {
        return obj instanceof RGroupList && this.rGroupNumber == ((RGroupList)obj).rGroupNumber;
    }

    public int hashCode() {
        return this.rGroupNumber;
    }
}

