/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.pharmacophore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import org.openscience.cdk.Bond;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.pharmacophore.PharmacophoreQuery;
import org.openscience.cdk.pharmacophore.PharmacophoreQueryAngleBond;
import org.openscience.cdk.pharmacophore.PharmacophoreQueryAtom;
import org.openscience.cdk.pharmacophore.PharmacophoreQueryBond;

public class PharmacophoreUtils {
    public static List<PharmacophoreQuery> readPharmacophoreDefinitions(String filename) throws CDKException, IOException {
        Document doc;
        Builder parser = new Builder();
        try {
            doc = parser.build(filename);
        }
        catch (ParsingException e2) {
            throw new CDKException("Invalid pharmacophore definition file");
        }
        return PharmacophoreUtils.getdefs(doc);
    }

    public static List<PharmacophoreQuery> readPharmacophoreDefinitions(InputStream ins) throws IOException, CDKException {
        Document doc;
        Builder parser = new Builder();
        try {
            doc = parser.build(ins);
        }
        catch (ParsingException e2) {
            throw new CDKException("Invalid pharmacophore definition file");
        }
        return PharmacophoreUtils.getdefs(doc);
    }

    public static void writePharmacophoreDefinition(PharmacophoreQuery query, OutputStream out) throws IOException {
        PharmacophoreUtils.writePharmacophoreDefinition(new PharmacophoreQuery[]{query}, out);
    }

    public static void writePharmacophoreDefinition(List<PharmacophoreQuery> queries, OutputStream out) throws IOException {
        PharmacophoreUtils.writePharmacophoreDefinition(queries.toArray(new PharmacophoreQuery[0]), out);
    }

    public static void writePharmacophoreDefinition(PharmacophoreQuery[] queries, OutputStream out) throws IOException {
        Element root2 = new Element("pharmacophoreContainer");
        root2.addAttribute(new Attribute("version", "1.0"));
        for (PharmacophoreQuery query : queries) {
            String name;
            Element pcore = new Element("pharmacophore");
            Object description = query.getProperty("description");
            if (description != null) {
                pcore.addAttribute(new Attribute("description", (String)description));
            }
            if ((name = query.getTitle()) != null) {
                pcore.addAttribute(new Attribute("name", name));
            }
            for (IAtom atom : query.atoms()) {
                Element group = new Element("group");
                group.addAttribute(new Attribute("id", atom.getSymbol()));
                group.appendChild(((PharmacophoreQueryAtom)atom).getSmarts());
                pcore.appendChild(group);
            }
            for (IBond bond : query.bonds()) {
                Bond dbond;
                Element elem = null;
                if (bond instanceof PharmacophoreQueryBond) {
                    dbond = (PharmacophoreQueryBond)bond;
                    elem = new Element("distanceConstraint");
                    elem.addAttribute(new Attribute("lower", String.valueOf(((PharmacophoreQueryBond)dbond).getLower())));
                    elem.addAttribute(new Attribute("upper", String.valueOf(((PharmacophoreQueryBond)dbond).getUpper())));
                    elem.addAttribute(new Attribute("units", "A"));
                } else if (bond instanceof PharmacophoreQueryAngleBond) {
                    dbond = (PharmacophoreQueryAngleBond)bond;
                    elem = new Element("angleConstraint");
                    elem.addAttribute(new Attribute("lower", String.valueOf(((PharmacophoreQueryAngleBond)dbond).getLower())));
                    elem.addAttribute(new Attribute("upper", String.valueOf(((PharmacophoreQueryAngleBond)dbond).getUpper())));
                    elem.addAttribute(new Attribute("units", "degrees"));
                }
                for (IAtom iAtom : bond.atoms()) {
                    PharmacophoreQueryAtom atom = (PharmacophoreQueryAtom)iAtom;
                    Element gelem = new Element("groupRef");
                    gelem.addAttribute(new Attribute("id", atom.getSymbol()));
                    if (elem == null) continue;
                    elem.appendChild(gelem);
                }
                pcore.appendChild(elem);
            }
            root2.appendChild(pcore);
        }
        Document doc = new Document(root2);
        Serializer serializer = new Serializer(out, "ISO-8859-1");
        serializer.setIndent(4);
        serializer.setMaxLength(128);
        serializer.write(doc);
    }

    private static List<PharmacophoreQuery> getdefs(Document doc) throws CDKException {
        Element root2 = doc.getRootElement();
        ArrayList<PharmacophoreQuery> ret = new ArrayList<PharmacophoreQuery>();
        HashMap<String, String> groups = PharmacophoreUtils.getGroupDefinitions(root2);
        Elements children = root2.getChildElements();
        for (int i = 0; i < children.size(); ++i) {
            Element e2 = children.get(i);
            if (!e2.getQualifiedName().equals("pharmacophore")) continue;
            ret.add(PharmacophoreUtils.processPharmacophoreElement(e2, groups));
        }
        return ret;
    }

    private static HashMap<String, String> getGroupDefinitions(Element e2) {
        HashMap<String, String> groups = new HashMap<String, String>();
        Elements children = e2.getChildElements();
        for (int i = 0; i < children.size(); ++i) {
            Element child = children.get(i);
            if (!child.getQualifiedName().equals("group")) continue;
            String id = child.getAttributeValue("id").trim();
            String smarts = child.getValue().trim();
            groups.put(id, smarts);
        }
        return groups;
    }

    private static PharmacophoreQuery processPharmacophoreElement(Element e2, HashMap<String, String> global) throws CDKException {
        PharmacophoreQuery ret = new PharmacophoreQuery();
        ret.setProperty("description", e2.getAttributeValue("description"));
        ret.setTitle(e2.getAttributeValue("name"));
        HashMap<String, String> local = PharmacophoreUtils.getGroupDefinitions(e2);
        Elements children = e2.getChildElements();
        for (int i = 0; i < children.size(); ++i) {
            Element child = children.get(i);
            if (child.getQualifiedName().equals("distanceConstraint")) {
                PharmacophoreUtils.processDistanceConstraint(child, local, global, ret);
                continue;
            }
            if (!child.getQualifiedName().equals("angleConstraint")) continue;
            PharmacophoreUtils.processAngleConstraint(child, local, global, ret);
        }
        return ret;
    }

    private static void processDistanceConstraint(Element child, HashMap<String, String> local, HashMap<String, String> global, PharmacophoreQuery ret) throws CDKException {
        PharmacophoreQueryAtom pqa;
        String smarts2;
        String smarts1;
        String tmp = child.getAttributeValue("lower");
        if (tmp == null) {
            throw new CDKException("Must have a 'lower' attribute");
        }
        double lower = Double.parseDouble(tmp);
        tmp = child.getAttributeValue("upper");
        double upper = tmp != null ? Double.parseDouble(tmp) : lower;
        Elements grouprefs = child.getChildElements();
        if (grouprefs.size() != 2) {
            throw new CDKException("A distance constraint can only refer to 2 groups.");
        }
        String id1 = grouprefs.get(0).getAttributeValue("id");
        String id2 = grouprefs.get(1).getAttributeValue("id");
        if (local.containsKey(id1)) {
            smarts1 = local.get(id1);
        } else if (global.containsKey(id1)) {
            smarts1 = global.get(id1);
        } else {
            throw new CDKException("Referring to a non-existant group definition");
        }
        if (local.containsKey(id2)) {
            smarts2 = local.get(id2);
        } else if (global.containsKey(id2)) {
            smarts2 = global.get(id2);
        } else {
            throw new CDKException("Referring to a non-existant group definition");
        }
        if (!PharmacophoreUtils.containsPatom(ret, id1)) {
            pqa = new PharmacophoreQueryAtom(id1, smarts1);
            ret.addAtom(pqa);
        }
        if (!PharmacophoreUtils.containsPatom(ret, id2)) {
            pqa = new PharmacophoreQueryAtom(id2, smarts2);
            ret.addAtom(pqa);
        }
        IAtom a1 = null;
        IAtom a2 = null;
        for (IAtom queryAtom : ret.atoms()) {
            if (queryAtom.getSymbol().equals(id1)) {
                a1 = queryAtom;
            }
            if (!queryAtom.getSymbol().equals(id2)) continue;
            a2 = queryAtom;
        }
        ret.addBond(new PharmacophoreQueryBond((PharmacophoreQueryAtom)a1, (PharmacophoreQueryAtom)a2, lower, upper));
    }

    private static void processAngleConstraint(Element child, HashMap<String, String> local, HashMap<String, String> global, PharmacophoreQuery ret) throws CDKException {
        PharmacophoreQueryAtom pqa;
        String smarts3;
        String smarts2;
        String smarts1;
        String tmp = child.getAttributeValue("lower");
        if (tmp == null) {
            throw new CDKException("Must have a 'lower' attribute");
        }
        double lower = Double.parseDouble(tmp);
        tmp = child.getAttributeValue("upper");
        double upper = tmp != null ? Double.parseDouble(tmp) : lower;
        Elements grouprefs = child.getChildElements();
        if (grouprefs.size() != 3) {
            throw new CDKException("An angle constraint can only refer to 3 groups.");
        }
        String id1 = grouprefs.get(0).getAttributeValue("id");
        String id2 = grouprefs.get(1).getAttributeValue("id");
        String id3 = grouprefs.get(2).getAttributeValue("id");
        if (local.containsKey(id1)) {
            smarts1 = local.get(id1);
        } else if (global.containsKey(id1)) {
            smarts1 = global.get(id1);
        } else {
            throw new CDKException("Referring to a non-existant group definition");
        }
        if (local.containsKey(id2)) {
            smarts2 = local.get(id2);
        } else if (global.containsKey(id2)) {
            smarts2 = global.get(id2);
        } else {
            throw new CDKException("Referring to a non-existant group definition");
        }
        if (local.containsKey(id3)) {
            smarts3 = local.get(id3);
        } else if (global.containsKey(id3)) {
            smarts3 = global.get(id3);
        } else {
            throw new CDKException("Referring to a non-existant group definition");
        }
        if (!PharmacophoreUtils.containsPatom(ret, id1)) {
            pqa = new PharmacophoreQueryAtom(id1, smarts1);
            ret.addAtom(pqa);
        }
        if (!PharmacophoreUtils.containsPatom(ret, id2)) {
            pqa = new PharmacophoreQueryAtom(id2, smarts2);
            ret.addAtom(pqa);
        }
        if (!PharmacophoreUtils.containsPatom(ret, id3)) {
            pqa = new PharmacophoreQueryAtom(id3, smarts3);
            ret.addAtom(pqa);
        }
        IAtom a1 = null;
        IAtom a2 = null;
        IAtom a3 = null;
        for (IAtom queryAtom : ret.atoms()) {
            if (queryAtom.getSymbol().equals(id1)) {
                a1 = queryAtom;
            }
            if (queryAtom.getSymbol().equals(id2)) {
                a2 = queryAtom;
            }
            if (!queryAtom.getSymbol().equals(id3)) continue;
            a3 = queryAtom;
        }
        ret.addBond(new PharmacophoreQueryAngleBond((PharmacophoreQueryAtom)a1, (PharmacophoreQueryAtom)a2, (PharmacophoreQueryAtom)a3, lower, upper));
    }

    private static boolean containsPatom(PharmacophoreQuery q, String id) {
        for (IAtom queryAtom : q.atoms()) {
            if (!queryAtom.getSymbol().equals(id)) continue;
            return true;
        }
        return false;
    }
}

