/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import javax.vecmath.Point3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;

public class DistanceToAtomDescriptor
extends AbstractAtomicDescriptor
implements IAtomicDescriptor {
    private int focusPosition = 0;

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#distanceToAtom", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("DistanceToAtomDescriptor only expects two parameters");
        }
        if (!(params[0] instanceof Integer)) {
            throw new CDKException("The parameter must be of type Integer");
        }
        this.focusPosition = (Integer)params[0];
    }

    @Override
    public Object[] getParameters() {
        Object[] params = new Object[]{this.focusPosition};
        return params;
    }

    @Override
    public String[] getDescriptorNames() {
        return new String[]{"distanceToAtom"};
    }

    @Override
    public DescriptorValue calculate(IAtom atom, IAtomContainer container2) {
        IAtom focus = container2.getAtom(this.focusPosition);
        if (atom.getPoint3d() == null || focus.getPoint3d() == null) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), this.getDescriptorNames(), new CDKException("Target or focus atom must have 3D coordinates."));
        }
        double distanceToAtom = this.calculateDistanceBetweenTwoAtoms(atom, focus);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(distanceToAtom), this.getDescriptorNames());
    }

    private double calculateDistanceBetweenTwoAtoms(IAtom atom1, IAtom atom2) {
        Point3d firstPoint = atom1.getPoint3d();
        Point3d secondPoint = atom2.getPoint3d();
        double distance = firstPoint.distance(secondPoint);
        return distance;
    }

    @Override
    public String[] getParameterNames() {
        String[] params = new String[]{"The position of the focus atom"};
        return params;
    }

    @Override
    public Object getParameterType(String name) {
        return 0;
    }
}

