/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.forcefield.mmff.Mmff;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class PartialTChargeMMFF94Descriptor
extends AbstractAtomicDescriptor {
    private static final String[] NAMES = new String[]{"partialTCMMFF94"};
    private static final String CHARGE_CACHE = "mmff.qsar.charge.cache";
    private final Mmff mmff;
    private final ILoggingTool logger = LoggingToolFactory.createLoggingTool(this.getClass());

    public PartialTChargeMMFF94Descriptor() {
        this.mmff = new Mmff();
    }

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#partialTChargeMMFF94", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return NAMES;
    }

    @Override
    public DescriptorValue calculate(IAtom atom, IAtomContainer org) {
        if (atom.getProperty(CHARGE_CACHE) == null) {
            IAtomContainer copy;
            try {
                copy = org.clone();
            }
            catch (CloneNotSupportedException e2) {
                return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), NAMES);
            }
            for (IAtom a : org.atoms()) {
                if (a.getImplicitHydrogenCount() != null && a.getImplicitHydrogenCount() == 0) continue;
                this.logger.error("Hydrogens must be explict for MMFF charge calculation");
                return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), NAMES);
            }
            if (!this.mmff.assignAtomTypes(copy)) {
                this.logger.warn("One or more atoms could not be assigned an MMFF atom type");
            }
            this.mmff.partialCharges(copy);
            this.mmff.clearProps(copy);
            for (int i = 0; i < org.getAtomCount(); ++i) {
                org.getAtom(i).setProperty(CHARGE_CACHE, copy.getAtom(i).getCharge());
            }
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(atom.getProperty(CHARGE_CACHE, Double.class)), NAMES);
    }

    @Override
    public String[] getParameterNames() {
        return new String[0];
    }

    @Override
    public Object getParameterType(String name) {
        return null;
    }
}

