/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.io.IOException;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;

public class WeightDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private String elementName = "*";

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#weight", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("weight only expects one parameter");
        }
        if (!(params[0] instanceof String)) {
            throw new CDKException("The parameter must be of type String");
        }
        this.elementName = (String)params[0];
    }

    @Override
    public Object[] getParameters() {
        Object[] params = new Object[]{this.elementName};
        return params;
    }

    @Override
    public String[] getDescriptorNames() {
        String name = "w";
        name = this.elementName.equals("*") ? "MW" : name + this.elementName;
        return new String[]{name};
    }

    private DescriptorValue getDummyDescriptorValue(Exception e2) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), this.getDescriptorNames(), e2);
    }

    @Override
    public DescriptorValue calculate(IAtomContainer container2) {
        double hydrogenNaturalMass;
        double weight = 0.0;
        try {
            IIsotope hydrogen = Isotopes.getInstance().getMajorIsotope("H");
            hydrogenNaturalMass = Isotopes.getInstance().getNaturalMass(hydrogen);
        }
        catch (IOException e2) {
            return this.getDummyDescriptorValue(e2);
        }
        if (this.elementName.equals("*")) {
            try {
                for (IAtom atom : container2.atoms()) {
                    weight += Isotopes.getInstance().getNaturalMass(atom);
                    Integer implicitHydrogenCount = atom.getImplicitHydrogenCount();
                    if (implicitHydrogenCount == CDKConstants.UNSET) {
                        implicitHydrogenCount = 0;
                    }
                    weight += (double)implicitHydrogenCount.intValue() * hydrogenNaturalMass;
                }
            }
            catch (Exception e3) {
                return this.getDummyDescriptorValue(e3);
            }
        }
        if (this.elementName.equals("H")) {
            try {
                for (IAtom atom : container2.atoms()) {
                    if (atom.getSymbol().equals(this.elementName)) {
                        weight += hydrogenNaturalMass;
                        continue;
                    }
                    weight += (double)atom.getImplicitHydrogenCount().intValue() * hydrogenNaturalMass;
                }
            }
            catch (Exception e4) {
                return this.getDummyDescriptorValue(e4);
            }
        }
        try {
            for (IAtom atom : container2.atoms()) {
                if (!atom.getSymbol().equals(this.elementName)) continue;
                weight += Isotopes.getInstance().getNaturalMass(atom);
            }
        }
        catch (Exception e5) {
            return this.getDummyDescriptorValue(e5);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(weight), this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleResult(0.0);
    }

    @Override
    public String[] getParameterNames() {
        String[] params = new String[]{"elementSymbol"};
        return params;
    }

    @Override
    public Object getParameterType(String name) {
        return "";
    }
}

