/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class WeightedPathDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private static final String[] NAMES = new String[]{"WTPT-1", "WTPT-2", "WTPT-3", "WTPT-4", "WTPT-5"};

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#weightedPath", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return NAMES;
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String name) {
        return null;
    }

    public static boolean unique(List<IAtom> path) {
        return path.get(0).getIndex() < path.get(path.size() - 1).getIndex();
    }

    private void traverseAllPaths(boolean[] visit, Consumer consumer, List<IAtom> apath, double weight, IAtom atom, IBond prev) {
        visit[atom.getIndex()] = true;
        apath.add(atom);
        if (prev != null) {
            consumer.consume(apath, weight /= consumer.bondWeights[prev.getIndex()]);
        }
        for (IBond bond : atom.bonds()) {
            IAtom nbor;
            if (bond == prev || visit[(nbor = bond.getOther(atom)).getIndex()]) continue;
            this.traverseAllPaths(visit, consumer, apath, weight, nbor, bond);
        }
        visit[atom.getIndex()] = false;
        apath.remove(apath.size() - 1);
    }

    @Override
    public DescriptorValue calculate(IAtomContainer container2) {
        IAtomContainer local = AtomContainerManipulator.removeHydrogens(container2);
        DoubleArrayResult retval = new DoubleArrayResult();
        Consumer consumer = new Consumer(local);
        boolean[] visit = new boolean[local.getAtomCount()];
        for (IAtom a : local.atoms()) {
            this.traverseAllPaths(visit, consumer, new ArrayList<IAtom>(), 1.0, a, null);
        }
        retval.add(consumer.uniqWeight);
        retval.add(consumer.uniqWeight / (double)local.getAtomCount());
        retval.add(consumer.heteroWeight);
        retval.add(consumer.oxygenWeight);
        retval.add(consumer.nitrogenWeight);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), retval, this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(5);
    }

    private static final class Consumer {
        private double uniqWeight;
        private double heteroWeight;
        private double oxygenWeight;
        private double nitrogenWeight;
        private final double[] bondWeights;

        public Consumer(IAtomContainer mol) {
            this.uniqWeight = mol.getAtomCount();
            this.heteroWeight = 0.0;
            this.oxygenWeight = 0.0;
            this.nitrogenWeight = 0.0;
            block5: for (IAtom a : mol.atoms()) {
                switch ((byte)a.getAtomicNumber().intValue()) {
                    case 6: {
                        continue block5;
                    }
                    case 7: {
                        this.nitrogenWeight += 1.0;
                        this.heteroWeight += 1.0;
                        continue block5;
                    }
                    case 8: {
                        this.oxygenWeight += 1.0;
                        this.heteroWeight += 1.0;
                        continue block5;
                    }
                }
                this.heteroWeight += 1.0;
            }
            this.bondWeights = new double[mol.getBondCount()];
            for (IBond bond : mol.bonds()) {
                int begDeg = bond.getBegin().getBondCount();
                int endDeg = bond.getEnd().getBondCount();
                this.bondWeights[bond.getIndex()] = Math.sqrt((double)begDeg * (double)endDeg);
            }
        }

        void consume(List<IAtom> apath, double val) {
            int elem;
            if (WeightedPathDescriptor.unique(apath)) {
                this.uniqWeight += val;
            }
            if ((elem = apath.get(0).getAtomicNumber().intValue()) != 6) {
                this.heteroWeight += val;
                if (elem == 8) {
                    this.oxygenWeight += val;
                } else if (elem == 7) {
                    this.nitrogenWeight += val;
                }
            }
        }
    }
}

