/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.renderer.AbstractRenderer;
import org.openscience.cdk.renderer.AverageBondLengthCalculator;
import org.openscience.cdk.renderer.BoundsCalculator;
import org.openscience.cdk.renderer.IRenderer;
import org.openscience.cdk.renderer.MoleculeSetRenderer;
import org.openscience.cdk.renderer.ReactionSetRenderer;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.font.IFontManager;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.visitor.IDrawVisitor;

public class ChemModelRenderer
extends AbstractRenderer<IChemModel>
implements IRenderer<IChemModel> {
    private IRenderer<IAtomContainerSet> moleculeSetRenderer;
    private final IRenderer<IReactionSet> reactionSetRenderer;

    public ChemModelRenderer(List<IGenerator<IAtomContainer>> generators, IFontManager fontManager) {
        super(new RendererModel());
        this.fontManager = fontManager;
        for (IGenerator<IAtomContainer> generator : generators) {
            this.rendererModel.registerParameters(generator);
        }
        this.moleculeSetRenderer = new MoleculeSetRenderer(this.rendererModel, generators, fontManager);
        this.reactionSetRenderer = new ReactionSetRenderer(this.rendererModel, generators, fontManager);
        this.setup();
    }

    public ChemModelRenderer(List<IGenerator<IAtomContainer>> generators, List<IGenerator<IReaction>> reactionGenerators, IFontManager fontManager) {
        super(new RendererModel());
        this.fontManager = fontManager;
        for (IGenerator<IAtomContainer> iGenerator : generators) {
            this.rendererModel.registerParameters(iGenerator);
        }
        for (IGenerator<IChemObject> iGenerator : reactionGenerators) {
            this.rendererModel.registerParameters(iGenerator);
        }
        this.reactionSetRenderer = new ReactionSetRenderer(this.rendererModel, generators, reactionGenerators, fontManager);
        this.setup();
    }

    @Override
    public void setup(IChemModel chemModel, Rectangle screen) {
        this.setScale(chemModel);
        Rectangle2D bounds = BoundsCalculator.calculateBounds(chemModel);
        if (bounds != null) {
            this.modelCenter = new Point2d(bounds.getCenterX(), bounds.getCenterY());
        }
        this.drawCenter = new Point2d(screen.getCenterX(), screen.getCenterY());
        this.setup();
    }

    @Override
    public void setScale(IChemModel chemModel) {
        double bondLength = AverageBondLengthCalculator.calculateAverageBondLength(chemModel);
        double scale = this.calculateScaleForBondLength(bondLength);
        this.rendererModel.getParameter(BasicSceneGenerator.Scale.class).setValue(scale);
    }

    @Override
    public Rectangle paint(IChemModel chemModel, IDrawVisitor drawVisitor) {
        IAtomContainerSet moleculeSet = chemModel.getMoleculeSet();
        IReactionSet reactionSet = chemModel.getReactionSet();
        if (moleculeSet == null && reactionSet != null) {
            Rectangle2D totalBounds = BoundsCalculator.calculateBounds(reactionSet);
            this.setupTransformNatural(totalBounds);
            IRenderingElement diagram = this.reactionSetRenderer.generateDiagram(reactionSet);
            this.paint(drawVisitor, diagram);
            return this.convertToDiagramBounds(totalBounds);
        }
        if (moleculeSet != null && reactionSet == null) {
            Rectangle2D totalBounds = BoundsCalculator.calculateBounds(moleculeSet);
            this.setupTransformNatural(totalBounds);
            IRenderingElement diagram = this.moleculeSetRenderer.generateDiagram(moleculeSet);
            this.paint(drawVisitor, diagram);
            return this.convertToDiagramBounds(totalBounds);
        }
        if (moleculeSet != null && reactionSet != null) {
            Rectangle2D totalBounds = BoundsCalculator.calculateBounds(chemModel);
            this.setupTransformNatural(totalBounds);
            ElementGroup diagram = new ElementGroup();
            diagram.add(this.reactionSetRenderer.generateDiagram(reactionSet));
            diagram.add(this.moleculeSetRenderer.generateDiagram(moleculeSet));
            this.paint(drawVisitor, diagram);
            return this.convertToDiagramBounds(totalBounds);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    @Override
    public void paint(IChemModel chemModel, IDrawVisitor drawVisitor, Rectangle2D bounds, boolean resetCenter) {
        IAtomContainerSet moleculeSet = chemModel.getMoleculeSet();
        IReactionSet reactionSet = chemModel.getReactionSet();
        if (moleculeSet == null || reactionSet != null) {
            if (reactionSet != null) {
                this.reactionSetRenderer.paint(reactionSet, drawVisitor, bounds, resetCenter);
            }
            return;
        }
        Rectangle2D modelBounds = BoundsCalculator.calculateBounds(moleculeSet);
        this.setupTransformToFit(bounds, modelBounds, AverageBondLengthCalculator.calculateAverageBondLength(chemModel), resetCenter);
        IRenderingElement diagram = this.moleculeSetRenderer.generateDiagram(moleculeSet);
        this.paint(drawVisitor, diagram);
    }

    @Override
    public void repaint(IDrawVisitor drawVisitor) {
        this.paint(drawVisitor, this.cachedDiagram);
    }

    @Override
    public Rectangle calculateDiagramBounds(IChemModel model) {
        IAtomContainerSet moleculeSet = model.getMoleculeSet();
        IReactionSet reactionSet = model.getReactionSet();
        if (moleculeSet == null && reactionSet == null) {
            return new Rectangle();
        }
        Rectangle2D moleculeBounds = null;
        Rectangle2D reactionBounds = null;
        if (moleculeSet != null) {
            moleculeBounds = BoundsCalculator.calculateBounds(moleculeSet);
        }
        if (reactionSet != null) {
            reactionBounds = BoundsCalculator.calculateBounds(reactionSet);
        }
        if (moleculeBounds == null) {
            return this.calculateScreenBounds(reactionBounds);
        }
        if (reactionBounds == null) {
            return this.calculateScreenBounds(moleculeBounds);
        }
        Rectangle2D.Double allbounds = new Rectangle2D.Double();
        Rectangle2D.union(moleculeBounds, reactionBounds, allbounds);
        return this.calculateScreenBounds(allbounds);
    }

    @Override
    public double calculateScaleForBondLength(double modelBondLength) {
        if (Double.isNaN(modelBondLength) || modelBondLength == 0.0) {
            return this.rendererModel.getParameter(BasicSceneGenerator.Scale.class).getDefault();
        }
        return (Double)this.rendererModel.getParameter(BasicSceneGenerator.BondLength.class).getValue() / modelBondLength;
    }

    @Override
    public List<IGenerator<IChemModel>> getGenerators() {
        return null;
    }
}

