/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.ringsearch;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import org.openscience.cdk.exception.NoSuchAtomException;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.ringsearch.CyclicVertexSearch;
import org.openscience.cdk.ringsearch.JumboCyclicVertexSearch;
import org.openscience.cdk.ringsearch.RegularCyclicVertexSearch;

public final class RingSearch {
    private final CyclicVertexSearch searcher;
    private final IAtomContainer container;

    public RingSearch(IAtomContainer container2) {
        this(container2, GraphUtil.toAdjList(container2));
    }

    public RingSearch(IAtomContainer container2, int[][] graph) {
        this(container2, RingSearch.makeSearcher(graph));
    }

    public RingSearch(IAtomContainer container2, CyclicVertexSearch searcher) {
        if (container2 == null) {
            throw new NullPointerException("container must not be null");
        }
        if (searcher == null) {
            throw new NullPointerException("searcher was null");
        }
        this.searcher = searcher;
        this.container = container2;
    }

    private static CyclicVertexSearch makeSearcher(int[][] graph) {
        if (graph == null) {
            throw new NullPointerException("graph[][] must not be null");
        }
        if (graph.length <= 64) {
            return new RegularCyclicVertexSearch(graph);
        }
        return new JumboCyclicVertexSearch(graph);
    }

    public int numRings() {
        return this.searcher.numCycles();
    }

    public boolean cyclic(int u, int v) {
        return this.searcher.cyclic(u, v);
    }

    public boolean cyclic(IAtom atom) {
        int i = this.container.indexOf(atom);
        if (i < 0) {
            throw new NoSuchAtomException("no such atom");
        }
        return this.cyclic(i);
    }

    public boolean cyclic(IBond bond) {
        int u = this.container.indexOf(bond.getBegin());
        int v = this.container.indexOf(bond.getEnd());
        if (u < 0 || v < 0) {
            throw new NoSuchElementException("atoms of the bond are not found in the container");
        }
        return this.searcher.cyclic(u, v);
    }

    public boolean cyclic(int i) {
        return this.searcher.cyclic(i);
    }

    public int[] cyclic() {
        return this.searcher.cyclic();
    }

    public int[][] isolated() {
        return this.searcher.isolated();
    }

    public int[][] fused() {
        return this.searcher.fused();
    }

    public IAtomContainer ringFragments() {
        int[] vertices = this.cyclic();
        int n = vertices.length;
        IAtom[] atoms = new IAtom[n];
        ArrayList<IBond> bonds = new ArrayList<IBond>();
        for (int i = 0; i < vertices.length; ++i) {
            atoms[i] = this.container.getAtom(vertices[i]);
        }
        for (IBond bond : this.container.bonds()) {
            int v;
            IAtom either = bond.getBegin();
            IAtom other = bond.getEnd();
            int u = this.container.indexOf(either);
            if (!this.searcher.cyclic(u, v = this.container.indexOf(other))) continue;
            bonds.add(bond);
        }
        IChemObjectBuilder builder = this.container.getBuilder();
        IAtomContainer fragment = builder.newInstance(IAtomContainer.class, 0, 0, 0, 0);
        fragment.setAtoms(atoms);
        fragment.setBonds(bonds.toArray(new IBond[bonds.size()]));
        return fragment;
    }

    static boolean match(int eitherColor, int otherColor) {
        return eitherColor != -1 && otherColor != -1 && (eitherColor == otherColor || eitherColor == 0 || otherColor == 0);
    }

    public List<IAtomContainer> isolatedRingFragments() {
        return this.toFragments(this.isolated());
    }

    public List<IAtomContainer> fusedRingFragments() {
        return this.toFragments(this.fused());
    }

    private List<IAtomContainer> toFragments(int[][] verticesList) {
        ArrayList<IAtomContainer> fragments = new ArrayList<IAtomContainer>();
        for (int[] vertices : verticesList) {
            fragments.add(this.toFragment(vertices));
        }
        return fragments;
    }

    private IAtomContainer toFragment(int[] vertices) {
        int n = vertices.length;
        HashSet<IAtom> atoms = new HashSet<IAtom>(n > 3 ? n + 1 + n / 3 : n);
        ArrayList<IBond> bonds = new ArrayList<IBond>();
        for (int v : vertices) {
            atoms.add(this.container.getAtom(v));
        }
        Object object = this.container.bonds().iterator();
        while (object.hasNext()) {
            IBond bond = (IBond)object.next();
            IAtom either = bond.getBegin();
            IAtom other = bond.getEnd();
            if (!atoms.contains(either) || !atoms.contains(other)) continue;
            bonds.add(bond);
        }
        IAtomContainer fragment = this.container.getBuilder().newInstance(IAtomContainer.class, 0, 0, 0, 0);
        fragment.setAtoms(atoms.toArray(new IAtom[n]));
        fragment.setBonds(bonds.toArray(new IBond[bonds.size()]));
        return fragment;
    }
}

