/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.sgroup;

import java.util.HashMap;
import java.util.Map;

public enum SgroupType {
    CtabAbbreviation("SUP"),
    CtabMultipleGroup("MUL"),
    CtabStructureRepeatUnit("SRU"),
    CtabMonomer("MON"),
    CtabModified("MOD"),
    CtabCopolymer("COP"),
    CtabMer("MER"),
    CtabCrossLink("CRO"),
    CtabGraft("GRA"),
    CtabAnyPolymer("ANY"),
    CtabComponent("COM"),
    CtabMixture("MIX"),
    CtabFormulation("FOR"),
    CtabData("DAT"),
    CtabGeneric("GEN"),
    ExtMulticenter("_MAP", false),
    ExtAttachOrdering("_APO", false);

    static final Map<String, SgroupType> map;
    private final String ctabKey;
    private final boolean ctabStandard;

    private SgroupType(String ctabKey) {
        this(ctabKey, true);
    }

    private SgroupType(String ctabKey, boolean ctabStandard) {
        this.ctabKey = ctabKey;
        this.ctabStandard = ctabStandard;
    }

    public boolean isCtabStandard() {
        return this.ctabStandard;
    }

    public String getKey() {
        return this.ctabKey;
    }

    public static SgroupType parseCtabKey(String str2) {
        SgroupType type = map.get(str2);
        if (type == null) {
            return CtabGeneric;
        }
        return type;
    }

    static {
        map = new HashMap<String, SgroupType>();
        for (SgroupType t : SgroupType.values()) {
            map.put(t.ctabKey, t);
        }
    }
}

