/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.silent;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.silent.SilentChemObjectBuilder;

public class ChemObject
implements Serializable,
IChemObject,
Cloneable {
    private static final long serialVersionUID = 2798134548764323328L;
    private Map<Object, Object> properties;
    private short flags;
    private String identifier;
    private boolean doNotification = true;

    public ChemObject() {
        this.properties = null;
        this.identifier = null;
    }

    public ChemObject(IChemObject chemObject) {
        this.flags = chemObject.getFlagValue().shortValue();
        this.identifier = chemObject.getID();
    }

    @Override
    public void addListener(IChemObjectListener col) {
    }

    @Override
    public int getListenerCount() {
        return 0;
    }

    @Override
    public void removeListener(IChemObjectListener col) {
    }

    @Override
    public void notifyChanged() {
    }

    @Override
    public void notifyChanged(IChemObjectChangeEvent evt) {
    }

    private Map<Object, Object> lazyProperties() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<Object, Object>(4);
        }
        return this.properties;
    }

    @Override
    public void setProperty(Object description, Object property) {
        this.lazyProperties().put(description, property);
    }

    @Override
    public void removeProperty(Object description) {
        if (this.properties != null) {
            this.properties.remove(description);
            if (this.properties.isEmpty()) {
                this.properties = null;
            }
        }
    }

    @Override
    public <T> T getProperty(Object description) {
        if (this.properties == null) {
            return null;
        }
        Object value = this.lazyProperties().get(description);
        return (T)value;
    }

    @Override
    public <T> T getProperty(Object description, Class<T> c) {
        Object value = this.lazyProperties().get(description);
        if (c.isInstance(value)) {
            Object typed = value;
            return (T)typed;
        }
        if (value != null) {
            throw new IllegalArgumentException("attempted to access a property of incorrect type, expected " + c.getSimpleName() + " got " + value.getClass().getSimpleName());
        }
        return null;
    }

    @Override
    public Map<Object, Object> getProperties() {
        return this.properties == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.properties);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ChemObject clone = (ChemObject)super.clone();
        clone.flags = this.getFlagValue();
        if (this.properties != null) {
            clone.properties = new HashMap<Object, Object>(this.getProperties());
        }
        return clone;
    }

    public boolean compare(Object object) {
        if (!(object instanceof IChemObject)) {
            return false;
        }
        ChemObject chemObj = (ChemObject)object;
        return Objects.equals(this.identifier, chemObj.identifier);
    }

    @Override
    public String getID() {
        return this.identifier;
    }

    @Override
    public void setID(String identifier) {
        this.identifier = identifier;
    }

    private boolean isPowerOfTwo(int num) {
        return num == 1 || (num & num - 1) == 0;
    }

    @Override
    public void setFlag(int mask, boolean value) {
        if (mask > Short.MAX_VALUE || !this.isPowerOfTwo(mask)) {
            throw new IllegalArgumentException("setFlag() must be provided a valid CDKConstant and not used for custom properties");
        }
        this.flags = value ? (short)(this.flags | mask) : (short)(this.flags & ~mask);
    }

    @Override
    public boolean getFlag(int mask) {
        return (this.flags & mask) != 0;
    }

    @Override
    public Short getFlagValue() {
        return this.flags;
    }

    @Override
    public void setProperties(Map<Object, Object> properties) {
        this.properties = null;
        if (properties != null) {
            this.addProperties(properties);
        }
    }

    @Override
    public void addProperties(Map<Object, Object> properties) {
        if (properties == null) {
            return;
        }
        this.lazyProperties().putAll(properties);
    }

    @Override
    public void setFlags(boolean[] flagsNew) {
        for (int i = 0; i < flagsNew.length; ++i) {
            this.setFlag(CDKConstants.FLAG_MASKS[i], flagsNew[i]);
        }
    }

    @Override
    public boolean[] getFlags() {
        boolean[] flagArray = new boolean[14];
        for (int i = 0; i < CDKConstants.FLAG_MASKS.length; ++i) {
            int mask = CDKConstants.FLAG_MASKS[i];
            flagArray[i] = this.getFlag(mask);
        }
        return flagArray;
    }

    public Object shallowCopy() {
        Object copy = null;
        try {
            copy = super.clone();
        }
        catch (Exception e2) {
            e2.printStackTrace(System.err);
        }
        return copy;
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return SilentChemObjectBuilder.getInstance();
    }

    @Override
    public void setNotification(boolean bool) {
        this.doNotification = bool;
    }

    @Override
    public boolean getNotification() {
        return this.doNotification;
    }
}

