/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smarts;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openscience.cdk.AtomRef;
import org.openscience.cdk.BondRef;
import org.openscience.cdk.ReactionRole;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.isomorphism.matchers.Expr;
import org.openscience.cdk.isomorphism.matchers.QueryAtom;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.QueryBond;
import org.openscience.cdk.smarts.SmartsResult;
import org.openscience.cdk.stereo.DoubleBondStereochemistry;
import org.openscience.cdk.stereo.TetrahedralChirality;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public final class Smarts {
    public static final int FLAVOR_LOOSE = 1;
    public static final int FLAVOR_DAYLIGHT = 2;
    public static final int FLAVOR_CACTVS = 4;
    public static final int FLAVOR_MOE = 8;
    public static final int FLAVOR_OECHEM = 16;
    public static final int FLAVOR_CDK = 1;
    public static final int FLAVOR_CDK_LEGACY = 64;
    private static final int BOND_UNSPEC = 63;
    private static final int BOND_UP = 47;
    private static final int BOND_DOWN = 92;
    private static final int BSTEREO_ANY = 7;
    private static final int BSTEREO_INVALID = 0;
    private static final int BSTEREO_CIS = 4;
    private static final int BSTEREO_TRANS = 2;
    private static final int BSTEREO_UNSPEC = 1;
    private static final int BSTEREO_CIS_OR_TRANS = 6;
    private static final int BSTEREO_CIS_OR_UNSPEC = 5;
    private static final int BSTEREO_TRANS_OR_UNSPEC = 3;
    private static final String BSTEREO_UP = "/";
    private static final String BSTEREO_DN = "\\";
    private static final String BSTEREO_NEITHER = "!/!\\";
    private static final String BSTEREO_EITHER = "/,\\";
    private static final String BSTEREO_UPU = "/?";
    private static final String BSTEREO_DNU = "\\?";
    private static SmartsError lastError = null;

    private static void setErrorMesg(String sma, int pos, String str2) {
        lastError = new SmartsError(sma, pos, str2);
    }

    public static String getLastErrorMesg() {
        SmartsError error = lastError;
        if (error != null) {
            return error.mesg;
        }
        return null;
    }

    public static String getLastErrorLocation() {
        SmartsError error = lastError;
        if (error != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(error.str);
            sb.append('\n');
            char[] cs = new char[error.pos - 1];
            Arrays.fill(cs, ' ');
            sb.append(cs);
            sb.append('^');
            sb.append('\n');
            return sb.toString();
        }
        return null;
    }

    private static boolean hasOr(Expr expr) {
        block5: while (true) {
            switch (expr.type()) {
                case AND: {
                    if (Smarts.hasOr(expr.left())) {
                        return true;
                    }
                    expr = expr.right();
                    continue block5;
                }
                case OR: {
                    return expr.left().type() != Expr.Type.STEREOCHEMISTRY || expr.right().type() != Expr.Type.STEREOCHEMISTRY || expr.right().value() != 0;
                }
                case SINGLE_OR_AROMATIC: 
                case SINGLE_OR_DOUBLE: 
                case DOUBLE_OR_AROMATIC: {
                    return true;
                }
            }
            break;
        }
        return false;
    }

    private static boolean isUpper(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private static boolean isLower(char c) {
        return c >= 'a' && c <= 'z';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean generateBond(StringBuilder sb, Expr expr) {
        block0 : switch (expr.type()) {
            case TRUE: {
                sb.append('~');
                break;
            }
            case FALSE: {
                sb.append("!~");
                break;
            }
            case IS_AROMATIC: {
                sb.append(":");
                break;
            }
            case IS_ALIPHATIC: {
                sb.append("!:");
                break;
            }
            case IS_IN_RING: {
                sb.append("@");
                break;
            }
            case IS_IN_CHAIN: {
                sb.append("!@");
                break;
            }
            case SINGLE_OR_AROMATIC: {
                sb.append("-,:");
                break;
            }
            case DOUBLE_OR_AROMATIC: {
                sb.append("=,:");
                break;
            }
            case SINGLE_OR_DOUBLE: {
                sb.append("-,=");
                break;
            }
            case ORDER: {
                LoggingToolFactory.createLoggingTool(Smarts.class).warn("Expr.Type.ORDER cannot be round-tripped via SMARTS!");
            }
            case ALIPHATIC_ORDER: {
                switch (expr.value()) {
                    case 1: {
                        sb.append('-');
                        break block0;
                    }
                    case 2: {
                        sb.append('=');
                        break block0;
                    }
                    case 3: {
                        sb.append('#');
                        break block0;
                    }
                    case 4: {
                        sb.append('$');
                        break block0;
                    }
                }
                throw new IllegalArgumentException();
            }
            case NOT: {
                sb.append('!');
                if (Smarts.generateBond(sb, expr.left())) break;
                sb.setLength(sb.length() - 1);
                return false;
            }
            case OR: {
                if (Smarts.generateBond(sb, expr.left())) {
                    sb.append(',');
                    if (!Smarts.generateBond(sb, expr.right())) {
                        sb.setLength(sb.length() - 1);
                    }
                    return true;
                }
                return Smarts.generateBond(sb, expr.right());
            }
            case AND: {
                boolean lowPrec;
                boolean bl = lowPrec = Smarts.hasOr(expr.left()) || Smarts.hasOr(expr.right());
                if (Smarts.generateBond(sb, expr.left())) {
                    if (lowPrec) {
                        sb.append(';');
                    }
                    if (!Smarts.generateBond(sb, expr.right()) && lowPrec) {
                        sb.setLength(sb.length() - 1);
                    }
                    return true;
                }
                return Smarts.generateBond(sb, expr.right());
            }
            case STEREOCHEMISTRY: {
                return false;
            }
            default: {
                throw new IllegalArgumentException("Can not generate SMARTS for bond expression: " + (Object)((Object)expr.type()));
            }
        }
        return true;
    }

    public static SmartsResult parseToResult(IAtomContainer mol, String smarts, int flavor) {
        Parser state = new Parser(mol, smarts, flavor);
        if (!state.parse()) {
            return new SmartsResult(smarts, state.pos, state.error);
        }
        return new SmartsResult(smarts);
    }

    public static SmartsResult parseToResult(IAtomContainer mol, String smarts) {
        return Smarts.parseToResult(mol, smarts, 1);
    }

    public static boolean parse(IAtomContainer mol, String smarts, int flavor) {
        SmartsResult result = Smarts.parseToResult(mol, smarts, flavor);
        if (!result.ok()) {
            Smarts.setErrorMesg(smarts, result.getPosition(), result.getMessage());
        }
        return result.ok();
    }

    public static boolean parse(IAtomContainer mol, String smarts) {
        return Smarts.parse(mol, smarts, 1);
    }

    public static String generateAtom(Expr expr) {
        return new Generator(null).generateAtom(null, expr);
    }

    public static String generateBond(Expr expr) {
        if (expr.type() == Expr.Type.SINGLE_OR_AROMATIC) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Smarts.generateBond(sb, expr);
        return sb.toString();
    }

    public static String generate(IAtomContainer mol) {
        return new Generator(mol).generate();
    }

    private static int compGroup(IAtom atom) {
        Integer id = (Integer)atom.getProperty("cdk:ReactionGroup");
        return id != null ? id : 0;
    }

    private static ReactionRole role(IAtom atom) {
        ReactionRole role = (ReactionRole)((Object)atom.getProperty("cdk:ReactionRole"));
        return role != null ? role : ReactionRole.None;
    }

    private static int mapidx(IAtom atom) {
        Integer mapidx = (Integer)atom.getProperty("cdk:AtomAtomMapping");
        return mapidx != null ? mapidx : 0;
    }

    private static int getBondStereoFlag(Expr expr) {
        switch (expr.type()) {
            case STEREOCHEMISTRY: {
                switch (expr.value()) {
                    case 0: {
                        return 1;
                    }
                    case 2: {
                        return 4;
                    }
                    case 1: {
                        return 2;
                    }
                }
                throw new IllegalArgumentException();
            }
            case OR: {
                return Smarts.getBondStereoFlag(expr.left()) | Smarts.getBondStereoFlag(expr.right());
            }
            case AND: {
                return Smarts.getBondStereoFlag(expr.left()) & Smarts.getBondStereoFlag(expr.right());
            }
            case NOT: {
                return ~Smarts.getBondStereoFlag(expr.left());
            }
        }
        return 7;
    }

    private static Expr strip(Expr expr, Expr.Type type) {
        switch (expr.type()) {
            case AND: 
            case OR: {
                Expr left = Smarts.strip(expr.left(), type);
                Expr right = Smarts.strip(expr.right(), type);
                if (left != null && right != null) {
                    expr.setLogical(expr.type(), left, right);
                } else {
                    if (left != null) {
                        return left;
                    }
                    if (right != null) {
                        return right;
                    }
                    return null;
                }
            }
            case NOT: {
                Expr sub = Smarts.strip(expr.left(), type);
                if (sub != null) {
                    expr.setLogical(expr.type(), sub, null);
                    return expr;
                }
                return null;
            }
        }
        return expr.type() == type ? null : expr;
    }

    private static final class SmartsError {
        private final String str;
        private final int pos;
        private final String mesg;

        public SmartsError(String str2, int pos, String mesg) {
            this.str = str2;
            this.pos = pos;
            this.mesg = mesg;
        }
    }

    private static final class Parser {
        public String error;
        private final String str;
        private final IAtomContainer mol;
        private final int flav;
        private int pos;
        private IAtom prev;
        private QueryBond bond;
        private final Deque<IAtom> stack = new ArrayDeque<IAtom>();
        private final IBond[] rings = new IBond[100];
        private final Map<IAtom, LocalNbrs> local = new HashMap<IAtom, LocalNbrs>();
        private final Set<IAtom> astereo = new HashSet<IAtom>();
        private final Set<IBond> bstereo = new HashSet<IBond>();
        private int numRingOpens;
        private ReactionRole role = ReactionRole.None;
        private int numComponents;
        private int curComponentId;

        public Parser(IAtomContainer mol, String str2, int flav) {
            this.str = str2;
            this.mol = mol;
            this.flav = flav;
            this.pos = 0;
        }

        IBond addBond(IAtom atom, IBond bond) {
            LocalNbrs nbrs;
            if (atom.equals(bond.getBegin())) {
                this.mol.addBond(bond);
                bond = this.mol.getBond(this.mol.getBondCount() - 1);
            }
            if ((nbrs = this.local.get(atom)) == null) {
                nbrs = new LocalNbrs(false);
                this.local.put(atom, nbrs);
            }
            nbrs.bonds.add(bond);
            return bond;
        }

        int nextUnsignedInt() {
            if (!Parser.isDigit(this.peek())) {
                return -1;
            }
            int res = this.next() - 48;
            while (Parser.isDigit(this.peek())) {
                res = 10 * res + (this.next() - 48);
            }
            return res;
        }

        boolean parseExplicitHydrogen(IAtom atom, Expr dest) {
            int num;
            Expr hExpr;
            int mark = this.pos;
            int isotope = this.nextUnsignedInt();
            if (this.str.charAt(this.pos++) != 'H') {
                this.pos = mark;
                return false;
            }
            Expr expr = hExpr = isotope < 0 ? new Expr(Expr.Type.ELEMENT, 1) : new Expr(Expr.Type.AND, new Expr(Expr.Type.ISOTOPE, isotope), new Expr(Expr.Type.ELEMENT, 1));
            if (this.peek() == '+') {
                ++this.pos;
                num = this.nextUnsignedInt();
                if (num < 0) {
                    num = 1;
                    while (this.peek() == '+') {
                        this.next();
                        ++num;
                    }
                }
                hExpr.and(new Expr(Expr.Type.FORMAL_CHARGE, num));
            } else if (this.peek() == '-') {
                ++this.pos;
                num = this.nextUnsignedInt();
                if (num < 0) {
                    num = 1;
                    while (this.peek() == '-') {
                        this.next();
                        ++num;
                    }
                }
                hExpr.and(new Expr(Expr.Type.FORMAL_CHARGE, -num));
            }
            if (this.peek() == ':') {
                this.next();
                num = this.nextUnsignedInt();
                if (num < 0) {
                    this.pos = mark;
                    return false;
                }
                atom.setProperty("cdk:AtomAtomMapping", num);
            }
            if (this.peek() == ']') {
                ++this.pos;
                dest.set(hExpr);
                return true;
            }
            this.pos = mark;
            return false;
        }

        private boolean parseRange(Expr expr) {
            if (this.next() != '{') {
                return false;
            }
            int lo = this.nextUnsignedInt();
            if (this.next() != '-') {
                return false;
            }
            int hi = this.nextUnsignedInt();
            Expr.Type type = expr.type();
            switch (type) {
                case HAS_IMPLICIT_HYDROGEN: {
                    type = Expr.Type.IMPL_H_COUNT;
                }
            }
            expr.setPrimitive(type, lo);
            for (int i = lo + 1; i <= hi; ++i) {
                expr.or(new Expr(type, i));
            }
            return this.next() == '}';
        }

        private boolean parseGt(Expr expr) {
            if (this.next() != '>') {
                return false;
            }
            int lo = this.nextUnsignedInt();
            Expr.Type type = expr.type();
            switch (type) {
                case HAS_IMPLICIT_HYDROGEN: {
                    type = Expr.Type.IMPL_H_COUNT;
                }
            }
            expr.setPrimitive(type, 0);
            expr.negate();
            for (int i = 1; i <= lo; ++i) {
                expr.and(new Expr(type, i).negate());
            }
            return true;
        }

        private boolean parseLt(Expr expr) {
            if (this.next() != '<') {
                return false;
            }
            int lo = this.nextUnsignedInt();
            Expr.Type type = expr.type();
            switch (type) {
                case HAS_IMPLICIT_HYDROGEN: {
                    type = Expr.Type.IMPL_H_COUNT;
                }
            }
            expr.setPrimitive(type, 0);
            for (int i = 1; i < lo; ++i) {
                expr.or(new Expr(type, i));
            }
            return true;
        }

        boolean parseAtomExpr(IAtom atom, Expr dest, char lastOp) {
            Expr expr = null;
            while (true) {
                int currOp = 38;
                block0 : switch (this.next()) {
                    case '*': {
                        expr = new Expr(Expr.Type.TRUE);
                        break;
                    }
                    case 'A': {
                        switch (this.next()) {
                            case 'c': {
                                expr = new Expr(Expr.Type.ELEMENT, 89);
                                break block0;
                            }
                            case 'g': {
                                expr = new Expr(Expr.Type.ELEMENT, 47);
                                break block0;
                            }
                            case 'l': {
                                expr = new Expr(Expr.Type.ALIPHATIC_ELEMENT, 13);
                                break block0;
                            }
                            case 'm': {
                                expr = new Expr(Expr.Type.ELEMENT, 95);
                                break block0;
                            }
                            case 'r': {
                                expr = new Expr(Expr.Type.ELEMENT, 18);
                                break block0;
                            }
                            case 's': {
                                expr = new Expr(Expr.Type.ALIPHATIC_ELEMENT, 33);
                                break block0;
                            }
                            case 't': {
                                expr = new Expr(Expr.Type.ELEMENT, 85);
                                break block0;
                            }
                            case 'u': {
                                expr = new Expr(Expr.Type.ELEMENT, 79);
                                break block0;
                            }
                        }
                        this.unget();
                        expr = new Expr(Expr.Type.IS_ALIPHATIC);
                        break;
                    }
                    case 'B': {
                        switch (this.next()) {
                            case 'a': {
                                expr = new Expr(Expr.Type.ELEMENT, 56);
                                break block0;
                            }
                            case 'e': {
                                expr = new Expr(Expr.Type.ELEMENT, 4);
                                break block0;
                            }
                            case 'h': {
                                expr = new Expr(Expr.Type.ELEMENT, 107);
                                break block0;
                            }
                            case 'i': {
                                expr = new Expr(Expr.Type.ELEMENT, 83);
                                break block0;
                            }
                            case 'k': {
                                expr = new Expr(Expr.Type.ELEMENT, 97);
                                break block0;
                            }
                            case 'r': {
                                expr = new Expr(Expr.Type.ELEMENT, 35);
                                break block0;
                            }
                        }
                        this.unget();
                        expr = new Expr(Expr.Type.ALIPHATIC_ELEMENT, 5);
                        break;
                    }
                    case 'C': {
                        switch (this.next()) {
                            case 'a': {
                                expr = new Expr(Expr.Type.ELEMENT, 20);
                                break block0;
                            }
                            case 'd': {
                                expr = new Expr(Expr.Type.ELEMENT, 48);
                                break block0;
                            }
                            case 'e': {
                                expr = new Expr(Expr.Type.ELEMENT, 58);
                                break block0;
                            }
                            case 'f': {
                                expr = new Expr(Expr.Type.ELEMENT, 98);
                                break block0;
                            }
                            case 'l': {
                                expr = new Expr(Expr.Type.ELEMENT, 17);
                                break block0;
                            }
                            case 'm': {
                                expr = new Expr(Expr.Type.ELEMENT, 96);
                                break block0;
                            }
                            case 'n': {
                                expr = new Expr(Expr.Type.ELEMENT, 112);
                                break block0;
                            }
                            case 'o': {
                                expr = new Expr(Expr.Type.ELEMENT, 27);
                                break block0;
                            }
                            case 'r': {
                                expr = new Expr(Expr.Type.ELEMENT, 24);
                                break block0;
                            }
                            case 's': {
                                expr = new Expr(Expr.Type.ELEMENT, 55);
                                break block0;
                            }
                            case 'u': {
                                expr = new Expr(Expr.Type.ELEMENT, 29);
                                break block0;
                            }
                        }
                        this.unget();
                        expr = new Expr(Expr.Type.ALIPHATIC_ELEMENT, 6);
                        break;
                    }
                    case 'D': {
                        switch (this.next()) {
                            case 'b': {
                                expr = new Expr(Expr.Type.ELEMENT, 105);
                                break block0;
                            }
                            case 's': {
                                expr = new Expr(Expr.Type.ELEMENT, 110);
                                break block0;
                            }
                            case 'y': {
                                expr = new Expr(Expr.Type.ELEMENT, 66);
                                break block0;
                            }
                        }
                        this.unget();
                        int num = this.nextUnsignedInt();
                        if (num < 0) {
                            expr = this.isFlavor(64) ? new Expr(Expr.Type.HEAVY_DEGREE, 1) : new Expr(Expr.Type.DEGREE, 1);
                            switch (this.peek()) {
                                case '{': {
                                    if (this.parseRange(expr)) break;
                                    return false;
                                }
                                case '>': {
                                    if (this.parseGt(expr)) break;
                                    return false;
                                }
                                case '<': {
                                    if (this.parseLt(expr)) break;
                                    return false;
                                }
                            }
                            break;
                        }
                        if (this.isFlavor(64)) {
                            expr = new Expr(Expr.Type.HEAVY_DEGREE, num);
                            break;
                        }
                        expr = new Expr(Expr.Type.DEGREE, num);
                        break;
                    }
                    case 'E': {
                        switch (this.next()) {
                            case 'r': {
                                expr = new Expr(Expr.Type.ELEMENT, 68);
                                break block0;
                            }
                            case 's': {
                                expr = new Expr(Expr.Type.ELEMENT, 99);
                                break block0;
                            }
                            case 'u': {
                                expr = new Expr(Expr.Type.ELEMENT, 63);
                                break block0;
                            }
                        }
                        return false;
                    }
                    case 'F': {
                        switch (this.next()) {
                            case 'e': {
                                expr = new Expr(Expr.Type.ELEMENT, 26);
                                break block0;
                            }
                            case 'l': {
                                expr = new Expr(Expr.Type.ELEMENT, 114);
                                break block0;
                            }
                            case 'm': {
                                expr = new Expr(Expr.Type.ELEMENT, 100);
                                break block0;
                            }
                            case 'r': {
                                expr = new Expr(Expr.Type.ELEMENT, 87);
                                break block0;
                            }
                        }
                        this.unget();
                        expr = new Expr(Expr.Type.ELEMENT, 9);
                        break;
                    }
                    case 'G': {
                        switch (this.next()) {
                            case 'a': {
                                expr = new Expr(Expr.Type.ELEMENT, 31);
                                break block0;
                            }
                            case 'd': {
                                expr = new Expr(Expr.Type.ELEMENT, 64);
                                break block0;
                            }
                            case 'e': {
                                expr = new Expr(Expr.Type.ALIPHATIC_ELEMENT, 32);
                                break block0;
                            }
                        }
                        this.unget();
                        int num = this.nextUnsignedInt();
                        if (num <= 0 || num > 18) {
                            return false;
                        }
                        if (this.isFlavor(64)) {
                            expr = new Expr(Expr.Type.PERIODIC_GROUP, num);
                            break;
                        }
                        if (this.isFlavor(4)) {
                            expr = new Expr(Expr.Type.INSATURATION, num);
                            break;
                        }
                        return false;
                    }
                    case 'H': {
                        switch (this.next()) {
                            case 'e': {
                                expr = new Expr(Expr.Type.ELEMENT, 2);
                                break block0;
                            }
                            case 'f': {
                                expr = new Expr(Expr.Type.ELEMENT, 72);
                                break block0;
                            }
                            case 'g': {
                                expr = new Expr(Expr.Type.ELEMENT, 80);
                                break block0;
                            }
                            case 'o': {
                                expr = new Expr(Expr.Type.ELEMENT, 67);
                                break block0;
                            }
                            case 's': {
                                expr = new Expr(Expr.Type.ELEMENT, 108);
                                break block0;
                            }
                        }
                        this.unget();
                        int num = this.nextUnsignedInt();
                        if (num < 0) {
                            expr = new Expr(Expr.Type.TOTAL_H_COUNT, 1);
                            switch (this.peek()) {
                                case '{': {
                                    if (this.parseRange(expr)) break;
                                    return false;
                                }
                                case '>': {
                                    if (this.parseGt(expr)) break;
                                    return false;
                                }
                                case '<': {
                                    if (this.parseLt(expr)) break;
                                    return false;
                                }
                            }
                            break;
                        }
                        expr = new Expr(Expr.Type.TOTAL_H_COUNT, num);
                        break;
                    }
                    case 'I': {
                        switch (this.next()) {
                            case 'n': {
                                expr = new Expr(Expr.Type.ELEMENT, 49);
                                break block0;
                            }
                            case 'r': {
                                expr = new Expr(Expr.Type.ELEMENT, 77);
                                break block0;
                            }
                        }
                        this.unget();
                        expr = new Expr(Expr.Type.ELEMENT, 53);
                        break;
                    }
                    case 'K': {
                        switch (this.next()) {
                            case 'r': {
                                expr = new Expr(Expr.Type.ELEMENT, 36);
                                break block0;
                            }
                        }
                        this.unget();
                        expr = new Expr(Expr.Type.ELEMENT, 19);
                        break;
                    }
                    case 'L': {
                        switch (this.next()) {
                            case 'a': {
                                expr = new Expr(Expr.Type.ELEMENT, 57);
                                break block0;
                            }
                            case 'i': {
                                expr = new Expr(Expr.Type.ELEMENT, 3);
                                break block0;
                            }
                            case 'r': {
                                expr = new Expr(Expr.Type.ELEMENT, 103);
                                break block0;
                            }
                            case 'u': {
                                expr = new Expr(Expr.Type.ELEMENT, 71);
                                break block0;
                            }
                            case 'v': {
                                expr = new Expr(Expr.Type.ELEMENT, 116);
                                break block0;
                            }
                        }
                        return false;
                    }
                    case 'M': {
                        switch (this.next()) {
                            case 'c': {
                                expr = new Expr(Expr.Type.ELEMENT, 115);
                                break block0;
                            }
                            case 'd': {
                                expr = new Expr(Expr.Type.ELEMENT, 101);
                                break block0;
                            }
                            case 'g': {
                                expr = new Expr(Expr.Type.ELEMENT, 12);
                                break block0;
                            }
                            case 'n': {
                                expr = new Expr(Expr.Type.ELEMENT, 25);
                                break block0;
                            }
                            case 'o': {
                                expr = new Expr(Expr.Type.ELEMENT, 42);
                                break block0;
                            }
                            case 't': {
                                expr = new Expr(Expr.Type.ELEMENT, 109);
                                break block0;
                            }
                        }
                        return false;
                    }
                    case 'N': {
                        switch (this.next()) {
                            case 'a': {
                                expr = new Expr(Expr.Type.ELEMENT, 11);
                                break block0;
                            }
                            case 'b': {
                                expr = new Expr(Expr.Type.ELEMENT, 41);
                                break block0;
                            }
                            case 'd': {
                                expr = new Expr(Expr.Type.ELEMENT, 60);
                                break block0;
                            }
                            case 'e': {
                                expr = new Expr(Expr.Type.ELEMENT, 10);
                                break block0;
                            }
                            case 'h': {
                                expr = new Expr(Expr.Type.ELEMENT, 113);
                                break block0;
                            }
                            case 'i': {
                                expr = new Expr(Expr.Type.ELEMENT, 28);
                                break block0;
                            }
                            case 'o': {
                                expr = new Expr(Expr.Type.ELEMENT, 102);
                                break block0;
                            }
                            case 'p': {
                                expr = new Expr(Expr.Type.ELEMENT, 93);
                                break block0;
                            }
                        }
                        this.unget();
                        expr = new Expr(Expr.Type.ALIPHATIC_ELEMENT, 7);
                        break;
                    }
                    case 'O': {
                        switch (this.next()) {
                            case 'g': {
                                expr = new Expr(Expr.Type.ELEMENT, 118);
                                break block0;
                            }
                            case 's': {
                                expr = new Expr(Expr.Type.ELEMENT, 76);
                                break block0;
                            }
                        }
                        this.unget();
                        expr = new Expr(Expr.Type.ALIPHATIC_ELEMENT, 8);
                        break;
                    }
                    case 'P': {
                        switch (this.next()) {
                            case 'a': {
                                expr = new Expr(Expr.Type.ELEMENT, 91);
                                break block0;
                            }
                            case 'b': {
                                expr = new Expr(Expr.Type.ELEMENT, 82);
                                break block0;
                            }
                            case 'd': {
                                expr = new Expr(Expr.Type.ELEMENT, 46);
                                break block0;
                            }
                            case 'm': {
                                expr = new Expr(Expr.Type.ELEMENT, 61);
                                break block0;
                            }
                            case 'o': {
                                expr = new Expr(Expr.Type.ELEMENT, 84);
                                break block0;
                            }
                            case 'r': {
                                expr = new Expr(Expr.Type.ELEMENT, 59);
                                break block0;
                            }
                            case 't': {
                                expr = new Expr(Expr.Type.ELEMENT, 78);
                                break block0;
                            }
                            case 'u': {
                                expr = new Expr(Expr.Type.ELEMENT, 94);
                                break block0;
                            }
                        }
                        this.unget();
                        expr = new Expr(Expr.Type.ALIPHATIC_ELEMENT, 15);
                        break;
                    }
                    case 'Q': {
                        return false;
                    }
                    case 'R': {
                        switch (this.next()) {
                            case 'a': {
                                expr = new Expr(Expr.Type.ELEMENT, 88);
                                break block0;
                            }
                            case 'b': {
                                expr = new Expr(Expr.Type.ELEMENT, 37);
                                break block0;
                            }
                            case 'e': {
                                expr = new Expr(Expr.Type.ELEMENT, 75);
                                break block0;
                            }
                            case 'f': {
                                expr = new Expr(Expr.Type.ELEMENT, 104);
                                break block0;
                            }
                            case 'g': {
                                expr = new Expr(Expr.Type.ELEMENT, 111);
                                break block0;
                            }
                            case 'h': {
                                expr = new Expr(Expr.Type.ELEMENT, 45);
                                break block0;
                            }
                            case 'n': {
                                expr = new Expr(Expr.Type.ELEMENT, 86);
                                break block0;
                            }
                            case 'u': {
                                expr = new Expr(Expr.Type.ELEMENT, 44);
                                break block0;
                            }
                        }
                        this.unget();
                        int num = this.nextUnsignedInt();
                        if (num < 0) {
                            expr = new Expr(Expr.Type.IS_IN_RING);
                            switch (this.peek()) {
                                case '{': {
                                    expr.setPrimitive(Expr.Type.RING_COUNT, 0);
                                    if (this.parseRange(expr)) break;
                                    return false;
                                }
                                case '>': {
                                    expr.setPrimitive(Expr.Type.RING_COUNT, 0);
                                    if (this.parseGt(expr)) break;
                                    return false;
                                }
                                case '<': {
                                    expr.setPrimitive(Expr.Type.RING_COUNT, 0);
                                    if (this.parseLt(expr)) break;
                                    return false;
                                }
                            }
                            break;
                        }
                        if (num == 0) {
                            expr = new Expr(Expr.Type.IS_IN_CHAIN);
                            break;
                        }
                        if (this.isFlavor(16)) {
                            expr = new Expr(Expr.Type.RING_BOND_COUNT, num);
                            break;
                        }
                        expr = new Expr(Expr.Type.RING_COUNT, num);
                        break;
                    }
                    case 'S': {
                        switch (this.next()) {
                            case 'b': {
                                expr = new Expr(Expr.Type.ALIPHATIC_ELEMENT, 51);
                                break block0;
                            }
                            case 'c': {
                                expr = new Expr(Expr.Type.ELEMENT, 21);
                                break block0;
                            }
                            case 'e': {
                                expr = new Expr(Expr.Type.ALIPHATIC_ELEMENT, 34);
                                break block0;
                            }
                            case 'g': {
                                expr = new Expr(Expr.Type.ELEMENT, 106);
                                break block0;
                            }
                            case 'i': {
                                expr = new Expr(Expr.Type.ALIPHATIC_ELEMENT, 14);
                                break block0;
                            }
                            case 'm': {
                                expr = new Expr(Expr.Type.ELEMENT, 62);
                                break block0;
                            }
                            case 'n': {
                                expr = new Expr(Expr.Type.ELEMENT, 50);
                                break block0;
                            }
                            case 'r': {
                                expr = new Expr(Expr.Type.ELEMENT, 38);
                                break block0;
                            }
                        }
                        this.unget();
                        expr = new Expr(Expr.Type.ALIPHATIC_ELEMENT, 16);
                        break;
                    }
                    case 'T': {
                        switch (this.next()) {
                            case 'a': {
                                expr = new Expr(Expr.Type.ELEMENT, 73);
                                break block0;
                            }
                            case 'b': {
                                expr = new Expr(Expr.Type.ELEMENT, 65);
                                break block0;
                            }
                            case 'c': {
                                expr = new Expr(Expr.Type.ELEMENT, 43);
                                break block0;
                            }
                            case 'e': {
                                expr = new Expr(Expr.Type.ALIPHATIC_ELEMENT, 52);
                                break block0;
                            }
                            case 'h': {
                                expr = new Expr(Expr.Type.ELEMENT, 90);
                                break block0;
                            }
                            case 'i': {
                                expr = new Expr(Expr.Type.ELEMENT, 22);
                                break block0;
                            }
                            case 'l': {
                                expr = new Expr(Expr.Type.ELEMENT, 81);
                                break block0;
                            }
                            case 'm': {
                                expr = new Expr(Expr.Type.ELEMENT, 69);
                                break block0;
                            }
                            case 's': {
                                expr = new Expr(Expr.Type.ELEMENT, 117);
                                break block0;
                            }
                        }
                        return false;
                    }
                    case 'U': {
                        switch (this.next()) {
                            default: 
                        }
                        this.unget();
                        expr = new Expr(Expr.Type.ELEMENT, 92);
                        break;
                    }
                    case 'V': {
                        switch (this.next()) {
                            default: 
                        }
                        this.unget();
                        expr = new Expr(Expr.Type.ELEMENT, 23);
                        break;
                    }
                    case 'W': {
                        switch (this.next()) {
                            default: 
                        }
                        this.unget();
                        expr = new Expr(Expr.Type.ELEMENT, 74);
                        break;
                    }
                    case 'X': {
                        switch (this.next()) {
                            case 'e': {
                                expr = new Expr(Expr.Type.ELEMENT, 54);
                                break block0;
                            }
                        }
                        this.unget();
                        int num = this.nextUnsignedInt();
                        if (num < 0) {
                            expr = new Expr(Expr.Type.TOTAL_DEGREE, 1);
                            switch (this.peek()) {
                                case '{': {
                                    if (this.parseRange(expr)) break;
                                    return false;
                                }
                                case '>': {
                                    if (this.parseGt(expr)) break;
                                    return false;
                                }
                                case '<': {
                                    if (this.parseLt(expr)) break;
                                    return false;
                                }
                            }
                            break;
                        }
                        expr = new Expr(Expr.Type.TOTAL_DEGREE, num);
                        break;
                    }
                    case 'Y': {
                        switch (this.next()) {
                            case 'b': {
                                expr = new Expr(Expr.Type.ELEMENT, 70);
                                break block0;
                            }
                        }
                        this.unget();
                        expr = new Expr(Expr.Type.ELEMENT, 39);
                        break;
                    }
                    case 'Z': {
                        switch (this.next()) {
                            case 'n': {
                                expr = new Expr(Expr.Type.ELEMENT, 30);
                                break block0;
                            }
                            case 'r': {
                                expr = new Expr(Expr.Type.ELEMENT, 40);
                                break block0;
                            }
                        }
                        this.unget();
                        int num = this.nextUnsignedInt();
                        if (this.isFlavor(2)) {
                            if (num < 0) {
                                expr = new Expr(Expr.Type.IS_IN_RING);
                                break;
                            }
                            if (num == 0) {
                                expr = new Expr(Expr.Type.IS_IN_CHAIN);
                                break;
                            }
                            expr = new Expr(Expr.Type.RING_SIZE, num);
                            break;
                        }
                        if (this.isFlavor(4)) {
                            if (num < 0) {
                                expr = new Expr(Expr.Type.HAS_ALIPHATIC_HETERO_SUBSTITUENT);
                                break;
                            }
                            if (num == 0) {
                                expr = new Expr(Expr.Type.HAS_ALIPHATIC_HETERO_SUBSTITUENT).negate();
                                break;
                            }
                            expr = new Expr(Expr.Type.ALIPHATIC_HETERO_SUBSTITUENT_COUNT, num);
                            break;
                        }
                        return false;
                    }
                    case 'a': {
                        switch (this.next()) {
                            case 'l': {
                                expr = new Expr(Expr.Type.AROMATIC_ELEMENT, 13);
                                break block0;
                            }
                            case 's': {
                                expr = new Expr(Expr.Type.AROMATIC_ELEMENT, 33);
                                break block0;
                            }
                        }
                        this.unget();
                        expr = new Expr(Expr.Type.IS_AROMATIC);
                        break;
                    }
                    case 'b': {
                        switch (this.next()) {
                            default: 
                        }
                        this.unget();
                        expr = new Expr(Expr.Type.AROMATIC_ELEMENT, 5);
                        break;
                    }
                    case 'c': {
                        expr = new Expr(Expr.Type.AROMATIC_ELEMENT, 6);
                        break;
                    }
                    case 'n': {
                        expr = new Expr(Expr.Type.AROMATIC_ELEMENT, 7);
                        break;
                    }
                    case 'o': {
                        expr = new Expr(Expr.Type.AROMATIC_ELEMENT, 8);
                        break;
                    }
                    case 'p': {
                        expr = new Expr(Expr.Type.AROMATIC_ELEMENT, 15);
                        break;
                    }
                    case 's': {
                        switch (this.next()) {
                            case 'b': {
                                expr = new Expr(Expr.Type.AROMATIC_ELEMENT, 51);
                                break block0;
                            }
                            case 'e': {
                                expr = new Expr(Expr.Type.AROMATIC_ELEMENT, 34);
                                break block0;
                            }
                            case 'i': {
                                expr = new Expr(Expr.Type.AROMATIC_ELEMENT, 14);
                                break block0;
                            }
                        }
                        this.unget();
                        expr = new Expr(Expr.Type.AROMATIC_ELEMENT, 16);
                        break;
                    }
                    case 't': {
                        switch (this.next()) {
                            case 'e': {
                                expr = new Expr(Expr.Type.AROMATIC_ELEMENT, 52);
                                break block0;
                            }
                        }
                        this.unget();
                        return false;
                    }
                    case 'r': {
                        int num = this.nextUnsignedInt();
                        if (num < 0) {
                            expr = new Expr(Expr.Type.IS_IN_RING);
                            if (this.peek() != '{') break;
                            expr.setPrimitive(Expr.Type.RING_SMALLEST, 0);
                            if (this.parseRange(expr)) break;
                            return false;
                        }
                        if (num == 0) {
                            expr = new Expr(Expr.Type.IS_IN_CHAIN);
                            break;
                        }
                        if (num > 2) {
                            expr = new Expr(Expr.Type.RING_SMALLEST, num);
                            break;
                        }
                        return false;
                    }
                    case 'v': {
                        int num = this.nextUnsignedInt();
                        if (num < 0) {
                            expr = new Expr(Expr.Type.VALENCE, 1);
                            switch (this.peek()) {
                                case '{': {
                                    if (this.parseRange(expr)) break;
                                    return false;
                                }
                                case '>': {
                                    if (this.parseGt(expr)) break;
                                    return false;
                                }
                                case '<': {
                                    if (this.parseLt(expr)) break;
                                    return false;
                                }
                            }
                            break;
                        }
                        expr = new Expr(Expr.Type.VALENCE, num);
                        break;
                    }
                    case 'h': {
                        int num = this.nextUnsignedInt();
                        if (num < 0) {
                            expr = new Expr(Expr.Type.HAS_IMPLICIT_HYDROGEN);
                            switch (this.peek()) {
                                case '{': {
                                    if (this.parseRange(expr)) break;
                                    return false;
                                }
                                case '>': {
                                    if (this.parseGt(expr)) break;
                                    return false;
                                }
                                case '<': {
                                    if (this.parseLt(expr)) break;
                                    return false;
                                }
                            }
                            break;
                        }
                        expr = new Expr(Expr.Type.IMPL_H_COUNT, num);
                        break;
                    }
                    case 'x': {
                        int num = this.nextUnsignedInt();
                        if (num < 0) {
                            expr = new Expr(Expr.Type.IS_IN_RING);
                            switch (this.peek()) {
                                case '{': {
                                    expr.setPrimitive(Expr.Type.RING_BOND_COUNT, 0);
                                    if (this.parseRange(expr)) break;
                                    return false;
                                }
                                case '>': {
                                    expr.setPrimitive(Expr.Type.RING_BOND_COUNT, 0);
                                    if (this.parseGt(expr)) break;
                                    return false;
                                }
                                case '<': {
                                    expr.setPrimitive(Expr.Type.RING_BOND_COUNT, 0);
                                    if (this.parseLt(expr)) break;
                                    return false;
                                }
                            }
                            break;
                        }
                        if (num == 0) {
                            expr = new Expr(Expr.Type.IS_IN_CHAIN);
                            break;
                        }
                        if (num > 1) {
                            expr = new Expr(Expr.Type.RING_BOND_COUNT, num);
                            break;
                        }
                        return false;
                    }
                    case '#': {
                        int num = this.nextUnsignedInt();
                        if (num < 0) {
                            if (this.isFlavor(13)) {
                                switch (this.next()) {
                                    case 'X': {
                                        expr = new Expr(Expr.Type.IS_HETERO);
                                        break block0;
                                    }
                                    case 'G': {
                                        num = this.nextUnsignedInt();
                                        if (num <= 0 || num > 18) {
                                            return false;
                                        }
                                        expr = new Expr(Expr.Type.PERIODIC_GROUP, num);
                                        break block0;
                                    }
                                }
                                return false;
                            }
                            return false;
                        }
                        expr = new Expr(Expr.Type.ELEMENT, num);
                        break;
                    }
                    case '^': {
                        if (!this.isFlavor(81)) {
                            return false;
                        }
                        int num = this.nextUnsignedInt();
                        if (num <= 0 || num > 8) {
                            return false;
                        }
                        expr = new Expr(Expr.Type.HYBRIDISATION_NUMBER, num);
                        break;
                    }
                    case 'i': {
                        if (!this.isFlavor(13)) {
                            return false;
                        }
                        int num = this.nextUnsignedInt();
                        if (num <= 0 || num > 8) {
                            expr = new Expr(Expr.Type.UNSATURATED);
                            break;
                        }
                        expr = new Expr(Expr.Type.INSATURATION, num);
                        break;
                    }
                    case 'z': {
                        if (!this.isFlavor(4)) {
                            return false;
                        }
                        int num = this.nextUnsignedInt();
                        if (num < 0) {
                            expr = new Expr(Expr.Type.HAS_HETERO_SUBSTITUENT);
                            break;
                        }
                        if (num == 0) {
                            expr = new Expr(Expr.Type.HAS_HETERO_SUBSTITUENT).negate();
                            break;
                        }
                        expr = new Expr(Expr.Type.HETERO_SUBSTITUENT_COUNT, num);
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.unget();
                        int num = this.nextUnsignedInt();
                        if (num == 0) {
                            expr = new Expr(Expr.Type.HAS_UNSPEC_ISOTOPE);
                            break;
                        }
                        expr = new Expr(Expr.Type.ISOTOPE, num);
                        break;
                    }
                    case '-': {
                        int num = this.nextUnsignedInt();
                        if (num < 0) {
                            num = 1;
                            while (this.peek() == '-') {
                                ++num;
                                ++this.pos;
                            }
                        }
                        expr = new Expr(Expr.Type.FORMAL_CHARGE, -num);
                        break;
                    }
                    case '+': {
                        int num = this.nextUnsignedInt();
                        if (num < 0) {
                            num = 1;
                            while (this.peek() == '+') {
                                ++num;
                                ++this.pos;
                            }
                        }
                        expr = new Expr(Expr.Type.FORMAL_CHARGE, num);
                        break;
                    }
                    case '@': {
                        int num = 1;
                        if (this.peek() == '@') {
                            this.next();
                            num = 2;
                        }
                        expr = new Expr(Expr.Type.STEREOCHEMISTRY, num);
                        if (this.peek() == '?') {
                            this.next();
                            expr.or(new Expr(Expr.Type.STEREOCHEMISTRY, 0));
                        }
                        this.astereo.add(atom);
                        break;
                    }
                    case '&': {
                        if (dest.type() == Expr.Type.NONE) {
                            return false;
                        }
                        expr = new Expr(Expr.Type.NONE);
                        if (this.parseAtomExpr(atom, expr, '&')) break;
                        return false;
                    }
                    case ';': {
                        if (dest.type() == Expr.Type.NONE) {
                            return false;
                        }
                        if (this.hasPrecedence(lastOp, ';')) {
                            return true;
                        }
                        expr = new Expr(Expr.Type.NONE);
                        if (this.parseAtomExpr(atom, expr, ';')) break;
                        return false;
                    }
                    case ',': {
                        if (dest.type() == Expr.Type.NONE) {
                            return false;
                        }
                        if (this.hasPrecedence(lastOp, ',')) {
                            return true;
                        }
                        expr = new Expr(Expr.Type.NONE);
                        if (!this.parseAtomExpr(atom, expr, ',')) {
                            return false;
                        }
                        currOp = 44;
                        break;
                    }
                    case '!': {
                        expr = new Expr(Expr.Type.NONE);
                        if (!this.parseAtomExpr(atom, expr, '!')) {
                            return false;
                        }
                        expr.negate();
                        break;
                    }
                    case '$': {
                        int beg;
                        if (this.next() != '(') {
                            return false;
                        }
                        int end = beg = this.pos;
                        int depth = 1;
                        while (end < this.str.length()) {
                            switch (this.str.charAt(end++)) {
                                case '(': {
                                    ++depth;
                                    break;
                                }
                                case ')': {
                                    --depth;
                                }
                            }
                            if (depth != 0) continue;
                        }
                        if (end == this.str.length()) {
                            return false;
                        }
                        QueryAtomContainer submol = new QueryAtomContainer(this.mol.getBuilder());
                        if (!new Parser(submol, this.str.substring(beg, end - 1), this.flav).parse()) {
                            return false;
                        }
                        expr = submol.getAtomCount() == 1 ? ((QueryAtom)AtomRef.deref(submol.getAtom(0))).getExpression() : new Expr(Expr.Type.RECURSIVE, submol);
                        this.pos = end;
                        break;
                    }
                    case ':': {
                        if (expr == null) {
                            return false;
                        }
                        int num = this.nextUnsignedInt();
                        if (num < 0) {
                            return false;
                        }
                        if (num != 0) {
                            atom.setProperty("cdk:AtomAtomMapping", num);
                        }
                        if (lastOp != '\u0000') {
                            return this.peek() == ']';
                        }
                        return this.next() == ']';
                    }
                    case ']': {
                        if (dest == null || dest.type() == Expr.Type.NONE) {
                            return false;
                        }
                        if (lastOp != '\u0000') {
                            this.unget();
                        }
                        return true;
                    }
                    default: {
                        return false;
                    }
                }
                if (dest.type() == Expr.Type.NONE) {
                    dest.set(expr);
                    if (lastOp != '!') continue;
                    return true;
                }
                switch (currOp) {
                    case 38: {
                        dest.and(expr);
                        break;
                    }
                    case 44: {
                        dest.or(expr);
                    }
                }
            }
        }

        private boolean isFlavor(int flav) {
            return (this.flav & flav) != 0;
        }

        private boolean parseBondExpr(Expr dest, IBond bond, char lastOp) {
            while (true) {
                Expr expr;
                int currOp = 38;
                switch (this.next()) {
                    case '-': {
                        expr = new Expr(Expr.Type.ALIPHATIC_ORDER, 1);
                        break;
                    }
                    case '=': {
                        expr = new Expr(Expr.Type.ALIPHATIC_ORDER, 2);
                        break;
                    }
                    case '#': {
                        expr = new Expr(Expr.Type.ALIPHATIC_ORDER, 3);
                        break;
                    }
                    case '$': {
                        expr = new Expr(Expr.Type.ALIPHATIC_ORDER, 4);
                        break;
                    }
                    case ':': {
                        expr = new Expr(Expr.Type.IS_AROMATIC);
                        break;
                    }
                    case '~': {
                        expr = new Expr(Expr.Type.TRUE);
                        break;
                    }
                    case '@': {
                        expr = new Expr(Expr.Type.IS_IN_RING);
                        break;
                    }
                    case '&': {
                        if (dest.type() == Expr.Type.NONE) {
                            return false;
                        }
                        expr = new Expr(Expr.Type.NONE);
                        if (this.parseBondExpr(expr, bond, '&')) break;
                        return false;
                    }
                    case ';': {
                        if (dest.type() == Expr.Type.NONE) {
                            return false;
                        }
                        if (this.hasPrecedence(lastOp, ';')) {
                            return true;
                        }
                        expr = new Expr(Expr.Type.NONE);
                        if (this.parseBondExpr(expr, bond, ';')) break;
                        return false;
                    }
                    case ',': {
                        if (dest.type() == Expr.Type.NONE) {
                            return false;
                        }
                        if (this.hasPrecedence(lastOp, ',')) {
                            return true;
                        }
                        expr = new Expr(Expr.Type.NONE);
                        if (!this.parseBondExpr(expr, bond, ',')) {
                            return false;
                        }
                        currOp = 44;
                        break;
                    }
                    case '!': {
                        expr = new Expr(Expr.Type.NONE);
                        if (!this.parseBondExpr(expr, bond, '!')) {
                            return false;
                        }
                        expr.negate();
                        break;
                    }
                    case '/': {
                        expr = new Expr(Expr.Type.STEREOCHEMISTRY, 47);
                        if (this.peek() == '?') {
                            this.next();
                            expr.or(new Expr(Expr.Type.STEREOCHEMISTRY, 63));
                        }
                        this.bstereo.add(bond);
                        break;
                    }
                    case '\\': {
                        expr = new Expr(Expr.Type.STEREOCHEMISTRY, 92);
                        if (this.peek() == '?') {
                            this.next();
                            expr.or(new Expr(Expr.Type.STEREOCHEMISTRY, 63));
                        }
                        this.bstereo.add(bond);
                        break;
                    }
                    default: {
                        --this.pos;
                        return dest.type() != Expr.Type.NONE;
                    }
                }
                if (dest.type() == Expr.Type.NONE) {
                    dest.set(expr);
                    if (lastOp != '!') continue;
                    return true;
                }
                switch (currOp) {
                    case 38: {
                        dest.and(expr);
                        break;
                    }
                    case 44: {
                        dest.or(expr);
                    }
                }
            }
        }

        private void unget() {
            if (this.pos <= this.str.length()) {
                --this.pos;
            }
        }

        private boolean hasPrecedence(char lastOp, char currOp) {
            if (lastOp > '\u0000' && currOp > lastOp) {
                this.unget();
                return true;
            }
            return false;
        }

        private boolean parseAtomExpr() {
            QueryAtom atom = new QueryAtom(this.mol.getBuilder());
            atom.setProperty("cdk.smarts.iscomplex", true);
            Expr expr = new Expr(Expr.Type.NONE);
            atom.setExpression(expr);
            if (!this.parseExplicitHydrogen(atom, expr) && !this.parseAtomExpr(atom, expr, '\u0000')) {
                this.error = "Invalid atom expression";
                return false;
            }
            this.append(atom);
            return true;
        }

        boolean parseBondExpr() {
            this.bond = new QueryBond(this.mol.getBuilder());
            this.bond.setExpression(new Expr(Expr.Type.NONE));
            if (!this.parseBondExpr(this.bond.getExpression(), this.bond, '\u0000')) {
                this.error = "Invalid bond expression";
                return false;
            }
            return true;
        }

        void newFragment() {
            this.prev = null;
        }

        boolean begComponentGroup() {
            this.curComponentId = ++this.numComponents;
            return true;
        }

        boolean endComponentGroup() {
            if (this.curComponentId == 0) {
                this.error = "Closing unopened component grouping";
                return false;
            }
            this.curComponentId = 0;
            return true;
        }

        boolean openBranch() {
            if (this.prev == null || this.bond != null) {
                this.error = "No previous atom to open branch";
                return false;
            }
            this.stack.push(this.prev);
            return true;
        }

        boolean closeBranch() {
            if (this.stack.isEmpty() || this.bond != null) {
                this.error = "Closing unopened branch";
                return false;
            }
            this.prev = this.stack.pop();
            return true;
        }

        boolean openRing(int rnum) {
            if (this.prev == null) {
                this.error = "Cannot open ring, no previous atom";
                return false;
            }
            if (this.bond == null) {
                this.bond = new QueryBond(null);
                this.bond.setExpression(null);
            }
            this.bond.setAtom(this.prev, 0);
            this.rings[rnum] = this.addBond(this.prev, this.bond);
            ++this.numRingOpens;
            this.bond = null;
            return true;
        }

        boolean closeRing(int rnum) {
            IBond bond = this.rings[rnum];
            this.rings[rnum] = null;
            --this.numRingOpens;
            Expr openExpr = ((QueryBond)BondRef.deref(bond)).getExpression();
            if (this.bond != null) {
                Expr closeExpr = ((QueryBond)BondRef.deref(this.bond)).getExpression();
                if (openExpr == null) {
                    ((QueryBond)BondRef.deref(bond)).setExpression(closeExpr);
                } else if (!openExpr.equals(closeExpr)) {
                    this.error = "Open/close expressions are not equivalent";
                    return false;
                }
                this.bond = null;
            } else if (openExpr == null) {
                ((QueryBond)BondRef.deref(bond)).setExpression(new Expr(Expr.Type.SINGLE_OR_AROMATIC));
            }
            bond.setAtom(this.prev, 1);
            this.addBond(this.prev, bond);
            return true;
        }

        boolean ringClosure(int rnum) {
            if (this.rings[rnum] == null) {
                return this.openRing(rnum);
            }
            return this.closeRing(rnum);
        }

        void swap(Object[] obj, int i, int j) {
            Object tmp = obj[i];
            obj[i] = obj[j];
            obj[j] = tmp;
        }

        boolean hasAliphaticDoubleBond(Expr expr) {
            block5: while (true) {
                switch (expr.type()) {
                    case NOT: {
                        expr = expr.left();
                        continue block5;
                    }
                    case AND: 
                    case OR: {
                        if (this.hasAliphaticDoubleBond(expr.left())) {
                            return true;
                        }
                        expr = expr.right();
                        continue block5;
                    }
                    case ALIPHATIC_ORDER: {
                        return expr.value() == 2;
                    }
                }
                break;
            }
            return false;
        }

        void flip(Expr expr) {
            while (true) {
                switch (expr.type()) {
                    case STEREOCHEMISTRY: {
                        if (expr.value() != 0) {
                            expr.setPrimitive(expr.type(), expr.value() ^ 3);
                        }
                        return;
                    }
                    case AND: 
                    case OR: {
                        this.flip(expr.left());
                        expr = expr.right();
                        break;
                    }
                    case NOT: {
                        expr = expr.left();
                    }
                }
            }
        }

        Expr determineBondStereo(Expr left, Expr right) {
            switch (left.type()) {
                case AND: 
                case OR: {
                    Expr sub1 = this.determineBondStereo(left.left(), right);
                    Expr sub2 = this.determineBondStereo(left.right(), right);
                    if (sub1 != null && sub2 != null) {
                        return new Expr(left.type(), sub1, sub2);
                    }
                    if (sub1 != null) {
                        return sub1;
                    }
                    if (sub2 != null) {
                        return sub2;
                    }
                    return null;
                }
                case NOT: {
                    Expr sub1 = this.determineBondStereo(left.left(), right);
                    if (sub1 == null) break;
                    return sub1.negate();
                }
                case STEREOCHEMISTRY: {
                    switch (right.type()) {
                        case AND: 
                        case OR: {
                            Expr sub1 = this.determineBondStereo(left, right.left());
                            Expr sub2 = this.determineBondStereo(left, right.right());
                            if (sub1 != null && sub2 != null) {
                                return new Expr(right.type(), sub1, sub2);
                            }
                            if (sub1 != null) {
                                return sub1;
                            }
                            if (sub2 != null) {
                                return sub2;
                            }
                            return null;
                        }
                        case NOT: {
                            Expr sub1 = this.determineBondStereo(left, right.left());
                            if (sub1 != null) {
                                return sub1.negate();
                            }
                            return null;
                        }
                        case STEREOCHEMISTRY: {
                            if (left.value() == 63 || right.value() == 63) {
                                return new Expr(Expr.Type.STEREOCHEMISTRY, 0);
                            }
                            if (left.value() == right.value()) {
                                return new Expr(Expr.Type.STEREOCHEMISTRY, 2);
                            }
                            return new Expr(Expr.Type.STEREOCHEMISTRY, 1);
                        }
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
            return null;
        }

        boolean finish() {
            if (this.numRingOpens != 0 || this.curComponentId != 0 || !this.stack.isEmpty() || this.bond != null) {
                this.error = "Unclosed ring, component group, or branch";
                return false;
            }
            if (this.role != ReactionRole.None) {
                if (this.role != ReactionRole.Agent) {
                    this.error = "Missing '>' to complete reaction";
                    return false;
                }
                this.markReactionRoles();
                for (IAtom atom : this.mol.atoms()) {
                    ReactionRole role = (ReactionRole)((Object)atom.getProperty("cdk:ReactionRole"));
                    ((QueryAtom)AtomRef.deref(atom)).getExpression().and(new Expr(Expr.Type.REACTION_ROLE, role.ordinal()));
                }
            }
            for (IAtom atom : this.astereo) {
                LocalNbrs nbrinfo = this.local.get(atom);
                if (nbrinfo == null) continue;
                Object[] ligands = new IAtom[4];
                int degree = 0;
                for (IBond bond : nbrinfo.bonds) {
                    ligands[degree++] = bond.getOther(atom);
                }
                if (degree == 3) {
                    ligands[degree++] = atom;
                    if (nbrinfo.isFirst) {
                        this.swap(ligands, 2, 3);
                    }
                }
                if (degree != 4) continue;
                this.mol.addStereoElement(new TetrahedralChirality(atom, (IAtom[])ligands, 0));
            }
            if (!this.bstereo.isEmpty()) {
                Expr expr;
                for (IBond bond : this.mol.bonds()) {
                    Expr rightExpr;
                    Expr leftExpr;
                    Expr bexpr;
                    expr = ((QueryBond)BondRef.deref(bond)).getExpression();
                    if (!this.hasAliphaticDoubleBond(expr)) continue;
                    IBond left = null;
                    IBond right = null;
                    LocalNbrs bBonds = this.local.get(bond.getBegin());
                    LocalNbrs eBonds = this.local.get(bond.getEnd());
                    if (bBonds == null || eBonds == null) continue;
                    for (IBond b : bBonds.bonds) {
                        if (!this.bstereo.contains(b)) continue;
                        left = b;
                    }
                    for (IBond b : eBonds.bonds) {
                        if (!this.bstereo.contains(b)) continue;
                        right = b;
                    }
                    if (left == null || right == null || (bexpr = this.determineBondStereo(leftExpr = ((QueryBond)BondRef.deref(left)).getExpression(), rightExpr = ((QueryBond)BondRef.deref(right)).getExpression())) == null) continue;
                    expr.and(bexpr);
                    if (left.getBegin().equals(bond.getBegin()) != right.getBegin().equals(bond.getEnd())) {
                        this.flip(bexpr);
                    }
                    this.mol.addStereoElement(new DoubleBondStereochemistry(bond, new IBond[]{left, right}, 0));
                }
                for (IBond bond : this.bstereo) {
                    expr = ((QueryBond)BondRef.deref(bond)).getExpression();
                    if ((expr = Smarts.strip(expr, Expr.Type.STEREOCHEMISTRY)) == null) {
                        expr = new Expr(Expr.Type.SINGLE_OR_AROMATIC);
                    } else {
                        expr.and(new Expr(Expr.Type.SINGLE_OR_AROMATIC));
                    }
                    ((QueryBond)bond).setExpression(expr);
                }
            }
            return true;
        }

        void append(IAtom atom) {
            if (this.curComponentId != 0) {
                atom.setProperty("cdk:ReactionGroup", this.curComponentId);
            }
            this.mol.addAtom(atom);
            if (this.prev != null) {
                if (this.bond == null) {
                    this.bond = new QueryBond(this.mol.getBuilder());
                    this.bond.setExpression(new Expr(Expr.Type.SINGLE_OR_AROMATIC));
                }
                this.bond.setAtom(this.prev, 0);
                this.bond.setAtom(atom, 1);
                this.addBond(this.prev, this.bond);
                this.addBond(atom, this.bond);
            } else {
                this.local.put(atom, new LocalNbrs(true));
            }
            this.prev = atom;
            this.bond = null;
        }

        void append(Expr expr) {
            QueryAtom atom = new QueryAtom(this.mol.getBuilder());
            atom.setExpression(expr);
            this.append(atom);
        }

        private char peek() {
            return this.pos < this.str.length() ? this.str.charAt(this.pos) : (char)'\u0000';
        }

        private char next() {
            if (this.pos < this.str.length()) {
                return this.str.charAt(this.pos++);
            }
            ++this.pos;
            return '\u0000';
        }

        private static boolean isDigit(char c) {
            return c >= '0' && c <= '9';
        }

        /*
         * Unable to fully structure code
         */
        public boolean parse() {
            block29: while (this.pos < this.str.length()) {
                switch (this.str.charAt(this.pos++)) {
                    case '*': {
                        this.append(new Expr(Expr.Type.TRUE));
                        continue block29;
                    }
                    case 'A': {
                        this.append(new Expr(Expr.Type.IS_ALIPHATIC));
                        continue block29;
                    }
                    case 'B': {
                        if (this.peek() == 'r') {
                            this.next();
                            this.append(new Expr(Expr.Type.ELEMENT, Elements.BROMINE.getAtomicNumber()));
                            continue block29;
                        }
                        this.append(new Expr(Expr.Type.ALIPHATIC_ELEMENT, Elements.BORON.getAtomicNumber()));
                        continue block29;
                    }
                    case 'C': {
                        if (this.peek() == 'l') {
                            this.next();
                            this.append(new Expr(Expr.Type.ELEMENT, Elements.CHLORINE.getAtomicNumber()));
                            continue block29;
                        }
                        this.append(new Expr(Expr.Type.ALIPHATIC_ELEMENT, Elements.CARBON.getAtomicNumber()));
                        continue block29;
                    }
                    case 'N': {
                        this.append(new Expr(Expr.Type.ALIPHATIC_ELEMENT, Elements.NITROGEN.getAtomicNumber()));
                        continue block29;
                    }
                    case 'O': {
                        this.append(new Expr(Expr.Type.ALIPHATIC_ELEMENT, Elements.OXYGEN.getAtomicNumber()));
                        continue block29;
                    }
                    case 'P': {
                        this.append(new Expr(Expr.Type.ALIPHATIC_ELEMENT, Elements.PHOSPHORUS.getAtomicNumber()));
                        continue block29;
                    }
                    case 'S': {
                        this.append(new Expr(Expr.Type.ALIPHATIC_ELEMENT, Elements.SULFUR.getAtomicNumber()));
                        continue block29;
                    }
                    case 'F': {
                        this.append(new Expr(Expr.Type.ELEMENT, Elements.FLUORINE.getAtomicNumber()));
                        continue block29;
                    }
                    case 'I': {
                        this.append(new Expr(Expr.Type.ELEMENT, Elements.IODINE.getAtomicNumber()));
                        continue block29;
                    }
                    case 'a': {
                        this.append(new Expr(Expr.Type.IS_AROMATIC));
                        continue block29;
                    }
                    case 'b': {
                        this.append(new Expr(Expr.Type.AROMATIC_ELEMENT, Elements.BORON.getAtomicNumber()));
                        continue block29;
                    }
                    case 'c': {
                        this.append(new Expr(Expr.Type.AROMATIC_ELEMENT, Elements.CARBON.getAtomicNumber()));
                        continue block29;
                    }
                    case 'n': {
                        this.append(new Expr(Expr.Type.AROMATIC_ELEMENT, Elements.NITROGEN.getAtomicNumber()));
                        continue block29;
                    }
                    case 'o': {
                        this.append(new Expr(Expr.Type.AROMATIC_ELEMENT, Elements.OXYGEN.getAtomicNumber()));
                        continue block29;
                    }
                    case 'p': {
                        this.append(new Expr(Expr.Type.AROMATIC_ELEMENT, Elements.PHOSPHORUS.getAtomicNumber()));
                        continue block29;
                    }
                    case 's': {
                        this.append(new Expr(Expr.Type.AROMATIC_ELEMENT, Elements.SULFUR.getAtomicNumber()));
                        continue block29;
                    }
                    case '[': {
                        if (this.parseAtomExpr()) continue block29;
                        return false;
                    }
                    case '.': {
                        this.newFragment();
                        continue block29;
                    }
                    case '!': 
                    case '#': 
                    case '$': 
                    case '-': 
                    case '/': 
                    case ':': 
                    case '=': 
                    case '@': 
                    case '\\': 
                    case '~': {
                        if (this.prev == null) {
                            return false;
                        }
                        this.unget();
                        if (this.parseBondExpr()) continue block29;
                        return false;
                    }
                    case '(': {
                        if (!(this.prev == null ? this.begComponentGroup() == false : this.openBranch() == false)) continue block29;
                        return false;
                    }
                    case ')': {
                        if (!(this.stack.isEmpty() != false ? this.endComponentGroup() == false : this.closeBranch() == false)) continue block29;
                        return false;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        if (this.ringClosure(this.str.charAt(this.pos - 1) - 48)) continue block29;
                        return false;
                    }
                    case '%': {
                        if (Parser.isDigit(this.peek())) {
                            rnum = this.str.charAt(this.pos++) - 48;
                            if (Parser.isDigit(this.peek())) {
                                this.ringClosure(10 * rnum + (this.str.charAt(this.pos++) - 48));
                                continue block29;
                            }
                            return false;
                        }
                        return false;
                    }
                    case '>': {
                        if (!this.stack.isEmpty()) {
                            return false;
                        }
                        if (!this.markReactionRoles()) {
                            return false;
                        }
                        this.prev = null;
                        continue block29;
                    }
lbl101:
                    // 2 sources

                    case '\t': 
                    case ' ': {
                        if (!this.isTerminalChar(this.next())) ** GOTO lbl101
                        this.mol.setTitle(this.str.substring(this.pos - 1));
                        continue block29;
                    }
                    case '\u0000': 
                    case '\n': 
                    case '\r': {
                        return this.finish();
                    }
                }
                this.error = "Unexpected character";
                return false;
            }
            return this.finish();
        }

        private boolean markReactionRoles() {
            IAtom atom;
            if (this.role == ReactionRole.None) {
                this.role = ReactionRole.Reactant;
            } else if (this.role == ReactionRole.Reactant) {
                this.role = ReactionRole.Agent;
            } else if (this.role == ReactionRole.Agent) {
                this.role = ReactionRole.Product;
            } else {
                this.error = "To many '>' in reaction";
            }
            int idx = this.mol.getAtomCount() - 1;
            while (idx >= 0 && (atom = this.mol.getAtom(idx--)).getProperty("cdk:ReactionRole") == null) {
                atom.setProperty("cdk:ReactionRole", (Object)this.role);
            }
            return true;
        }

        private boolean isTerminalChar(char c) {
            switch (c) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    return true;
                }
            }
            return false;
        }
    }

    private static final class Generator {
        private final IAtomContainer mol;
        private final Map<IAtom, List<IBond>> nbrs;
        private final Set<IAtom> avisit = new HashSet<IAtom>();
        private final Set<IBond> rbonds = new HashSet<IBond>();
        private final boolean[] rvisit = new boolean[100];
        private final Map<IBond, Integer> rnums = new HashMap<IBond, Integer>();
        private final Map<IBond, String> bdirs = new HashMap<IBond, String>();
        private final ILoggingTool logger = LoggingToolFactory.createLoggingTool(Generator.class);
        private Map<IChemObject, IStereoElement> ses;
        private Set<IAtom> adjToDb;
        private Set<IBond> bvisit;

        public Generator(IAtomContainer mol) {
            this.mol = mol;
            this.nbrs = new HashMap<IAtom, List<IBond>>();
        }

        private int nextRingNum() {
            int rnum;
            for (rnum = 1; rnum < this.rvisit.length && this.rvisit[rnum]; ++rnum) {
            }
            if (rnum < this.rvisit.length) {
                this.rvisit[rnum] = true;
                return rnum;
            }
            throw new IllegalStateException("Not enough ring numbers!");
        }

        private void markRings(IAtom atom, IBond prev) {
            this.avisit.add(atom);
            List<IBond> bonds = this.mol.getConnectedBondsList(atom);
            this.nbrs.put(atom, bonds);
            for (IBond bond : bonds) {
                if (bond == prev) continue;
                IAtom other = bond.getOther(atom);
                if (this.avisit.contains(other)) {
                    this.rbonds.add(bond);
                    continue;
                }
                this.markRings(other, bond);
            }
        }

        private IBond chooseBondToDir(IAtom atom, IBond db, Set<IAtom> adjToDb) {
            IBond choice = null;
            for (IBond bond : this.nbrs.get(atom)) {
                if (bond == db) continue;
                if (adjToDb.contains(bond.getOther(atom))) {
                    return bond;
                }
                choice = bond;
            }
            return choice;
        }

        private void setBondDir(IAtom beg, IBond bond, String dir) {
            if (bond.getEnd().equals(beg)) {
                this.bdirs.put(bond, dir);
            } else if (bond.getBegin().equals(beg)) {
                if (dir.equals(Smarts.BSTEREO_UP)) {
                    dir = Smarts.BSTEREO_DN;
                } else if (dir.equals(Smarts.BSTEREO_DN)) {
                    dir = Smarts.BSTEREO_UP;
                } else if (dir.equals(Smarts.BSTEREO_UPU)) {
                    dir = Smarts.BSTEREO_DNU;
                } else if (dir.equals(Smarts.BSTEREO_DNU)) {
                    dir = Smarts.BSTEREO_UPU;
                }
                this.bdirs.put(bond, dir);
            } else {
                throw new IllegalArgumentException();
            }
        }

        private void setBondDirs(IAtomContainer mol) {
            this.adjToDb = new HashSet<IAtom>();
            this.ses = new HashMap<IChemObject, IStereoElement>();
            this.bvisit = new HashSet<IBond>();
            for (IStereoElement se : mol.stereoElements()) {
                if (se.getConfigClass() != 8448) continue;
                this.ses.put((IChemObject)se.getFocus(), se);
            }
            for (IBond bond : mol.bonds()) {
                Expr expr = ((QueryBond)BondRef.deref(bond)).getExpression();
                int flags = Smarts.getBondStereoFlag(expr);
                if (flags == 7) continue;
                this.adjToDb.add(bond.getBegin());
                this.adjToDb.add(bond.getEnd());
            }
            for (IBond bond : mol.bonds()) {
                if (this.bvisit.contains(bond)) continue;
                this.propagateBondStereo(bond, false);
            }
            for (IBond bond : mol.bonds()) {
                if (this.bvisit.contains(bond)) continue;
                this.propagateBondStereo(bond, true);
            }
        }

        private void propagateBondStereo(IBond bond, boolean all) {
            Expr expr = ((QueryBond)BondRef.deref(bond)).getExpression();
            int flags = Smarts.getBondStereoFlag(expr);
            if (flags != 7) {
                if (!all && flags != 4 && flags != 2) {
                    return;
                }
                this.bvisit.add(bond);
                IAtom beg = bond.getBegin();
                IAtom end = bond.getEnd();
                IBond bBond = this.chooseBondToDir(beg, bond, this.adjToDb);
                IBond eBond = this.chooseBondToDir(end, bond, this.adjToDb);
                if (bBond == null || eBond == null) {
                    this.logger.warn("Too few bonds to encode bond stereochemistry in SMARTS");
                    return;
                }
                IStereoElement se = this.ses.get(bond);
                if (se != null && se.getCarriers().contains(bBond) != se.getCarriers().contains(eBond)) {
                    switch (flags) {
                        case 4: {
                            flags = 2;
                            break;
                        }
                        case 2: {
                            flags = 4;
                            break;
                        }
                        case 5: {
                            flags = 3;
                            break;
                        }
                        case 3: {
                            flags = 5;
                        }
                    }
                }
                String bDir = this.bdirs.get(bBond);
                String eDir = this.bdirs.get(eBond);
                if (bDir == null && eDir == null) {
                    switch (flags) {
                        case 4: {
                            this.setBondDir(beg, bBond, Smarts.BSTEREO_UP);
                            this.setBondDir(end, eBond, Smarts.BSTEREO_UP);
                            break;
                        }
                        case 2: {
                            this.setBondDir(beg, bBond, Smarts.BSTEREO_UP);
                            this.setBondDir(end, eBond, Smarts.BSTEREO_DN);
                            break;
                        }
                        case 6: {
                            this.setBondDir(beg, bBond, Smarts.BSTEREO_UP);
                            this.setBondDir(end, eBond, Smarts.BSTEREO_EITHER);
                            break;
                        }
                        case 5: {
                            this.setBondDir(beg, bBond, Smarts.BSTEREO_UP);
                            this.setBondDir(end, eBond, Smarts.BSTEREO_UPU);
                            break;
                        }
                        case 3: {
                            this.setBondDir(beg, bBond, Smarts.BSTEREO_UP);
                            this.setBondDir(end, eBond, Smarts.BSTEREO_DNU);
                            break;
                        }
                        case 1: {
                            this.setBondDir(beg, bBond, Smarts.BSTEREO_UP);
                            this.setBondDir(end, eBond, Smarts.BSTEREO_NEITHER);
                        }
                    }
                } else if (eDir == null) {
                    switch (flags) {
                        case 4: {
                            if (bDir.equals(Smarts.BSTEREO_UP)) {
                                this.setBondDir(end, eBond, Smarts.BSTEREO_UP);
                                break;
                            }
                            if (bDir.equals(Smarts.BSTEREO_DN)) {
                                this.setBondDir(end, eBond, Smarts.BSTEREO_DN);
                                break;
                            }
                            this.logger.warn("Could not encode bond stereochemistry");
                            break;
                        }
                        case 2: {
                            if (bDir.equals(Smarts.BSTEREO_UP)) {
                                this.setBondDir(end, eBond, Smarts.BSTEREO_DN);
                                break;
                            }
                            if (bDir.equals(Smarts.BSTEREO_DN)) {
                                this.setBondDir(end, eBond, Smarts.BSTEREO_UP);
                                break;
                            }
                            this.logger.warn("Could not encode bond stereochemistry");
                            break;
                        }
                        case 6: {
                            if (bDir.equals(Smarts.BSTEREO_UP) || bDir.equals(Smarts.BSTEREO_DN)) {
                                this.setBondDir(end, eBond, Smarts.BSTEREO_EITHER);
                                break;
                            }
                            if (!bDir.equals(Smarts.BSTEREO_NEITHER)) {
                                this.setBondDir(end, bBond, Smarts.BSTEREO_UP);
                                break;
                            }
                            this.logger.warn("Could not encode bond stereochemistry");
                            break;
                        }
                        case 5: {
                            if (bDir.equals(Smarts.BSTEREO_UP)) {
                                this.setBondDir(end, eBond, Smarts.BSTEREO_UPU);
                                break;
                            }
                            if (bDir.equals(Smarts.BSTEREO_DN)) {
                                this.setBondDir(end, eBond, Smarts.BSTEREO_DNU);
                                break;
                            }
                            this.logger.warn("Could not encode bond stereochemistry");
                            break;
                        }
                        case 3: {
                            if (bDir.equals(Smarts.BSTEREO_UP)) {
                                this.setBondDir(end, eBond, Smarts.BSTEREO_DNU);
                                break;
                            }
                            if (bDir.equals(Smarts.BSTEREO_DN)) {
                                this.setBondDir(end, eBond, Smarts.BSTEREO_UPU);
                                break;
                            }
                            this.logger.warn("Could not encode bond stereochemistry");
                            break;
                        }
                        case 1: {
                            if (bDir.equals(Smarts.BSTEREO_NEITHER)) {
                                this.setBondDir(end, eBond, Smarts.BSTEREO_UP);
                                break;
                            }
                            this.setBondDir(end, eBond, Smarts.BSTEREO_NEITHER);
                        }
                    }
                } else if (bDir == null) {
                    switch (flags) {
                        case 4: {
                            if (eDir.equals(Smarts.BSTEREO_UP)) {
                                this.setBondDir(beg, bBond, Smarts.BSTEREO_UP);
                                break;
                            }
                            if (eDir.equals(Smarts.BSTEREO_DN)) {
                                this.setBondDir(beg, bBond, Smarts.BSTEREO_DN);
                                break;
                            }
                            this.logger.warn("Could not encode bond stereochemistry");
                            break;
                        }
                        case 2: {
                            if (eDir.equals(Smarts.BSTEREO_UP)) {
                                this.setBondDir(beg, bBond, Smarts.BSTEREO_DN);
                                break;
                            }
                            if (eDir.equals(Smarts.BSTEREO_DN)) {
                                this.setBondDir(beg, bBond, Smarts.BSTEREO_UP);
                                break;
                            }
                            this.logger.warn("Could not encode bond stereochemistry");
                            break;
                        }
                        case 6: {
                            if (eDir.equals(Smarts.BSTEREO_UP) || eDir.equals(Smarts.BSTEREO_DN)) {
                                this.setBondDir(beg, bBond, Smarts.BSTEREO_EITHER);
                                break;
                            }
                            if (!eDir.equals(Smarts.BSTEREO_NEITHER)) {
                                this.setBondDir(beg, bBond, Smarts.BSTEREO_UP);
                                break;
                            }
                            this.logger.warn("Could not encode bond stereochemistry");
                            break;
                        }
                        case 5: {
                            if (eDir.equals(Smarts.BSTEREO_UP)) {
                                this.setBondDir(beg, bBond, Smarts.BSTEREO_UPU);
                                break;
                            }
                            if (eDir.equals(Smarts.BSTEREO_DN)) {
                                this.setBondDir(beg, bBond, Smarts.BSTEREO_DNU);
                                break;
                            }
                            this.logger.warn("Could not encode bond stereochemistry");
                            break;
                        }
                        case 3: {
                            if (eDir.equals(Smarts.BSTEREO_UP)) {
                                this.setBondDir(beg, bBond, Smarts.BSTEREO_DNU);
                                break;
                            }
                            if (eDir.equals(Smarts.BSTEREO_DN)) {
                                this.setBondDir(beg, bBond, Smarts.BSTEREO_UPU);
                                break;
                            }
                            this.logger.warn("Could not encode bond stereochemistry");
                            break;
                        }
                        case 1: {
                            if (eDir.equals(Smarts.BSTEREO_NEITHER)) {
                                this.setBondDir(beg, bBond, Smarts.BSTEREO_UP);
                                break;
                            }
                            this.setBondDir(beg, bBond, Smarts.BSTEREO_NEITHER);
                        }
                    }
                } else {
                    this.logger.warn("Bond stereochemistry may be incorrect");
                }
                for (IBond bOther : this.nbrs.get(bBond.getOther(beg))) {
                    if (this.bvisit.contains(bOther)) continue;
                    this.propagateBondStereo(bOther, all);
                }
                for (IBond bOther : this.nbrs.get(eBond.getOther(end))) {
                    if (this.bvisit.contains(bOther)) continue;
                    this.propagateBondStereo(bOther, all);
                }
            }
        }

        private boolean isRingOpen(IBond bond) {
            return this.rbonds.contains(bond);
        }

        private boolean isRingClose(IBond bond) {
            return this.rnums.containsKey(bond);
        }

        private void sort(List<IBond> bonds, final IBond prev) {
            bonds.sort(new Comparator<IBond>(){

                @Override
                public int compare(IBond a, IBond b) {
                    if (a == prev) {
                        return -1;
                    }
                    if (b == prev) {
                        return 1;
                    }
                    if (this.isRingClose(a) && !this.isRingClose(b)) {
                        return -1;
                    }
                    if (!this.isRingClose(a) && this.isRingClose(b)) {
                        return 1;
                    }
                    if (this.isRingOpen(a) && !this.isRingOpen(b)) {
                        return -1;
                    }
                    if (!this.isRingOpen(a) && this.isRingOpen(b)) {
                        return 1;
                    }
                    return 0;
                }
            });
        }

        private void generateRecurAtom(StringBuilder sb, IAtom atom, Expr expr) {
            sb.append("$([");
            this.generateAtom(sb, atom, expr, false);
            sb.append("])");
        }

        private void generateAtom(StringBuilder sb, IAtom atom, Expr expr, boolean withDisjunction) {
            block0 : switch (expr.type()) {
                case TRUE: {
                    sb.append('*');
                    break;
                }
                case FALSE: {
                    sb.append("!*");
                    break;
                }
                case IS_AROMATIC: {
                    sb.append('a');
                    break;
                }
                case IS_ALIPHATIC: {
                    sb.append('A');
                    break;
                }
                case IS_IN_RING: {
                    sb.append('R');
                    break;
                }
                case IS_IN_CHAIN: {
                    sb.append("!R");
                    break;
                }
                case DEGREE: {
                    sb.append('D');
                    if (expr.value() == 1) break;
                    sb.append(expr.value());
                    break;
                }
                case TOTAL_H_COUNT: {
                    sb.append('H');
                    sb.append(expr.value());
                    break;
                }
                case HAS_IMPLICIT_HYDROGEN: {
                    sb.append('h');
                    break;
                }
                case IMPL_H_COUNT: {
                    sb.append('h').append(expr.value());
                    break;
                }
                case VALENCE: {
                    sb.append('v');
                    if (expr.value() == 1) break;
                    sb.append(expr.value());
                    break;
                }
                case TOTAL_DEGREE: {
                    sb.append('X');
                    if (expr.value() == 1) break;
                    sb.append(expr.value());
                    break;
                }
                case FORMAL_CHARGE: {
                    if (expr.value() == -1) {
                        sb.append('-');
                        break;
                    }
                    if (expr.value() == 1) {
                        sb.append('+');
                        break;
                    }
                    if (expr.value() == 0) {
                        sb.append('+').append('0');
                        break;
                    }
                    if (expr.value() < 0) {
                        sb.append(expr.value());
                        break;
                    }
                    sb.append('+').append(expr.value());
                    break;
                }
                case RING_BOND_COUNT: {
                    sb.append('x').append(expr.value());
                    break;
                }
                case RING_COUNT: {
                    sb.append('R').append(expr.value());
                    break;
                }
                case RING_SMALLEST: {
                    sb.append('r').append(expr.value());
                    break;
                }
                case HAS_ISOTOPE: {
                    sb.append("!0");
                    break;
                }
                case HAS_UNSPEC_ISOTOPE: {
                    sb.append("0");
                    break;
                }
                case ISOTOPE: {
                    sb.append(expr.value());
                    break;
                }
                case ELEMENT: {
                    switch (expr.value()) {
                        case 0: {
                            sb.append("#0");
                            break block0;
                        }
                        case 1: {
                            sb.append("#1");
                            break block0;
                        }
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 33: 
                        case 34: 
                        case 51: 
                        case 52: {
                            sb.append('#').append(expr.value());
                            break block0;
                        }
                    }
                    Elements elem = Elements.ofNumber(expr.value());
                    if (elem == Elements.Unknown) {
                        throw new IllegalArgumentException("No element with atomic number: " + expr.value());
                    }
                    if (expr.value() > Elements.RADON.getAtomicNumber()) {
                        sb.append('#').append(expr.value());
                        break;
                    }
                    sb.append(elem.symbol());
                    break;
                }
                case ALIPHATIC_ELEMENT: {
                    switch (expr.value()) {
                        case 0: {
                            sb.append("#0");
                            break block0;
                        }
                        case 1: {
                            sb.append("#1");
                            break block0;
                        }
                    }
                    Elements elem = Elements.ofNumber(expr.value());
                    if (elem == Elements.Unknown) {
                        throw new IllegalArgumentException("No element with atomic number: " + expr.value());
                    }
                    if (expr.value() > Elements.RADON.getAtomicNumber()) {
                        sb.append('#').append(expr.value());
                        break;
                    }
                    sb.append(elem.symbol());
                    break;
                }
                case AROMATIC_ELEMENT: {
                    switch (expr.value()) {
                        case 0: {
                            sb.append("#0");
                            break block0;
                        }
                        case 1: {
                            sb.append("#1");
                            break block0;
                        }
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 33: 
                        case 34: 
                        case 51: 
                        case 52: {
                            Elements elem = Elements.ofNumber(expr.value());
                            if (elem == Elements.Unknown) {
                                throw new IllegalArgumentException("No element with atomic number: " + expr.value());
                            }
                            sb.append(elem.symbol().toLowerCase());
                            break block0;
                        }
                    }
                    Elements elem = Elements.ofNumber(expr.value());
                    if (elem == Elements.Unknown) {
                        throw new IllegalArgumentException("No element with atomic number: " + expr.value());
                    }
                    if (expr.value() > Elements.RADON.getAtomicNumber()) {
                        sb.append('#').append(expr.value());
                        break;
                    }
                    sb.append(elem.symbol());
                    break;
                }
                case AND: {
                    boolean disjuncBelow;
                    if (expr.left().type() == Expr.Type.REACTION_ROLE) {
                        this.generateAtom(sb, atom, expr.right(), withDisjunction);
                        return;
                    }
                    if (expr.right().type() == Expr.Type.REACTION_ROLE) {
                        this.generateAtom(sb, atom, expr.left(), withDisjunction);
                        return;
                    }
                    boolean bl = disjuncBelow = Smarts.hasOr(expr.left()) || Smarts.hasOr(expr.right());
                    if (disjuncBelow) {
                        if (withDisjunction) {
                            if (Smarts.hasOr(expr.left())) {
                                this.generateRecurAtom(sb, atom, expr.left());
                            } else {
                                this.generateAtom(sb, atom, expr.left(), true);
                            }
                            int mark = sb.length();
                            if (Smarts.hasOr(expr.right())) {
                                this.generateRecurAtom(sb, atom, expr.right());
                            } else {
                                this.generateAtom(sb, atom, expr.right(), true);
                            }
                            Generator.maybeExplAnd(sb, mark);
                            break;
                        }
                        this.generateAtom(sb, atom, expr.left(), false);
                        sb.append(';');
                        this.generateAtom(sb, atom, expr.right(), false);
                        break;
                    }
                    this.generateAtom(sb, atom, expr.left(), withDisjunction);
                    int mark = sb.length();
                    this.generateAtom(sb, atom, expr.right(), withDisjunction);
                    Generator.maybeExplAnd(sb, mark);
                    break;
                }
                case OR: {
                    if (expr.left().type() == Expr.Type.STEREOCHEMISTRY && expr.right().type() == Expr.Type.STEREOCHEMISTRY && expr.right().value() == 0) {
                        this.generateAtom(sb, atom, expr.left(), true);
                        sb.append('?');
                        break;
                    }
                    this.generateAtom(sb, atom, expr.left(), true);
                    sb.append(',');
                    this.generateAtom(sb, atom, expr.right(), true);
                    break;
                }
                case NOT: {
                    sb.append('!');
                    switch (expr.left().type()) {
                        case AND: 
                        case OR: {
                            this.generateRecurAtom(sb, atom, expr.left());
                            break block0;
                        }
                    }
                    this.generateAtom(sb, atom, expr.left(), withDisjunction);
                    break;
                }
                case RECURSIVE: {
                    sb.append("$(").append(Smarts.generate(expr.subquery())).append(")");
                    break;
                }
                case STEREOCHEMISTRY: {
                    int order = expr.value();
                    if (atom != null && this.flipStereo(atom)) {
                        order ^= 3;
                    }
                    if (order == 1) {
                        sb.append('@');
                        break;
                    }
                    if (order == 2) {
                        sb.append("@@");
                        break;
                    }
                    throw new IllegalArgumentException();
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        static int parity4(IAtom[] b1, IAtom[] b2) {
            if (b1[0] == b2[0]) {
                if (b1[1] == b2[1]) {
                    if (b1[2] == b2[2] && b1[3] == b2[3]) {
                        return 2;
                    }
                    if (b1[2] == b2[3] && b1[3] == b2[2]) {
                        return 1;
                    }
                } else if (b1[1] == b2[2]) {
                    if (b1[2] == b2[1] && b1[3] == b2[3]) {
                        return 1;
                    }
                    if (b1[2] == b2[3] && b1[3] == b2[1]) {
                        return 2;
                    }
                } else if (b1[1] == b2[3]) {
                    if (b1[2] == b2[2] && b1[3] == b2[1]) {
                        return 1;
                    }
                    if (b1[2] == b2[1] && b1[3] == b2[2]) {
                        return 2;
                    }
                }
            } else if (b1[0] == b2[1]) {
                if (b1[1] == b2[0]) {
                    if (b1[2] == b2[2] && b1[3] == b2[3]) {
                        return 1;
                    }
                    if (b1[2] == b2[3] && b1[3] == b2[2]) {
                        return 2;
                    }
                } else if (b1[1] == b2[2]) {
                    if (b1[2] == b2[0] && b1[3] == b2[3]) {
                        return 2;
                    }
                    if (b1[2] == b2[3] && b1[3] == b2[0]) {
                        return 1;
                    }
                } else if (b1[1] == b2[3]) {
                    if (b1[2] == b2[2] && b1[3] == b2[0]) {
                        return 2;
                    }
                    if (b1[2] == b2[0] && b1[3] == b2[2]) {
                        return 1;
                    }
                }
            } else if (b1[0] == b2[2]) {
                if (b1[1] == b2[1]) {
                    if (b1[2] == b2[0] && b1[3] == b2[3]) {
                        return 1;
                    }
                    if (b1[2] == b2[3] && b1[3] == b2[0]) {
                        return 2;
                    }
                } else if (b1[1] == b2[0]) {
                    if (b1[2] == b2[1] && b1[3] == b2[3]) {
                        return 2;
                    }
                    if (b1[2] == b2[3] && b1[3] == b2[1]) {
                        return 1;
                    }
                } else if (b1[1] == b2[3]) {
                    if (b1[2] == b2[0] && b1[3] == b2[1]) {
                        return 2;
                    }
                    if (b1[2] == b2[1] && b1[3] == b2[0]) {
                        return 1;
                    }
                }
            } else if (b1[0] == b2[3]) {
                if (b1[1] == b2[1]) {
                    if (b1[2] == b2[2] && b1[3] == b2[0]) {
                        return 1;
                    }
                    if (b1[2] == b2[0] && b1[3] == b2[2]) {
                        return 2;
                    }
                } else if (b1[1] == b2[2]) {
                    if (b1[2] == b2[1] && b1[3] == b2[0]) {
                        return 2;
                    }
                    if (b1[2] == b2[0] && b1[3] == b2[1]) {
                        return 1;
                    }
                } else if (b1[1] == b2[0]) {
                    if (b1[2] == b2[2] && b1[3] == b2[1]) {
                        return 2;
                    }
                    if (b1[2] == b2[1] && b1[3] == b2[2]) {
                        return 1;
                    }
                }
            }
            return 0;
        }

        public String generate(IAtom end, QueryBond bond) {
            String bexpr = Smarts.generateBond(bond.getExpression());
            if (this.bdirs.containsKey(bond)) {
                String bdir = this.bdirs.get(bond);
                if (bond.getBegin().equals(end)) {
                    switch (bdir) {
                        case "\\": {
                            bdir = Smarts.BSTEREO_UP;
                            break;
                        }
                        case "/": {
                            bdir = Smarts.BSTEREO_DN;
                            break;
                        }
                        case "\\?": {
                            bdir = Smarts.BSTEREO_UPU;
                            break;
                        }
                        case "/?": {
                            bdir = Smarts.BSTEREO_DNU;
                        }
                    }
                }
                bexpr = bexpr.isEmpty() ? bdir : bexpr + ';' + bdir;
            }
            return bexpr;
        }

        private boolean flipStereo(IAtom atom) {
            List<IBond> bonds = this.nbrs.get(atom);
            for (IStereoElement se : this.mol.stereoElements()) {
                if (se.getConfigClass() != 16896 || !se.getFocus().equals(atom)) continue;
                List src = se.getCarriers();
                ArrayList<IAtom> dst = new ArrayList<IAtom>();
                for (IBond bond : bonds) {
                    dst.add(bond.getOther(atom));
                }
                if (dst.size() == 3) {
                    if (this.avisit.contains(dst.get(0))) {
                        dst.add(1, atom);
                    } else {
                        dst.add(0, atom);
                    }
                }
                return Generator.parity4(src.toArray(new IAtom[4]), dst.toArray(new IAtom[4])) == 1;
            }
            return false;
        }

        private static void maybeExplAnd(StringBuilder sb, int mark) {
            if (Smarts.isDigit(sb.charAt(mark)) || Smarts.isUpper(sb.charAt(mark - 1)) && Smarts.isLower(sb.charAt(mark))) {
                sb.insert(mark, '&');
            }
        }

        String generateAtom(IAtom atom, Expr expr) {
            int mapidx;
            if (expr.type() == Expr.Type.AND) {
                if (expr.left().type() == Expr.Type.REACTION_ROLE) {
                    return this.generateAtom(atom, expr.right());
                }
                if (expr.right().type() == Expr.Type.REACTION_ROLE) {
                    return this.generateAtom(atom, expr.left());
                }
            }
            int n = mapidx = atom != null ? Smarts.mapidx(atom) : 0;
            if (mapidx == 0) {
                switch (expr.type()) {
                    case TRUE: {
                        return "*";
                    }
                    case IS_AROMATIC: {
                        return "a";
                    }
                    case IS_ALIPHATIC: {
                        return "A";
                    }
                    case ELEMENT: {
                        switch (expr.value()) {
                            case 9: {
                                return "F";
                            }
                            case 17: {
                                return "Cl";
                            }
                            case 35: {
                                return "Br";
                            }
                            case 53: {
                                return "I";
                            }
                        }
                        break;
                    }
                    case AROMATIC_ELEMENT: {
                        switch (expr.value()) {
                            case 5: {
                                return "b";
                            }
                            case 6: {
                                return "c";
                            }
                            case 7: {
                                return "n";
                            }
                            case 8: {
                                return "o";
                            }
                            case 15: {
                                return "p";
                            }
                            case 16: {
                                return "s";
                            }
                        }
                        break;
                    }
                    case ALIPHATIC_ELEMENT: {
                        switch (expr.value()) {
                            case 5: {
                                return "B";
                            }
                            case 6: {
                                return "C";
                            }
                            case 7: {
                                return "N";
                            }
                            case 8: {
                                return "O";
                            }
                            case 9: {
                                return "F";
                            }
                            case 15: {
                                return "P";
                            }
                            case 16: {
                                return "S";
                            }
                            case 17: {
                                return "Cl";
                            }
                            case 35: {
                                return "Br";
                            }
                            case 53: {
                                return "I";
                            }
                        }
                    }
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            this.generateAtom(sb, atom, expr, false);
            if (mapidx != 0) {
                sb.append(':').append(mapidx);
            }
            sb.append(']');
            return sb.toString();
        }

        private void writePart(StringBuilder sb, IAtom atom, IBond prev) {
            List<IBond> bonds = this.nbrs.get(atom);
            int remain = bonds.size();
            this.sort(bonds, prev);
            if (prev != null) {
                --remain;
                sb.append(this.generate(atom, (QueryBond)BondRef.deref(prev)));
            }
            sb.append(this.generateAtom(atom, ((QueryAtom)AtomRef.deref(atom)).getExpression()));
            this.avisit.add(atom);
            for (IBond bond : bonds) {
                if (bond == prev) continue;
                if (this.isRingClose(bond)) {
                    Integer rnum = this.rnums.get(bond);
                    sb.append(this.generate(bond.getOther(atom), (QueryBond)BondRef.deref(bond)));
                    if (rnum >= 10) {
                        sb.append('%');
                    }
                    sb.append(rnum);
                    this.rvisit[rnum.intValue()] = false;
                    this.rnums.remove(bond);
                    --remain;
                    continue;
                }
                if (this.isRingOpen(bond)) {
                    int rnum = this.nextRingNum();
                    if (rnum >= 10) {
                        sb.append('%');
                    }
                    sb.append(rnum);
                    this.rnums.put(bond, rnum);
                    this.rbonds.remove(bond);
                    --remain;
                    continue;
                }
                IAtom other = bond.getOther(atom);
                if (--remain != 0) {
                    sb.append('(');
                }
                this.writePart(sb, other, bond);
                if (remain == 0) continue;
                sb.append(')');
            }
        }

        private void writeParts(IAtom[] atoms, StringBuilder sb, ReactionRole role) {
            boolean first = true;
            int prevComp = 0;
            for (IAtom atom : atoms) {
                if (role != null && Smarts.role(atom) != role || this.avisit.contains(atom)) continue;
                int currComp = Smarts.compGroup(atom);
                if (prevComp != currComp && prevComp != 0) {
                    sb.append(')');
                }
                if (!first) {
                    sb.append('.');
                }
                if (currComp != prevComp && currComp != 0) {
                    sb.append('(');
                }
                this.writePart(sb, atom, null);
                first = false;
                prevComp = currComp;
            }
            if (prevComp != 0) {
                sb.append(')');
            }
        }

        public String generate() {
            IAtom[] atoms = AtomContainerManipulator.getAtomArray(this.mol);
            this.sortAtoms(atoms);
            for (IAtom atom : atoms) {
                if (this.avisit.contains(atom)) continue;
                this.markRings(atom, null);
            }
            this.avisit.clear();
            this.setBondDirs(this.mol);
            boolean isRxn = Smarts.role(atoms[atoms.length - 1]) != ReactionRole.None;
            StringBuilder sb = new StringBuilder();
            if (isRxn) {
                this.writeParts(atoms, sb, ReactionRole.Reactant);
                sb.append('>');
                this.writeParts(atoms, sb, ReactionRole.Agent);
                sb.append('>');
                this.writeParts(atoms, sb, ReactionRole.Product);
            } else {
                this.writeParts(atoms, sb, null);
            }
            return sb.toString();
        }

        private void sortAtoms(IAtom[] atoms) {
            Arrays.sort(atoms, new Comparator<IAtom>(){

                @Override
                public int compare(IAtom a, IAtom b) {
                    int cmp = Smarts.role(a).compareTo(Smarts.role(b));
                    if (cmp != 0) {
                        return cmp;
                    }
                    return Integer.compare(Smarts.compGroup(a), Smarts.compGroup(b));
                }
            });
        }
    }

    private static final class LocalNbrs {
        final List<IBond> bonds = new ArrayList<IBond>(4);
        final boolean isFirst;

        LocalNbrs(boolean first) {
            this.isFirst = first;
        }
    }
}

